/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.audio.tape;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import pl.asie.charset.api.tape.IDataStorage;
import pl.asie.charset.audio.ModCharsetAudio;
import pl.asie.charset.audio.storage.DataStorageImpl;
import pl.asie.charset.audio.tape.TapeUtils;
import pl.asie.charset.lib.ModCharsetLib;
import pl.asie.charset.lib.items.IDyeableItem;

public class ItemTape
extends Item
implements IDyeableItem {
    public static final Map<String, Material> materialByName = new HashMap<String, Material>();
    public static final int DEFAULT_SAMPLE_RATE = 48000;
    private static final int DEFAULT_SIZE = 2880000;

    public ItemTape() {
        this.func_77655_b("charset.tape");
        this.func_77637_a(ModCharsetLib.CREATIVE_TAB);
        this.func_77625_d(1);
    }

    public String func_77667_c(ItemStack stack) {
        Material mat = this.getMaterial(stack);
        return "item.charset.tape" + (mat != null ? "." + mat.name().toLowerCase() : "");
    }

    public static ItemStack asItemStack(int size, Material material) {
        ItemStack stack = new ItemStack((Item)ModCharsetAudio.tapeItem);
        stack.func_77982_d(new NBTTagCompound());
        stack.func_77978_p().func_74768_a("size", size);
        stack.func_77978_p().func_74778_a("material", material.name());
        return stack;
    }

    public Material getMaterial(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b("material") ? materialByName.get(stack.func_77978_p().func_74779_i("material")) : null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        for (Material mat : Material.values()) {
            if (!OreDictionary.doesOreNameExist((String)mat.oreDict)) continue;
            subItems.add(ItemTape.asItemStack(2880000, mat));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        Material mat = this.getMaterial(stack);
        if (mat != null && mat.subtitle != null) {
            tooltip.add(mat.subtitle + I18n.func_74838_a((String)(this.func_77667_c(stack) + ".tip")));
        }
        int size = stack.func_77942_o() && stack.func_77978_p().func_74764_b("size") ? stack.func_77978_p().func_74762_e("size") : 2880000;
        int sizeSec = size / 6000;
        int sizeMin = sizeSec / 60;
        TapeUtils.addTooltip(tooltip, sizeMin, sizeSec %= 60);
    }

    @Override
    public int getColor(ItemStack stack) {
        if (this.hasColor(stack)) {
            return stack.func_77978_p().func_74762_e("labelColor");
        }
        return 15790312;
    }

    @Override
    public boolean hasColor(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b("labelColor");
    }

    @Override
    public void setColor(ItemStack stack, int color) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a("labelColor", color);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new CapabilityProvider(stack);
    }

    public static class CapabilityProvider
    implements INBTSerializable<NBTTagCompound>,
    ICapabilityProvider {
        private final ItemStack stack;
        private final IDataStorage dataStorage;

        public CapabilityProvider(ItemStack stack) {
            this.stack = stack;
            this.dataStorage = (IDataStorage)ModCharsetAudio.CAP_STORAGE.getDefaultInstance();
        }

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return capability == ModCharsetAudio.CAP_STORAGE;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            if (this.dataStorage != null) {
                if (!this.dataStorage.isInitialized()) {
                    this.dataStorage.initialize(null, 0, this.stack.func_77942_o() && this.stack.func_77978_p().func_74764_b("size") ? this.stack.func_77978_p().func_74762_e("size") : 2880000);
                }
                if (capability == ModCharsetAudio.CAP_STORAGE) {
                    if (!((DataStorageImpl)this.dataStorage).makeReady()) {
                        return null;
                    }
                    return (T)ModCharsetAudio.CAP_STORAGE.cast((Object)this.dataStorage);
                }
            }
            return null;
        }

        public NBTTagCompound serializeNBT() {
            if (this.dataStorage != null) {
                NBTTagCompound compound = new NBTTagCompound();
                NBTBase data = ModCharsetAudio.CAP_STORAGE.writeNBT((Object)this.dataStorage, null);
                if (data != null) {
                    compound.func_74782_a("data", data);
                }
                return compound;
            }
            return new NBTTagCompound();
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            if (this.dataStorage != null && nbt.func_74764_b("data")) {
                ModCharsetAudio.CAP_STORAGE.readNBT((Object)this.dataStorage, null, (NBTBase)nbt.func_74775_l("data"));
            }
        }
    }

    public static enum Material {
        IRON("ingotIron", 0x8C8C8C),
        GOLD("ingotGold", 15786080, TextFormatting.YELLOW + ""),
        DIAMOND("gemDiamond", 6349040, TextFormatting.AQUA + ""),
        EMERALD("gemEmerald", 5300352, TextFormatting.GREEN + ""),
        QUARTZ("gemQuartz", 0xE0E0E0, TextFormatting.WHITE + ""),
        RUBY("gemRuby", 0xE05050),
        SAPPHIRE("gemSapphire", 3162336),
        DARK_IRON("ingotDarkIron", 5255296, TextFormatting.DARK_PURPLE + "");

        public final String oreDict;
        public final String subtitle;
        public final int color;

        private Material(String oreDict, int color) {
            this(oreDict, color, null);
        }

        private Material(String oreDict, int color, String subtitle) {
            this.oreDict = oreDict;
            this.color = color;
            this.subtitle = subtitle;
            materialByName.put(this.name(), this);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class Color
    implements IItemColor {
        private final ItemTape item;

        public Color(ItemTape item) {
            this.item = item;
        }

        public int func_186726_a(ItemStack stack, int renderPass) {
            switch (renderPass) {
                default: {
                    return 0xFFFFFF;
                }
                case 1: {
                    Material mat = this.item.getMaterial(stack);
                    return mat != null ? mat.color : Material.IRON.color;
                }
                case 2: 
            }
            return this.item.getColor(stack);
        }
    }
}

