/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.audio.tape;

import java.io.File;
import java.util.ArrayList;
import javax.sound.sampled.AudioFormat;
import mcmultipart.multipart.IMultipart;
import net.minecraftforge.fml.common.Loader;
import org.apache.commons.io.FilenameUtils;
import paulscode.sound.ICodec;
import paulscode.sound.SoundBuffer;
import paulscode.sound.codecs.CodecJOrbis;
import paulscode.sound.codecs.CodecWav;
import pl.asie.charset.audio.ModCharsetAudio;
import pl.asie.charset.audio.tape.PacketDriveRecord;
import pl.asie.charset.audio.tape.PartTapeDrive;
import pl.asie.charset.audio.tape.TapeResampler;
import pl.asie.charset.lib.audio.codec.DFPWM;

public class TapeRecordThread
implements Runnable {
    private static final int PACKET_SIZE = 8192;
    private static final DFPWM CODEC = new DFPWM();
    private final File file;
    private final PartTapeDrive owner;
    private int sampleRate = 48000;
    private String statusBar = "Encoding...";

    public static String[] getSupportedExtensions() {
        ArrayList<String> exts = new ArrayList<String>();
        exts.add("ogg");
        exts.add("wav");
        if (Loader.isModLoaded((String)"NotEnoughCodecs")) {
            exts.add("aac");
            exts.add("mp3");
            exts.add("m4a");
            exts.add("mp4");
            exts.add("flac");
        }
        return exts.toArray(new String[exts.size()]);
    }

    public TapeRecordThread(File f, PartTapeDrive owner) {
        this.file = f;
        this.owner = owner;
    }

    public String getStatusBar() {
        return this.statusBar != null ? this.statusBar : "???";
    }

    @Override
    public void run() {
        try {
            String ext = FilenameUtils.getExtension((String)this.file.getName());
            CodecJOrbis codec = null;
            this.statusBar = "Loading...";
            if ("ogg".equals(ext)) {
                codec = new CodecJOrbis();
            } else if ("wav".equals(ext)) {
                codec = new CodecWav();
            } else if ("mp3".equals(ext)) {
                codec = (ICodec)this.getClass().getClassLoader().loadClass("openmods.codecs.adapters.CodecMP3").newInstance();
            } else if ("mp4".equals(ext) || "m4a".equals(ext)) {
                codec = (ICodec)this.getClass().getClassLoader().loadClass("openmods.codecs.adapters.CodecMP4").newInstance();
            } else if ("aac".equals(ext)) {
                codec = (ICodec)this.getClass().getClassLoader().loadClass("openmods.codecs.adapters.CodecADTS").newInstance();
            } else if ("flac".equals(ext)) {
                codec = (ICodec)this.getClass().getClassLoader().loadClass("openmods.codecs.adapters.CodecFLAC").newInstance();
            }
            if (codec == null) {
                this.statusBar = "Unsupported format!";
                Thread.sleep(1250L);
                return;
            }
            codec.initialize(this.file.toURI().toURL());
            if (!codec.initialized()) {
                this.statusBar = "Failed to load!";
                Thread.sleep(1250L);
                return;
            }
            SoundBuffer buffer = codec.readAll();
            if (buffer == null) {
                this.statusBar = "Failed to load!";
                Thread.sleep(1250L);
                return;
            }
            this.statusBar = "Reticulating splines...";
            byte[] preEncodeOutput = TapeResampler.toSigned8(buffer.audioData, buffer.audioFormat.getSampleSizeInBits(), buffer.audioFormat.getChannels(), buffer.audioFormat.isBigEndian(), buffer.audioFormat.getEncoding() == AudioFormat.Encoding.PCM_SIGNED, (int)buffer.audioFormat.getSampleRate(), this.sampleRate, true);
            this.statusBar = "Encoding...";
            byte[] finalOutput = new byte[preEncodeOutput.length + 7 >> 3];
            CODEC.compress(finalOutput, preEncodeOutput, 0, 0, finalOutput.length);
            for (int i = 0; i < finalOutput.length; i += 8192) {
                int len = Math.min(finalOutput.length - i, 8192);
                byte[] data = new byte[len];
                System.arraycopy(finalOutput, i, data, 0, len);
                this.statusBar = "Uploading (" + i * 100 / finalOutput.length + "%)...";
                ModCharsetAudio.packet.sendToServer(new PacketDriveRecord((IMultipart)this.owner, data, finalOutput.length, i + len >= finalOutput.length));
            }
            this.statusBar = "Uploading (100%)...";
            Thread.sleep(250L);
            this.statusBar = "Uploaded!";
            Thread.sleep(1250L);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.statusBar = "Strange error!";
            try {
                Thread.sleep(1250L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

