/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.audio.transport;

import java.util.HashSet;
import java.util.Set;
import mcmultipart.multipart.PartSlot;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.common.capabilities.Capability;
import pl.asie.charset.api.audio.AudioPacket;
import pl.asie.charset.api.audio.IAudioReceiver;
import pl.asie.charset.api.wires.WireFace;
import pl.asie.charset.lib.Capabilities;
import pl.asie.charset.lib.utils.CapabilityUtils;
import pl.asie.charset.lib.utils.MultipartUtils;
import pl.asie.charset.lib.wires.PartWire;
import pl.asie.charset.wires.WireUtils;

public class PartAudioCable
extends PartWire
implements IAudioReceiver {
    private final Set<AudioPacket> receivedPackets = new HashSet<AudioPacket>();

    @Override
    public void func_73660_a() {
        this.receivedPackets.clear();
        super.func_73660_a();
    }

    @Override
    protected void logicUpdate() {
    }

    @Override
    public String getDisplayName() {
        return I18n.func_74838_a((String)"tile.charset.audioCable.name");
    }

    @Override
    public boolean calculateConnectionNonWire(BlockPos pos, EnumFacing direction) {
        if (MultipartUtils.hasCapability(Capabilities.AUDIO_SOURCE, this.getWorld(), pos, WireUtils.getSlotForFace(this.location), direction)) {
            return true;
        }
        return MultipartUtils.hasCapability(Capabilities.AUDIO_RECEIVER, this.getWorld(), pos, WireUtils.getSlotForFace(this.location), direction);
    }

    private boolean receive(BlockPos pos, EnumFacing facing, AudioPacket packet) {
        if (CapabilityUtils.hasCapability(this.getWorld(), pos, Capabilities.AUDIO_RECEIVER, facing, true, false)) {
            return CapabilityUtils.getCapability(this.getWorld(), pos, Capabilities.AUDIO_RECEIVER, facing, true, false).receive(packet);
        }
        return false;
    }

    private boolean receive(BlockPos pos, WireFace face, EnumFacing facing, AudioPacket packet) {
        PartSlot slot = WireUtils.getSlotForFace(face);
        if (MultipartUtils.hasCapability(Capabilities.AUDIO_RECEIVER, this.getWorld(), pos, slot, facing)) {
            return MultipartUtils.getCapability(Capabilities.AUDIO_RECEIVER, this.getWorld(), pos, slot, facing).receive(packet);
        }
        return false;
    }

    @Override
    public boolean receive(AudioPacket packet) {
        if (this.receivedPackets.contains(packet)) {
            return false;
        }
        this.receivedPackets.add(packet);
        boolean received = false;
        if (this.location != WireFace.CENTER) {
            received |= this.receive(this.getPos().func_177972_a(this.location.facing), this.location.facing.func_176734_d(), packet);
        }
        for (WireFace face : WireFace.VALUES) {
            if (this.connectsInternal(face)) {
                received |= this.receive(this.getPos(), face, this.location.facing, packet);
                continue;
            }
            if (face == WireFace.CENTER) continue;
            if (this.connectsExternal(face.facing)) {
                received |= this.receive(this.getPos().func_177972_a(face.facing), this.location, face.facing.func_176734_d(), packet);
                continue;
            }
            if (!this.connectsCorner(face.facing)) continue;
            received |= this.receive(this.getPos().func_177972_a(face.facing).func_177972_a(this.location.facing), WireFace.get(face.facing.func_176734_d()), this.location.facing.func_176734_d(), packet);
        }
        return true;
    }

    public boolean hasCapability(Capability<?> capability, PartSlot slot, EnumFacing facing) {
        if (capability == Capabilities.AUDIO_RECEIVER) {
            return slot == WireUtils.getSlotForFace(this.location) ? facing == null || this.connects(facing) : false;
        }
        return false;
    }

    public <T> T getCapability(Capability<T> capability, PartSlot slot, EnumFacing facing) {
        if (this.hasCapability(capability, slot, facing)) {
            return (T)(capability == Capabilities.AUDIO_RECEIVER ? Capabilities.AUDIO_RECEIVER.cast((Object)this) : null);
        }
        return null;
    }
}

