/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.gates;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import mcmultipart.MCMultiPartMod;
import mcmultipart.capabilities.ISlottedCapabilityProvider;
import mcmultipart.multipart.IMultipart;
import mcmultipart.multipart.IMultipartContainer;
import mcmultipart.multipart.INormallyOccludingPart;
import mcmultipart.multipart.IRedstonePart;
import mcmultipart.multipart.Multipart;
import mcmultipart.multipart.MultipartHelper;
import mcmultipart.multipart.MultipartRedstoneHelper;
import mcmultipart.multipart.PartSlot;
import mcmultipart.raytrace.PartMOP;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import pl.asie.charset.api.wires.IBundledEmitter;
import pl.asie.charset.api.wires.IBundledReceiver;
import pl.asie.charset.api.wires.IRedstoneEmitter;
import pl.asie.charset.api.wires.IRedstoneReceiver;
import pl.asie.charset.gates.ItemGate;
import pl.asie.charset.lib.Capabilities;
import pl.asie.charset.lib.render.IRenderComparable;
import pl.asie.charset.lib.utils.GenericExtendedProperty;
import pl.asie.charset.lib.utils.ItemUtils;
import pl.asie.charset.lib.utils.RedstoneUtils;
import pl.asie.charset.lib.utils.RotationUtils;

public abstract class PartGate
extends Multipart
implements IRenderComparable<PartGate>,
IRedstonePart.ISlottedRedstonePart,
INormallyOccludingPart,
ISlottedCapabilityProvider,
ITickable {
    public static final GenericExtendedProperty<PartGate> PROPERTY = new GenericExtendedProperty<PartGate>("part", PartGate.class);
    private static final AxisAlignedBB[] BOXES = new AxisAlignedBB[6];
    private static final Vec3d[][] HIT_VECTORS = new Vec3d[6][];
    private final RedstoneCommunications[] COMMS = new RedstoneCommunications[4];
    protected byte enabledSides;
    protected byte invertedSides;
    protected boolean mirrored;
    private int pendingTick;
    private byte[] values = new byte[4];
    private EnumFacing side = EnumFacing.DOWN;
    private EnumFacing top = EnumFacing.NORTH;
    private final EnumFacing[][] CONNECTION_DIRS = new EnumFacing[][]{{EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.EAST}, {EnumFacing.SOUTH, EnumFacing.NORTH, EnumFacing.WEST, EnumFacing.EAST}, {EnumFacing.UP, EnumFacing.DOWN, EnumFacing.WEST, EnumFacing.EAST}, {EnumFacing.UP, EnumFacing.DOWN, EnumFacing.EAST, EnumFacing.WEST}, {EnumFacing.UP, EnumFacing.DOWN, EnumFacing.SOUTH, EnumFacing.NORTH}, {EnumFacing.UP, EnumFacing.DOWN, EnumFacing.NORTH, EnumFacing.SOUTH}};

    public PartGate() {
        this.enabledSides = this.getSideMask();
        this.COMMS[0] = new RedstoneCommunications(EnumFacing.NORTH);
        this.COMMS[1] = new RedstoneCommunications(EnumFacing.SOUTH);
        this.COMMS[2] = new RedstoneCommunications(EnumFacing.WEST);
        this.COMMS[3] = new RedstoneCommunications(EnumFacing.EAST);
    }

    PartGate setSide(EnumFacing facing) {
        this.side = facing;
        return this;
    }

    PartGate setTop(EnumFacing facing) {
        this.top = facing;
        return this;
    }

    PartGate setInvertedSides(int sides) {
        this.invertedSides = (byte)sides;
        return this;
    }

    public boolean isMirrored() {
        return this.mirrored;
    }

    public Connection getType(EnumFacing dir) {
        return dir == EnumFacing.NORTH ? Connection.OUTPUT : Connection.INPUT;
    }

    public abstract State getLayerState(int var1);

    public abstract State getTorchState(int var1);

    public boolean canBlockSide(EnumFacing side) {
        return this.getType(side).isInput();
    }

    public boolean canInvertSide(EnumFacing side) {
        return this.getType(side).isDigital();
    }

    public boolean hasCapability(Capability<?> capability, PartSlot partSlot, EnumFacing direction) {
        EnumFacing dir;
        if (partSlot.f1 == this.side && direction.func_176740_k() != this.side.func_176740_k() && this.isSideOpen(dir = this.realToGate(direction))) {
            Connection conn = this.getType(dir);
            if (capability == Capabilities.BUNDLED_EMITTER && conn.isOutput() && conn.isBundled()) {
                return true;
            }
            if (capability == Capabilities.BUNDLED_RECEIVER && conn.isInput() && conn.isBundled()) {
                return true;
            }
            if (capability == Capabilities.REDSTONE_EMITTER && conn.isOutput() && conn.isRedstone()) {
                return true;
            }
            if (capability == Capabilities.REDSTONE_RECEIVER && conn.isInput() && conn.isRedstone()) {
                return true;
            }
        }
        return false;
    }

    public <T> T getCapability(Capability<T> capability, PartSlot partSlot, EnumFacing enumFacing) {
        if (!this.hasCapability(capability, partSlot, enumFacing)) {
            return null;
        }
        EnumFacing dir = this.realToGate(enumFacing);
        if (dir.ordinal() >= 2) {
            return (T)this.COMMS[dir.ordinal() - 2];
        }
        return null;
    }

    public ItemStack getPickBlock(EntityPlayer player, PartMOP hit) {
        return ItemGate.getStack(this, true);
    }

    public List<ItemStack> getDrops() {
        return Arrays.asList(ItemGate.getStack(this, false));
    }

    public List<ItemStack> getDrops(EntityPlayer player) {
        ItemStack[] itemStackArray = new ItemStack[1];
        itemStackArray[0] = ItemGate.getStack(this, player != null ? EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)player.func_184614_ca()) > 0 : false);
        return Arrays.asList(itemStackArray);
    }

    public void harvest(EntityPlayer player, PartMOP hit) {
        World world = this.getWorld();
        BlockPos pos = this.getPos();
        double x = (double)pos.func_177958_n() + 0.5;
        double y = (double)pos.func_177956_o() + 0.25;
        double z = (double)pos.func_177952_p() + 0.5;
        if (!(player != null && player.field_71075_bZ.field_75098_d || world.field_72995_K || !world.func_82736_K().func_82766_b("doTileDrops") || world.restoringBlockSnapshots)) {
            for (ItemStack stack : this.getDrops(player)) {
                EntityItem item = new EntityItem(world, x, y, z, stack);
                item.func_174869_p();
                world.func_72838_d((Entity)item);
            }
        }
        this.getContainer().removePart((IMultipart)this);
    }

    public void func_73660_a() {
        if (this.getWorld() != null && !this.getWorld().field_72995_K && this.pendingTick > 0) {
            --this.pendingTick;
            if (this.pendingTick == 0 && this.tick()) {
                this.notifyBlockUpdate();
                this.sendUpdatePacket();
            }
        }
    }

    protected boolean tick() {
        return this.updateInputs();
    }

    private boolean updateInputs() {
        Connection conn;
        EnumFacing facing;
        int i;
        byte[] oldValues = new byte[4];
        boolean changed = false;
        System.arraycopy(this.values, 0, oldValues, 0, 4);
        for (i = 0; i <= 3; ++i) {
            BlockPos p;
            facing = EnumFacing.func_82600_a((int)(i + 2));
            conn = this.getType(facing);
            if (!conn.isInput() || !conn.isRedstone()) continue;
            this.values[i] = 0;
            if (!this.isSideOpen(facing)) continue;
            EnumFacing real = this.gateToReal(facing);
            World w = this.getWorld();
            IMultipartContainer container = MultipartHelper.getPartContainer((IBlockAccess)w, (BlockPos)(p = this.getPos().func_177972_a(real)));
            if (container != null) {
                this.values[i] = (byte)MultipartRedstoneHelper.getWeakSignal((IMultipartContainer)container, (EnumFacing)real.func_176734_d(), (EnumFacing)this.side);
            } else {
                TileEntity tile = w.func_175625_s(p);
                if (tile != null && tile.hasCapability(Capabilities.REDSTONE_EMITTER, real.func_176734_d())) {
                    this.values[i] = (byte)((IRedstoneEmitter)tile.getCapability(Capabilities.REDSTONE_EMITTER, real.func_176734_d())).getRedstoneSignal();
                } else {
                    IBlockState s = w.func_180495_p(p);
                    if (RedstoneUtils.canConnectFace((IBlockAccess)w, p, s, real, this.side)) {
                        this.values[i] = s.func_177230_c() instanceof BlockRedstoneWire ? ((Integer)s.func_177229_b((IProperty)BlockRedstoneWire.field_176351_O)).byteValue() : (byte)s.func_185911_a((IBlockAccess)w, p, real);
                    }
                }
            }
            if (conn.isDigital()) {
                int n = this.values[i] = this.values[i] != 0 ? 15 : 0;
            }
            if (!this.isSideInverted(facing)) continue;
            this.values[i] = this.values[i] != 0 ? 0 : 15;
        }
        for (i = 0; i <= 3; ++i) {
            facing = EnumFacing.func_82600_a((int)(i + 2));
            conn = this.getType(facing);
            if (conn.isOutput() && conn.isRedstone()) {
                this.values[i] = this.calculateOutputInside(facing);
            }
            if (this.values[i] == oldValues[i]) continue;
            changed = true;
        }
        return changed;
    }

    public byte getValueInside(EnumFacing side) {
        return this.values[side.ordinal() - 2];
    }

    protected byte getValueOutside(EnumFacing side) {
        if (this.isSideInverted(side) && this.isSideOpen(side)) {
            return this.values[side.ordinal() - 2] != 0 ? (byte)0 : 15;
        }
        return this.values[side.ordinal() - 2];
    }

    public boolean getInverterState(EnumFacing facing) {
        byte value = this.getType(facing).isInput() ? this.getValueOutside(facing) : this.getValueInside(facing);
        return value == 0;
    }

    protected void onChanged() {
        this.scheduleTick();
    }

    protected void scheduleTick() {
        if (this.pendingTick == 0) {
            this.pendingTick = 2;
        }
    }

    public void onAdded() {
        this.pendingTick = 1;
    }

    public void onLoaded() {
        this.pendingTick = 1;
    }

    public void onPartChanged(IMultipart part) {
        this.onChanged();
    }

    public void onNeighborBlockChange(Block block) {
        if (!this.getWorld().isSideSolid(this.getPos().func_177972_a(this.side), this.side.func_176734_d())) {
            this.harvest(null, null);
            return;
        }
        this.onChanged();
    }

    public EnumFacing[] getValidRotations() {
        return new EnumFacing[]{this.side, this.side.func_176734_d()};
    }

    public boolean rotatePart(EnumFacing axis) {
        if (axis.func_176740_k() == this.side.func_176740_k()) {
            this.top = axis.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? this.top.func_176746_e() : this.top.func_176735_f();
            this.notifyBlockUpdate();
            this.onChanged();
            this.sendUpdatePacket();
            return true;
        }
        return false;
    }

    public EnumFacing getSide() {
        return this.side;
    }

    public EnumFacing getTop() {
        return this.top;
    }

    protected byte getSideMask() {
        byte j = 0;
        for (int i = 0; i <= 3; ++i) {
            if (this.getType(EnumFacing.func_82600_a((int)(i + 2))) == Connection.NONE) continue;
            j = (byte)(j | 1 << i);
        }
        return j;
    }

    protected abstract byte calculateOutputInside(EnumFacing var1);

    public boolean isSideOpen(EnumFacing side) {
        return (this.enabledSides & 1 << side.ordinal() - 2) != 0;
    }

    public boolean isSideInverted(EnumFacing side) {
        return (this.invertedSides & 1 << side.ordinal() - 2) != 0;
    }

    private EnumFacing getClosestFace(Vec3d vec) {
        Vec3d[] compare = HIT_VECTORS[this.getSide().ordinal()];
        int closestFace = -1;
        double distance = Double.MAX_VALUE;
        for (int i = 0; i < 4; ++i) {
            double d = compare[i].func_72438_d(vec);
            if (!(d < distance)) continue;
            closestFace = i;
            distance = d;
        }
        if (closestFace >= 0) {
            EnumFacing dir = EnumFacing.func_82600_a((int)(closestFace + 2));
            for (EnumFacing itop = this.top; itop != EnumFacing.NORTH; itop = itop.func_176735_f()) {
                dir = dir.func_176735_f();
            }
            return dir;
        }
        return null;
    }

    public boolean onActivated(EntityPlayer playerIn, ItemStack stack, Vec3d vec) {
        boolean changed = false;
        boolean remote = this.getWorld().field_72995_K;
        if (stack != null) {
            EnumFacing closestFace;
            Block block;
            if (stack.func_77973_b() instanceof ItemBlock && ((block = Block.func_149634_a((Item)stack.func_77973_b())) == Blocks.field_150429_aA || block == Blocks.field_150437_az) && (closestFace = this.getClosestFace(vec.func_178786_a((double)this.getPos().func_177958_n(), (double)this.getPos().func_177956_o(), (double)this.getPos().func_177952_p()))) != null && this.canInvertSide(closestFace) && !this.isSideInverted(closestFace)) {
                if (!remote) {
                    this.invertedSides = (byte)(this.invertedSides | 1 << closestFace.ordinal() - 2);
                    --stack.field_77994_a;
                }
                changed = true;
            }
        } else {
            EnumFacing closestFace = this.getClosestFace(vec.func_178786_a((double)this.getPos().func_177958_n(), (double)this.getPos().func_177956_o(), (double)this.getPos().func_177952_p()));
            if (closestFace != null) {
                if (this.canInvertSide(closestFace) && this.isSideInverted(closestFace)) {
                    if (!remote) {
                        this.invertedSides = (byte)(this.invertedSides & ~(1 << closestFace.ordinal() - 2));
                        ItemUtils.spawnItemEntity(this.getWorld(), vec, new ItemStack(Blocks.field_150429_aA), 0.0f, 0.2f, 0.0f, 0.1f);
                    }
                    changed = true;
                } else if (playerIn.func_70093_af() && closestFace != null && this.canBlockSide(closestFace)) {
                    if (!remote) {
                        this.enabledSides = (byte)(this.enabledSides ^ 1 << closestFace.ordinal() - 2);
                    }
                    changed = true;
                }
            }
        }
        if (changed) {
            if (!remote) {
                this.notifyBlockUpdate();
                this.onChanged();
                this.sendUpdatePacket();
            }
            return true;
        }
        return false;
    }

    public boolean onActivated(EntityPlayer playerIn, EnumHand hand, ItemStack stack, PartMOP hit) {
        return this.onActivated(playerIn, stack, hit.field_72307_f);
    }

    public float getHardness(PartMOP hit) {
        return 0.5f;
    }

    public ResourceLocation getModelPath() {
        return this.getType();
    }

    public String getModelName() {
        return "base";
    }

    public EnumSet<PartSlot> getSlotMask() {
        return EnumSet.of(PartSlot.getFaceSlot((EnumFacing)this.side));
    }

    public boolean canConnectRedstone(EnumFacing direction) {
        EnumFacing dir;
        if (this.side.func_176740_k() != direction.func_176740_k() && (dir = this.realToGate(direction)) != null && this.isSideOpen(dir)) {
            return this.getType(dir).isRedstone();
        }
        return false;
    }

    public int getWeakSignal(EnumFacing facing) {
        EnumFacing dir = this.realToGate(facing);
        if (dir != null && this.getType(dir).isOutput() && this.getType(dir).isRedstone() && this.isSideOpen(dir)) {
            return this.getValueOutside(dir);
        }
        return 0;
    }

    public int getStrongSignal(EnumFacing facing) {
        return 0;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.func_74773_a("v", this.values);
        tag.func_74774_a("e", this.enabledSides);
        tag.func_74774_a("i", this.invertedSides);
        tag.func_74774_a("f", (byte)this.side.ordinal());
        tag.func_74774_a("t", (byte)this.top.ordinal());
        tag.func_74757_a("m", this.mirrored);
        if (this.pendingTick != 0) {
            tag.func_74774_a("p", (byte)this.pendingTick);
        }
        return tag;
    }

    public void readItemNBT(NBTTagCompound tag) {
        if (tag.func_74764_b("e")) {
            this.enabledSides = tag.func_74771_c("e");
        }
        if (tag.func_74764_b("i")) {
            this.invertedSides = tag.func_74771_c("i");
        }
    }

    public void writeItemNBT(NBTTagCompound tag, boolean silky) {
        if (silky) {
            tag.func_74774_a("e", this.enabledSides);
        }
        tag.func_74774_a("i", this.invertedSides);
    }

    public void readFromNBT(NBTTagCompound tag) {
        if (tag.func_74764_b("v")) {
            this.values = tag.func_74770_j("v");
            this.pendingTick = tag.func_74771_c("p");
        } else {
            this.values = (byte[])(tag.func_74764_b("in") ? tag.func_74770_j("in") : null);
            this.pendingTick = 2;
        }
        if (this.values == null || this.values.length != 4) {
            this.values = new byte[4];
        }
        this.enabledSides = tag.func_74771_c("e");
        this.invertedSides = tag.func_74771_c("i");
        this.side = EnumFacing.func_82600_a((int)tag.func_74771_c("f"));
        this.top = EnumFacing.func_82600_a((int)tag.func_74771_c("t"));
        this.mirrored = tag.func_74767_n("m");
    }

    public void writeUpdatePacket(PacketBuffer buf) {
        buf.writeByte((this.mirrored ? 64 : 0) | this.side.ordinal() << 3 | this.top.ordinal());
        buf.writeByte(this.enabledSides | this.invertedSides << 4);
        for (int i = 0; i < 4; ++i) {
            EnumFacing facing = EnumFacing.func_82600_a((int)(i + 2));
            if (!this.isSideOpen(facing)) continue;
            buf.writeByte((int)this.values[i]);
        }
    }

    public void handlePacket(ByteBuf buf) {
        short sides = buf.readUnsignedByte();
        this.enabledSides = (byte)(sides & 0xF);
        this.invertedSides = (byte)(sides >> 4);
        for (int i = 0; i < 4; ++i) {
            EnumFacing facing = EnumFacing.func_82600_a((int)(i + 2));
            if (!this.isSideOpen(facing)) continue;
            this.values[i] = buf.readByte();
        }
        this.markRenderUpdate();
    }

    public void readUpdatePacket(PacketBuffer buf) {
        short sides = buf.readUnsignedByte();
        this.side = EnumFacing.func_82600_a((int)(sides >> 3 & 7));
        this.top = EnumFacing.func_82600_a((int)(sides & 7));
        boolean bl = this.mirrored = (sides & 0x40) != 0;
        if (!Minecraft.func_71410_x().func_152345_ab()) {
            final ByteBuf buf2 = Unpooled.copiedBuffer((ByteBuf)buf);
            Minecraft.func_71410_x().func_152344_a(new Runnable(){

                @Override
                public void run() {
                    PartGate.this.handlePacket(buf2);
                }
            });
        } else {
            this.handlePacket((ByteBuf)buf);
        }
    }

    public void addCollisionBoxes(AxisAlignedBB mask, List<AxisAlignedBB> list, Entity collidingEntity) {
        AxisAlignedBB box = BOXES[this.side.ordinal()];
        if (box != null && box.func_72326_a(mask)) {
            list.add(box);
        }
    }

    public void addOcclusionBoxes(List<AxisAlignedBB> list) {
        AxisAlignedBB box = BOXES[this.side.ordinal()];
        if (box != null) {
            list.add(box);
        }
    }

    public void addSelectionBoxes(List<AxisAlignedBB> list) {
        AxisAlignedBB box = BOXES[this.side.ordinal()];
        if (box != null) {
            list.add(box);
        }
    }

    public IBlockState getExtendedState(IBlockState state) {
        return ((IExtendedBlockState)state).withProperty(PROPERTY, (Object)this);
    }

    public BlockStateContainer createBlockState() {
        return new ExtendedBlockState((Block)MCMultiPartMod.multipart, new IProperty[0], new IUnlistedProperty[]{PROPERTY});
    }

    public boolean canRenderInLayer(BlockRenderLayer layer) {
        return layer == BlockRenderLayer.CUTOUT;
    }

    public boolean rsToDigi(byte v) {
        return v > 0;
    }

    public byte digiToRs(boolean v) {
        return v ? (byte)15 : 0;
    }

    public EnumFacing gateToReal(EnumFacing dir) {
        if (dir.func_176740_k() == EnumFacing.Axis.Y) {
            return null;
        }
        if (dir.func_176740_k() == EnumFacing.Axis.X && this.mirrored) {
            dir = dir.func_176734_d();
        }
        for (EnumFacing itop = this.top; itop != EnumFacing.NORTH; itop = itop.func_176735_f()) {
            dir = dir.func_176746_e();
        }
        return this.CONNECTION_DIRS[this.side.ordinal()][dir.ordinal() - 2];
    }

    public EnumFacing realToGate(EnumFacing rdir) {
        if (rdir.func_176740_k() == this.side.func_176740_k()) {
            return null;
        }
        for (int i = 0; i < 4; ++i) {
            if (this.CONNECTION_DIRS[this.side.ordinal()][i] != rdir) continue;
            EnumFacing dir = EnumFacing.func_82600_a((int)(i + 2));
            for (EnumFacing itop = this.top; itop != EnumFacing.NORTH; itop = itop.func_176735_f()) {
                dir = dir.func_176735_f();
            }
            if (dir.func_176740_k() == EnumFacing.Axis.X && this.mirrored) {
                return dir.func_176734_d();
            }
            return dir;
        }
        return null;
    }

    private int getUniqueSideRenderID(EnumFacing side) {
        return (this.isSideInverted(side) ? 16 : 0) | (this.isSideOpen(side) ? 32 : 0) | this.getValueInside(side);
    }

    @Override
    public boolean renderEquals(PartGate other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        if (this.getSide() != other.getSide() || this.getTop() != this.getTop() || this.isMirrored() != other.isMirrored()) {
            return false;
        }
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            if (this.getUniqueSideRenderID(facing) == other.getUniqueSideRenderID(facing)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int renderHashCode() {
        return Objects.hash(this.getClass(), this.getSide(), this.getTop(), this.isMirrored(), this.getUniqueSideRenderID(EnumFacing.NORTH), this.getUniqueSideRenderID(EnumFacing.SOUTH), this.getUniqueSideRenderID(EnumFacing.WEST), this.getUniqueSideRenderID(EnumFacing.EAST));
    }

    static {
        for (int i = 0; i < 6; ++i) {
            EnumFacing facing = EnumFacing.func_82600_a((int)i);
            PartGate.BOXES[i] = RotationUtils.rotateFace(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0), facing);
            PartGate.HIT_VECTORS[i] = new Vec3d[4];
            if (facing.func_176740_k() != EnumFacing.Axis.Y) {
                PartGate.HIT_VECTORS[i][1] = RotationUtils.rotateVec(new Vec3d(0.5, 0.125, 0.0), facing);
                PartGate.HIT_VECTORS[i][0] = RotationUtils.rotateVec(new Vec3d(0.5, 0.125, 1.0), facing);
            } else {
                PartGate.HIT_VECTORS[i][0] = RotationUtils.rotateVec(new Vec3d(0.5, 0.125, 0.0), facing);
                PartGate.HIT_VECTORS[i][1] = RotationUtils.rotateVec(new Vec3d(0.5, 0.125, 1.0), facing);
            }
            if (facing == EnumFacing.SOUTH || facing == EnumFacing.WEST) {
                PartGate.HIT_VECTORS[i][3] = RotationUtils.rotateVec(new Vec3d(0.0, 0.125, 0.5), facing);
                PartGate.HIT_VECTORS[i][2] = RotationUtils.rotateVec(new Vec3d(1.0, 0.125, 0.5), facing);
                continue;
            }
            PartGate.HIT_VECTORS[i][2] = RotationUtils.rotateVec(new Vec3d(0.0, 0.125, 0.5), facing);
            PartGate.HIT_VECTORS[i][3] = RotationUtils.rotateVec(new Vec3d(1.0, 0.125, 0.5), facing);
        }
    }

    public static enum State {
        NO_RENDER,
        OFF,
        ON,
        DISABLED;


        public State invert() {
            switch (this) {
                case OFF: {
                    return ON;
                }
                case ON: {
                    return OFF;
                }
            }
            return this;
        }

        public static State input(byte i) {
            return i > 0 ? ON : OFF;
        }

        public static State bool(boolean v) {
            return v ? ON : OFF;
        }
    }

    public static enum Connection {
        NONE,
        INPUT,
        OUTPUT,
        INPUT_OUTPUT,
        INPUT_ANALOG,
        OUTPUT_ANALOG,
        INPUT_BUNDLED,
        OUTPUT_BUNDLED;


        public boolean isInput() {
            return this == INPUT || this == INPUT_ANALOG || this == INPUT_OUTPUT || this == INPUT_BUNDLED;
        }

        public boolean isOutput() {
            return this == OUTPUT || this == OUTPUT_ANALOG || this == INPUT_OUTPUT || this == OUTPUT_BUNDLED;
        }

        public boolean isRedstone() {
            return this == INPUT || this == OUTPUT || this == INPUT_ANALOG || this == OUTPUT_ANALOG || this == INPUT_OUTPUT;
        }

        public boolean isDigital() {
            return this == INPUT || this == OUTPUT || this == INPUT_OUTPUT;
        }

        public boolean isAnalog() {
            return this == INPUT_ANALOG || this == OUTPUT_ANALOG;
        }

        public boolean isBundled() {
            return this == INPUT_BUNDLED || this == OUTPUT_BUNDLED;
        }
    }

    private class RedstoneCommunications
    implements IBundledEmitter,
    IBundledReceiver,
    IRedstoneEmitter,
    IRedstoneReceiver {
        private final EnumFacing side;

        RedstoneCommunications(EnumFacing side) {
            this.side = side;
        }

        @Override
        public byte[] getBundledSignal() {
            return new byte[0];
        }

        @Override
        public void onBundledInputChange() {
            PartGate.this.onChanged();
        }

        @Override
        public int getRedstoneSignal() {
            Connection type = PartGate.this.getType(this.side);
            return type.isOutput() && type.isRedstone() ? (int)PartGate.this.getValueOutside(this.side) : 0;
        }

        @Override
        public void onRedstoneInputChange() {
            PartGate.this.onChanged();
        }
    }
}

