/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.asie.charset.lib.ProxyCommon;
import pl.asie.charset.lib.audio.manager.AudioStreamManager;
import pl.asie.charset.lib.audio.manager.AudioStreamManagerClient;
import pl.asie.charset.lib.material.ColorLookupHandler;
import pl.asie.charset.lib.render.ModelFactory;
import pl.asie.charset.lib.utils.RenderUtils;
import pl.asie.charset.lib.wires.PartWire;
import pl.asie.charset.lib.wires.RendererWire;
import pl.asie.charset.lib.wires.WireFactory;
import pl.asie.charset.lib.wires.WireManager;
import pl.asie.charset.lib.wires.WireUtils;

public class ProxyClient
extends ProxyCommon {
    public static final RendererWire rendererWire = new RendererWire();

    @Override
    public void drawWireHighlight(PartWire wire) {
        int lineMaskCenter = 4095;
        EnumFacing[] faces = WireUtils.getConnectionsForRender(wire.location);
        for (int i = 0; i < faces.length; ++i) {
            EnumFacing face = faces[i];
            if (!wire.connectsAny(face)) continue;
            int lineMask = 4095;
            RenderUtils.drawSelectionBoundingBox(wire.getSelectionBox(i + 1), lineMask &= ~RenderUtils.getLineMask(face.func_176734_d()));
            lineMaskCenter &= ~RenderUtils.getLineMask(face);
        }
        if (lineMaskCenter != 0) {
            RenderUtils.drawSelectionBoundingBox(wire.getSelectionBox(0), lineMaskCenter);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onPostBake(ModelBakeEvent event) {
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation("charsetlib:wire", "multipart"), (Object)rendererWire);
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation("charsetlib:wire", "inventory"), (Object)rendererWire);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onTextureStitch(TextureStitchEvent.Pre event) {
        ModelFactory.clearCaches();
        ColorLookupHandler.INSTANCE.clear();
        for (WireFactory factory : WireManager.REGISTRY.getValues()) {
            rendererWire.registerSheet(event.getMap(), factory);
        }
    }

    @Override
    public void init() {
        AudioStreamManager.INSTANCE = new AudioStreamManagerClient();
    }

    @Override
    public void registerItemModel(Item item, int meta, String name) {
        if (name.contains("#")) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(name.split("#")[0], name.split("#")[1]));
        } else {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(name, "inventory"));
        }
    }

    @Override
    public World getLocalWorld(int dim) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            WorldClient w = Minecraft.func_71410_x().field_71441_e;
            if (w != null && w.field_73011_w.getDimension() == dim) {
                return w;
            }
            return null;
        }
        return DimensionManager.getWorld((int)dim);
    }

    @Override
    public void onServerStop() {
        AudioStreamManagerClient.INSTANCE.removeAll();
    }

    @Override
    public boolean isClientThread() {
        return Minecraft.func_71410_x().func_152345_ab();
    }

    @Override
    public void addScheduledClientTask(Runnable runnable) {
        Minecraft.func_71410_x().func_152344_a(runnable);
    }

    @Override
    public boolean isClient() {
        return true;
    }
}

