/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.inventory;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.ITextComponent;
import pl.asie.charset.lib.inventory.IInventoryOwner;

public class InventorySimple
implements IInventory {
    public final Set<EntityPlayer> watchers;
    private final IInventoryOwner owner;
    private final int size;
    private final ItemStack[] items;

    public InventorySimple(int size, IInventoryOwner owner) {
        this.owner = owner;
        this.size = size;
        this.items = new ItemStack[size];
        this.watchers = new HashSet<EntityPlayer>();
    }

    public void readFromNBT(NBTTagCompound nbt, String key) {
        NBTTagList itemList = nbt.func_150295_c(key, 10);
        for (int i = 0; i < Math.min(this.size, itemList.func_74745_c()); ++i) {
            NBTTagCompound cpd = itemList.func_150305_b(i);
            ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)cpd);
            this.items[i] = stack != null ? stack : null;
        }
    }

    public void writeToNBT(NBTTagCompound nbt, String key) {
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.size; ++i) {
            NBTTagCompound cpd = new NBTTagCompound();
            if (this.items[i] != null) {
                this.items[i].func_77955_b(cpd);
            }
            itemList.func_74742_a((NBTBase)cpd);
        }
        nbt.func_74782_a(key, (NBTBase)itemList);
    }

    public int func_70302_i_() {
        return this.size;
    }

    public ItemStack func_70301_a(int index) {
        return this.items[index];
    }

    public ItemStack func_70298_a(int index, int count) {
        if (this.items[index] != null) {
            if (this.items[index].field_77994_a <= count) {
                ItemStack stack = this.items[index];
                this.items[index] = null;
                this.func_70296_d();
                return stack;
            }
            ItemStack stack = this.items[index].func_77979_a(count);
            if (this.items[index].field_77994_a == 0) {
                this.items[index] = null;
            }
            this.func_70296_d();
            return stack;
        }
        return null;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack stack = this.items[index];
        this.items[index] = null;
        return stack;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.items[index] = stack;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        this.owner.onInventoryChanged(this);
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
        this.watchers.add(player);
    }

    public void func_174886_c(EntityPlayer player) {
        this.watchers.remove(player);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public String func_70005_c_() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return null;
    }
}

