/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.misc;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileBuffer {
    private final TileEntity owner;
    private final TileEntity[] tiles;
    private World world;
    private boolean initialized;

    public TileBuffer(TileEntity owner) {
        this.owner = owner;
        this.tiles = new TileEntity[6];
    }

    public TileEntity getOwner() {
        return this.owner;
    }

    public TileEntity getTileEntity(EnumFacing side) {
        if (side != null) {
            if (this.tiles[side.ordinal()] != null && this.tiles[side.ordinal()].func_145837_r()) {
                this.updateSide(side, true);
            }
            return this.tiles[side.ordinal()];
        }
        return null;
    }

    private void updateSide(EnumFacing direction, boolean force) {
        int i = direction.ordinal();
        BlockPos pos = this.owner.func_174877_v().func_177972_a(direction);
        if (!force && this.tiles[i] != null && !this.tiles[i].func_145837_r()) {
            return;
        }
        this.tiles[i] = null;
        if (this.world == null) {
            this.world = this.owner.func_145831_w();
        }
        if (!force && !this.world.func_175667_e(pos)) {
            return;
        }
        IBlockState state = this.world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block.hasTileEntity(state)) {
            this.tiles[i] = this.world.func_175625_s(pos);
        }
    }

    public void update(boolean force) {
        for (EnumFacing direction : EnumFacing.field_82609_l) {
            this.updateSide(direction, force);
        }
    }
}

