/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.notify;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import net.minecraft.command.ICommand;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.relauncher.Side;
import pl.asie.charset.lib.notify.MutterCommand;
import pl.asie.charset.lib.notify.Notice;
import pl.asie.charset.lib.notify.NotificationCoord;
import pl.asie.charset.lib.notify.NotifyNetwork;
import pl.asie.charset.lib.notify.PointNetworkHandler;
import pl.asie.charset.lib.notify.RenderMessagesProxy;
import pl.asie.charset.lib.notify.Style;

public class NotifyImplementation {
    @SidedProxy(clientSide="pl.asie.charset.lib.notify.RenderMessages", serverSide="pl.asie.charset.lib.notify.RenderMessagesProxy")
    public static RenderMessagesProxy proxy;
    public static NotifyNetwork net;
    public static NotifyImplementation instance;
    private static final ArrayList<Notice> recuring_notifications;

    public static void init() {
        instance = new NotifyImplementation();
        MinecraftForge.EVENT_BUS.register((Object)instance);
        PointNetworkHandler.INSTANCE.initialize();
    }

    public void registerServerCommands(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new MutterCommand());
    }

    void doSend(EntityPlayer player, Object where, World world, EnumSet<Style> style, ItemStack item, String format, String[] args) {
        if (where == null) {
            return;
        }
        if (player instanceof FakePlayer) {
            return;
        }
        format = this.styleMessage(style, format);
        if (player != null && player.field_70170_p.field_72995_K || FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            proxy.addMessage(where, item, format, args);
        } else {
            NetworkRegistry.TargetPoint target = null;
            if (player == null) {
                int range = style.contains((Object)Style.DRAWFAR) ? 128 : 32;
                int x = 0;
                int y = 0;
                int z = 0;
                boolean failed = false;
                BlockPos pos = null;
                if (where instanceof NotificationCoord) {
                    NotificationCoord c = (NotificationCoord)where;
                    pos = c.getPos();
                    world = c.getWorld();
                } else if (where instanceof TileEntity) {
                    TileEntity te = (TileEntity)where;
                    world = te.func_145831_w();
                    pos = te.func_174877_v();
                } else if (where instanceof Entity) {
                    Entity ent = (Entity)where;
                    world = ent.field_70170_p;
                    x = (int)ent.field_70165_t;
                    y = (int)ent.field_70163_u;
                    z = (int)ent.field_70161_v;
                } else if (where instanceof Vec3d) {
                    Vec3d vec = (Vec3d)where;
                    x = (int)vec.field_72450_a;
                    y = (int)vec.field_72448_b;
                    z = (int)vec.field_72449_c;
                } else if (where instanceof BlockPos) {
                    pos = (BlockPos)where;
                } else {
                    failed = true;
                }
                if (pos != null) {
                    x = pos.func_177958_n();
                    y = pos.func_177956_o();
                    z = pos.func_177952_p();
                }
                if (world != null && !failed) {
                    int dimension = world.field_73011_w.getDimension();
                    target = new NetworkRegistry.TargetPoint(dimension, (double)x, (double)y, (double)z, (double)range);
                }
            }
            if (args == null) {
                args = new String[]{};
            }
            FMLProxyPacket packet = NotifyNetwork.notifyPacket(where, item, format, args);
            NotifyNetwork.broadcast(packet, player, target);
        }
    }

    public static void recieve(EntityPlayer player, Object where, ItemStack item, String styledFormat, String[] args) {
        if (where == null) {
            return;
        }
        proxy.addMessage(where, item, styledFormat, args);
    }

    String styleMessage(EnumSet<Style> style, String format) {
        if (style == null) {
            return "\n" + format;
        }
        String prefix = "";
        String sep = "";
        for (Style s : style) {
            prefix = prefix + sep + s.toString();
            sep = " ";
        }
        return prefix + "\n" + format;
    }

    static EnumSet<Style> loadStyle(String firstLine) {
        EnumSet<Style> ret = EnumSet.noneOf(Style.class);
        for (String s : firstLine.split(" ")) {
            try {
                ret.add(Style.valueOf(s));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void updateRecuringNotifications(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        ArrayList<Notice> arrayList = recuring_notifications;
        synchronized (arrayList) {
            Iterator<Notice> iterator = recuring_notifications.iterator();
            while (iterator.hasNext()) {
                Notice rn = iterator.next();
                if (!rn.isInvalid() && rn.updateNotice()) continue;
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addRecuringNotification(Notice newRN) {
        ArrayList<Notice> arrayList = recuring_notifications;
        synchronized (arrayList) {
            Iterator<Notice> iterator = recuring_notifications.iterator();
            while (iterator.hasNext()) {
                Notice rn = iterator.next();
                if (!rn.where.equals(newRN.where) || newRN.targetPlayer != null && newRN.targetPlayer != rn.targetPlayer) continue;
                iterator.remove();
            }
            recuring_notifications.add(newRN);
        }
    }

    void doSendOnscreenMessage(EntityPlayer player, String message, String[] formatArgs) {
        if (player.field_70170_p.field_72995_K) {
            proxy.onscreen(message, formatArgs);
        } else {
            FMLProxyPacket packet = NotifyNetwork.onscreenPacket(message, formatArgs);
            NotifyNetwork.broadcast(packet, player, null);
        }
    }

    void sendReplacableChatMessage(EntityPlayer player, ITextComponent msg, int msgKey) {
        if (player.field_70170_p.field_72995_K) {
            proxy.replaceable(msg, msgKey);
        } else {
            FMLProxyPacket packet = NotifyNetwork.replaceableChatPacket(msg, msgKey);
            NotifyNetwork.broadcast(packet, player, null);
        }
    }

    static {
        net = new NotifyNetwork();
        recuring_notifications = new ArrayList();
    }
}

