/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.recipe;

import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import pl.asie.charset.lib.items.IDyeableItem;
import pl.asie.charset.lib.recipe.RecipeBase;
import pl.asie.charset.lib.utils.ColorUtils;

public class RecipeDyeableItem
extends RecipeBase {
    protected boolean isTarget(ItemStack stack) {
        return stack.func_77973_b() instanceof IDyeableItem;
    }

    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        ItemStack target = null;
        ArrayList<ItemStack> dyes = new ArrayList<ItemStack>();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack source = inv.func_70301_a(i);
            if (source == null) continue;
            if (this.isTarget(source)) {
                if (target != null) {
                    return false;
                }
                target = source;
                continue;
            }
            if (this.getColor(source) != null) {
                dyes.add(source);
                continue;
            }
            return false;
        }
        return target != null && !dyes.isEmpty();
    }

    protected int[] getColor(ItemStack stack) {
        if (stack != null) {
            if (stack.func_77973_b() instanceof IDyeableItem) {
                IDyeableItem targetItem = (IDyeableItem)stack.func_77973_b();
                if (targetItem.hasColor(stack)) {
                    int c = targetItem.getColor(stack);
                    return new int[]{c >> 16 & 0xFF, c >> 8 & 0xFF, c & 0xFF};
                }
            } else {
                int dyeId = ColorUtils.getColorIDFromDye(stack);
                if (dyeId >= 0) {
                    float[] col = EntitySheep.func_175513_a((EnumDyeColor)EnumDyeColor.func_176764_b((int)dyeId));
                    return new int[]{(int)(col[0] * 255.0f), (int)(col[1] * 255.0f), (int)(col[2] * 255.0f)};
                }
            }
        }
        return null;
    }

    protected Optional<Integer> getMixedColor(InventoryCrafting inv, ItemStack base, Predicate<Integer> slotFilter) {
        int[] col;
        int[] color = new int[3];
        int scale = 0;
        int count = 0;
        if (base != null && (col = this.getColor(base)) != null) {
            scale += Math.max(col[0], Math.max(col[1], col[2]));
            color[0] = color[0] + col[0];
            color[1] = color[1] + col[1];
            color[2] = color[2] + col[2];
            ++count;
        }
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            int[] col2;
            ItemStack source;
            if (slotFilter != null && !slotFilter.test(i) || (source = inv.func_70301_a(i)) == null || source == base || (col2 = this.getColor(source)) == null) continue;
            scale += Math.max(col2[0], Math.max(col2[1], col2[2]));
            color[0] = color[0] + col2[0];
            color[1] = color[1] + col2[1];
            color[2] = color[2] + col2[2];
            ++count;
        }
        if (count > 0) {
            int i1 = color[0] / count;
            int j1 = color[1] / count;
            int k1 = color[2] / count;
            float f3 = (float)scale / (float)count;
            float f4 = Math.max(i1, Math.max(j1, k1));
            i1 = (int)((float)i1 * f3 / f4);
            j1 = (int)((float)j1 * f3 / f4);
            k1 = (int)((float)k1 * f3 / f4);
            return Optional.of((i1 << 16) + (j1 << 8) + k1);
        }
        return Optional.empty();
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        Optional<Integer> result;
        ItemStack target = null;
        IDyeableItem targetItem = null;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack source = inv.func_70301_a(i);
            if (source == null || !(source.func_77973_b() instanceof IDyeableItem)) continue;
            targetItem = (IDyeableItem)source.func_77973_b();
            target = source.func_77946_l();
            target.field_77994_a = 1;
        }
        if (targetItem != null && (result = this.getMixedColor(inv, target, null)).isPresent()) {
            targetItem.setColor(target, result.get());
            return target;
        }
        return null;
    }

    public ItemStack func_77571_b() {
        return null;
    }
}

