/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.render;

import java.util.EnumMap;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import pl.asie.charset.lib.utils.RenderUtils;

public abstract class BaseBakedModel
implements IPerspectiveAwareModel {
    private final EnumMap<ItemCameraTransforms.TransformType, TRSRTransformation> transformMap = new EnumMap(ItemCameraTransforms.TransformType.class);
    private final ResourceLocation particle;
    private static final TRSRTransformation flipX = new TRSRTransformation(null, null, new Vector3f(-1.0f, 1.0f, 1.0f), null);

    public BaseBakedModel() {
        this(null);
    }

    public BaseBakedModel(ResourceLocation particle) {
        this.particle = particle != null ? particle : TextureMap.field_174945_f;
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        return ImmutablePair.of((Object)this, this.transformMap.containsKey(cameraTransformType) ? this.transformMap.get(cameraTransformType).getMatrix() : null);
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return (TextureAtlasSprite)RenderUtils.textureGetter.apply((Object)this.particle);
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }

    public void addTransformation(ItemCameraTransforms.TransformType type, TRSRTransformation transformation) {
        this.transformMap.put(type, TRSRTransformation.blockCornerToCenter((TRSRTransformation)transformation));
    }

    public void addThirdPersonTransformation(TRSRTransformation transformation) {
        this.addTransformation(ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, transformation);
        this.addTransformation(ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, BaseBakedModel.toLeftHand(transformation));
    }

    public void addFirstPersonTransformation(TRSRTransformation transformation) {
        this.addTransformation(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, transformation);
        this.addTransformation(ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, BaseBakedModel.toLeftHand(transformation));
    }

    protected static TRSRTransformation toLeftHand(TRSRTransformation transform) {
        return TRSRTransformation.blockCenterToCorner((TRSRTransformation)flipX.compose(TRSRTransformation.blockCornerToCenter((TRSRTransformation)transform)).compose(flipX));
    }

    protected static TRSRTransformation getTransformation(float tx, float ty, float tz, float ax, float ay, float az, float s) {
        return TRSRTransformation.blockCenterToCorner((TRSRTransformation)new TRSRTransformation(new Vector3f(tx / 16.0f, ty / 16.0f, tz / 16.0f), TRSRTransformation.quatFromXYZDegrees((Vector3f)new Vector3f(ax, ay, az)), new Vector3f(s, s, s), null));
    }

    public BaseBakedModel addDefaultBlockTransforms() {
        TRSRTransformation thirdperson = BaseBakedModel.getTransformation(0.0f, 2.5f, 0.0f, 75.0f, 45.0f, 0.0f, 0.375f);
        this.addTransformation(ItemCameraTransforms.TransformType.GUI, BaseBakedModel.getTransformation(0.0f, 0.0f, 0.0f, 30.0f, 225.0f, 0.0f, 0.625f));
        this.addTransformation(ItemCameraTransforms.TransformType.GROUND, BaseBakedModel.getTransformation(0.0f, 3.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.25f));
        this.addTransformation(ItemCameraTransforms.TransformType.FIXED, BaseBakedModel.getTransformation(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f));
        this.addThirdPersonTransformation(thirdperson);
        this.addTransformation(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, BaseBakedModel.getTransformation(0.0f, 0.0f, 0.0f, 0.0f, 45.0f, 0.0f, 0.4f));
        this.addTransformation(ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, BaseBakedModel.getTransformation(0.0f, 0.0f, 0.0f, 0.0f, 255.0f, 0.0f, 0.4f));
        return this;
    }

    public BaseBakedModel addDefaultItemTransforms() {
        TRSRTransformation thirdperson = BaseBakedModel.getTransformation(0.0f, 3.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.55f);
        TRSRTransformation firstperson = BaseBakedModel.getTransformation(1.13f, 3.2f, 1.13f, 0.0f, -90.0f, 25.0f, 0.68f);
        this.addTransformation(ItemCameraTransforms.TransformType.GROUND, BaseBakedModel.getTransformation(0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f));
        this.addTransformation(ItemCameraTransforms.TransformType.HEAD, BaseBakedModel.getTransformation(0.0f, 13.0f, 7.0f, 0.0f, 180.0f, 0.0f, 1.0f));
        this.addThirdPersonTransformation(thirdperson);
        this.addFirstPersonTransformation(firstperson);
        return this;
    }

    public BaseBakedModel addDefaultToolTransforms() {
        this.addTransformation(ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, BaseBakedModel.getTransformation(0.0f, 4.0f, 0.5f, 0.0f, -90.0f, 55.0f, 0.85f));
        this.addTransformation(ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, BaseBakedModel.getTransformation(0.0f, 4.0f, 0.5f, 0.0f, 90.0f, -55.0f, 0.85f));
        this.addTransformation(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, BaseBakedModel.getTransformation(1.13f, 3.2f, 1.13f, 0.0f, -90.0f, 25.0f, 0.68f));
        this.addTransformation(ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, BaseBakedModel.getTransformation(1.13f, 3.2f, 1.13f, 0.0f, 90.0f, -25.0f, 0.68f));
        return this;
    }
}

