/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.utils;

import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.wrappers.FluidHandlerWrapper;

public final class FluidUtils {
    private FluidUtils() {
    }

    public static IFluidHandler getFluidHandler(TileEntity tile, EnumFacing dir) {
        if (tile != null) {
            if (tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, dir)) {
                return (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, dir);
            }
            if (tile instanceof net.minecraftforge.fluids.IFluidHandler) {
                return new FluidHandlerWrapper((net.minecraftforge.fluids.IFluidHandler)tile, dir);
            }
        }
        return null;
    }

    public static void push(IFluidHandler from, IFluidHandler to, int amt) {
        FluidStack drained;
        if (amt > 0 && (drained = from.drain(amt, false)) != null && drained.amount > 0 && (amt = to.fill(drained, true)) > 0) {
            FluidStack toDrain = drained.copy();
            toDrain.amount = amt;
            from.drain(toDrain, true);
        }
    }

    public static void push(IFluidHandler from, IFluidHandler to, FluidStack out) {
        int amt;
        FluidStack drained;
        if (out != null && out.amount > 0 && (drained = from.drain(out, false)) != null && drained.amount > 0 && (amt = to.fill(drained, true)) > 0) {
            FluidStack toDrain = drained;
            toDrain.amount = amt;
            from.drain(toDrain, true);
        }
    }
}

