/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.utils;

import mcmultipart.multipart.IMultipartContainer;
import mcmultipart.multipart.MultipartHelper;
import mcmultipart.multipart.MultipartRedstoneHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBasePressurePlate;
import net.minecraft.block.BlockButton;
import net.minecraft.block.BlockDaylightDetector;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockRedstoneDiode;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public final class RedstoneUtils {
    private RedstoneUtils() {
    }

    public static int getRedstonePowerWithWire(World world, BlockPos pos, EnumFacing facing) {
        IBlockState iblockstate = world.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        if (block instanceof BlockRedstoneWire) {
            return (Integer)iblockstate.func_177229_b((IProperty)BlockRedstoneWire.field_176351_O);
        }
        return block.shouldCheckWeakPower(iblockstate, (IBlockAccess)world, pos, facing) ? world.func_175676_y(pos) : iblockstate.func_185911_a((IBlockAccess)world, pos, facing);
    }

    public static boolean canConnectFace(IBlockAccess world, BlockPos pos, IBlockState state, EnumFacing side, EnumFacing face) {
        Block block = state.func_177230_c();
        if ((block instanceof BlockRedstoneDiode || block instanceof BlockRedstoneWire || block instanceof BlockDaylightDetector || block instanceof BlockBasePressurePlate) && face != EnumFacing.DOWN) {
            return false;
        }
        if (block instanceof BlockLever && face != ((BlockLever.EnumOrientation)state.func_177229_b((IProperty)BlockLever.field_176360_a)).func_176852_c().func_176734_d()) {
            return false;
        }
        if (block instanceof BlockButton && face != ((EnumFacing)state.func_177229_b((IProperty)BlockButton.field_176387_N)).func_176734_d()) {
            return false;
        }
        IMultipartContainer container = MultipartHelper.getPartContainer((IBlockAccess)world, (BlockPos)pos);
        if (container != null) {
            return MultipartRedstoneHelper.canConnectRedstone((IMultipartContainer)container, (EnumFacing)side, (EnumFacing)face);
        }
        return block.canConnectRedstone(state, world, pos, side);
    }
}

