/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.storage.backpack;

import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.asie.charset.lib.ModCharsetLib;
import pl.asie.charset.lib.Properties;
import pl.asie.charset.lib.blocks.BlockBase;
import pl.asie.charset.lib.notify.Notice;
import pl.asie.charset.storage.ModCharsetStorage;
import pl.asie.charset.storage.backpack.TileBackpack;

public class BlockBackpack
extends BlockBase
implements ITileEntityProvider {
    public static final int DEFAULT_COLOR = 8409144;
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.75, 0.8125);

    public BlockBackpack() {
        super(Material.field_151580_n);
        this.func_149647_a(ModCharsetLib.CREATIVE_TAB);
        this.func_149663_c("charset.backpack");
        this.func_149711_c(0.8f);
        this.func_149672_a(SoundType.field_185854_g);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public float func_180647_a(IBlockState state, EntityPlayer player, World world, BlockPos pos) {
        if (player.func_70093_af()) {
            return -1.0f;
        }
        return super.func_180647_a(state, player, world, pos);
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        TileEntity tile;
        if (player.func_70093_af() && (tile = world.func_175625_s(pos)) instanceof TileBackpack) {
            if (player.func_184582_a(EntityEquipmentSlot.CHEST) != null) {
                new Notice(tile, "notice.charset.backpack.chestplate", new String[0]).sendTo(player);
            } else {
                ItemStack stack = ((TileBackpack)tile).writeToItemStack();
                world.func_175713_t(pos);
                world.func_175698_g(pos);
                player.func_184201_a(EntityEquipmentSlot.CHEST, stack);
            }
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileBackpack) {
            player.openGui((Object)ModCharsetStorage.instance, 1, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return true;
        }
        return false;
    }

    @Override
    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TileEntity tile;
        if (world != null && (tile = world.func_175625_s(pos)) instanceof TileBackpack) {
            return ((TileBackpack)tile).writeToItemStack();
        }
        return new ItemStack((Block)this);
    }

    @Override
    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof IInventory) {
            InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)((IInventory)tile));
        }
        super.func_180663_b(worldIn, pos, state);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)Properties.FACING4, (Comparable)placer.func_174811_aO());
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{Properties.FACING4});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)Properties.FACING4)).ordinal() - 2;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)Properties.FACING4, (Comparable)EnumFacing.func_82600_a((int)((meta & 3) + 2)));
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileBackpack();
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public static class Color
    implements IBlockColor {
        @SideOnly(value=Side.CLIENT)
        public int func_186720_a(IBlockState state, IBlockAccess worldIn, BlockPos pos, int tintIndex) {
            TileEntity tile;
            if (worldIn != null && pos != null && (tile = worldIn.func_175625_s(pos)) instanceof TileBackpack) {
                return ((TileBackpack)tile).getColor();
            }
            return 8409144;
        }
    }
}

