/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.storage.barrel;

import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import pl.asie.charset.lib.factorization.FzOrientation;
import pl.asie.charset.lib.render.IRenderComparable;
import pl.asie.charset.lib.utils.ItemUtils;
import pl.asie.charset.lib.utils.RenderUtils;
import pl.asie.charset.storage.barrel.TileEntityDayBarrel;

class BarrelCacheInfo
implements IRenderComparable<BarrelCacheInfo> {
    final TextureAtlasSprite log;
    final TextureAtlasSprite plank;
    final TileEntityDayBarrel.Type type;
    final FzOrientation orientation;
    final boolean isMetal;
    final ItemStack logStack;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BarrelCacheInfo cacheInfo = (BarrelCacheInfo)o;
        if (this.isMetal != cacheInfo.isMetal) {
            return false;
        }
        if (!this.log.equals(cacheInfo.log)) {
            return false;
        }
        if (!this.plank.equals(cacheInfo.plank)) {
            return false;
        }
        if (this.type != cacheInfo.type) {
            return false;
        }
        return this.orientation == cacheInfo.orientation;
    }

    public int hashCode() {
        int result = this.log.hashCode();
        result = 31 * result + this.plank.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.orientation.hashCode();
        result = 31 * result + (this.isMetal ? 1 : 0);
        return result;
    }

    private BarrelCacheInfo(TextureAtlasSprite log, ItemStack logStack, TextureAtlasSprite plank, TileEntityDayBarrel.Type type, FzOrientation orientation, boolean isMetal) {
        this.log = log;
        this.logStack = logStack;
        this.plank = plank;
        this.type = type;
        this.orientation = orientation;
        this.isMetal = isMetal;
    }

    public static BarrelCacheInfo from(TileEntityDayBarrel barrel) {
        TextureAtlasSprite log = RenderUtils.getSprite(barrel.woodLog);
        TextureAtlasSprite slab = RenderUtils.getSprite(barrel.woodSlab);
        FzOrientation fzo = barrel.orientation;
        TileEntityDayBarrel.Type type = barrel.type;
        return new BarrelCacheInfo(log, barrel.woodLog, slab, type, fzo, BarrelCacheInfo.isMetal(barrel.woodLog));
    }

    public static BarrelCacheInfo from(ItemStack is) {
        TileEntityDayBarrel barrel = new TileEntityDayBarrel();
        assert (barrel != null);
        barrel.loadFromStack(is);
        barrel.orientation = FzOrientation.FACE_NORTH_POINT_UP;
        return BarrelCacheInfo.from(barrel);
    }

    static boolean isMetal(ItemStack it) {
        if (it == null) {
            return true;
        }
        IBlockState state = ItemUtils.getBlockState(it);
        return !state.func_185904_a().func_76217_h();
    }

    @Override
    public boolean renderEquals(BarrelCacheInfo other) {
        return this.equals(other);
    }

    @Override
    public int renderHashCode() {
        return this.hashCode();
    }
}

