/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.storage.barrel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import pl.asie.charset.storage.barrel.TileEntityDayBarrel;

public class BarrelRegistry {
    public static final BarrelRegistry INSTANCE = new BarrelRegistry();
    private final ArrayList<ItemStack> BARRELS = new ArrayList();

    private static boolean verifyRecipePart(Object o) {
        return o instanceof ItemStack || o instanceof String && OreDictionary.doesOreNameExist((String)((String)o));
    }

    private static ItemStack getRecipeStack(Object o) {
        if (o instanceof ItemStack) {
            return (ItemStack)o;
        }
        if (o instanceof String) {
            List stacks = OreDictionary.getOres((String)((String)o), (boolean)false);
            return stacks.size() > 0 ? (ItemStack)stacks.get(0) : null;
        }
        return null;
    }

    public void registerCraftable(Object log, Object slab) {
        if (!BarrelRegistry.verifyRecipePart(log) || !BarrelRegistry.verifyRecipePart(slab)) {
            return;
        }
        ItemStack logStack = BarrelRegistry.getRecipeStack(log);
        ItemStack slabStack = BarrelRegistry.getRecipeStack(slab);
        ItemStack barrel = this.register(TileEntityDayBarrel.Type.NORMAL, logStack, slabStack);
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(barrel, new Object[]{"W-W", "W W", "WWW", Character.valueOf('W'), log, Character.valueOf('-'), slab}));
    }

    public ItemStack register(TileEntityDayBarrel.Type type, ItemStack log, ItemStack slab) {
        ItemStack ret = TileEntityDayBarrel.makeBarrel(type, log, slab);
        this.BARRELS.add(ret);
        return ret;
    }

    public Collection<ItemStack> getBarrels() {
        return Collections.unmodifiableList(this.BARRELS);
    }
}

