/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.storage.barrel;

import com.google.common.base.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.event.entity.minecart.MinecartInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import pl.asie.charset.lib.factorization.FzOrientation;
import pl.asie.charset.storage.ModCharsetStorage;
import pl.asie.charset.storage.barrel.BarrelCacheInfo;
import pl.asie.charset.storage.barrel.BlockBarrel;
import pl.asie.charset.storage.barrel.TileEntityDayBarrel;

public class EntityMinecartDayBarrel
extends EntityMinecart {
    private static final DataParameter<Optional<ItemStack>> BARREL_ITEM = EntityDataManager.func_187226_a(EntityMinecartDayBarrel.class, (DataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<Optional<ItemStack>> BARREL_LOG = EntityDataManager.func_187226_a(EntityMinecartDayBarrel.class, (DataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<Optional<ItemStack>> BARREL_SLAB = EntityDataManager.func_187226_a(EntityMinecartDayBarrel.class, (DataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<Byte> BARREL_ORIENTATION = EntityDataManager.func_187226_a(EntityMinecartDayBarrel.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> BARREL_TYPE = EntityDataManager.func_187226_a(EntityMinecartDayBarrel.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Integer> BARREL_ITEM_COUNT = EntityDataManager.func_187226_a(EntityMinecartDayBarrel.class, (DataSerializer)DataSerializers.field_187192_b);
    protected TileEntityDayBarrel barrel;
    private IItemHandler itemHandler = new MinecartItemHandler();
    private int activatorRailTicks = 0;

    public EntityMinecartDayBarrel(World world) {
        super(world);
    }

    public EntityMinecartDayBarrel(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    public void func_94095_a(DamageSource damage) {
        this.func_70106_y();
        if (this.barrel != null) {
            this.barrel.dropContents();
        }
        ItemStack itemstack = this.getCartItem();
        if (this.func_95999_t() != null) {
            itemstack.func_151001_c(this.func_95999_t());
        }
        this.func_70099_a(itemstack, 0.0f);
    }

    public ItemStack getCartItem() {
        ItemStack stack = this.barrel.getDroppedBlock();
        ItemStack realStack = new ItemStack((Item)ModCharsetStorage.barrelCartItem, 1);
        realStack.func_77982_d(stack.func_77978_p());
        return realStack;
    }

    public EntityMinecart.Type func_184264_v() {
        return EntityMinecart.Type.CHEST;
    }

    public void initFromStack(ItemStack is) {
        this.barrel.loadFromStack(is);
        this.updateDataWatcher(true);
    }

    private void createBarrel() {
        if (this.barrel != null) {
            return;
        }
        this.barrel = new TileEntityDayBarrel();
        this.barrel.func_145834_a(this.field_70170_p);
        this.barrel.func_174878_a(BlockPos.field_177992_a);
        this.barrel.func_145829_t();
        this.barrel.orientation = FzOrientation.fromDirection(EnumFacing.WEST).pointTopTo(EnumFacing.UP);
        this.barrel.notice_target = this;
    }

    protected final void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.barrel.readNBTData(tag, false);
        this.updateDataWatcher(true);
    }

    protected final void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        this.barrel.writeNBTData(tag, false);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.createBarrel();
        this.field_70180_af.func_187214_a(BARREL_ITEM, (Object)Optional.fromNullable((Object)this.barrel.item));
        this.field_70180_af.func_187214_a(BARREL_ITEM_COUNT, (Object)this.barrel.getItemCount());
        this.field_70180_af.func_187214_a(BARREL_LOG, (Object)Optional.fromNullable((Object)this.barrel.woodLog));
        this.field_70180_af.func_187214_a(BARREL_SLAB, (Object)Optional.fromNullable((Object)this.barrel.woodSlab));
        this.field_70180_af.func_187214_a(BARREL_ORIENTATION, (Object)((byte)this.barrel.orientation.ordinal()));
        this.field_70180_af.func_187214_a(BARREL_TYPE, (Object)((byte)this.barrel.type.ordinal()));
    }

    private void updateDataWatcher(boolean full) {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_187227_b(BARREL_ITEM, (Object)Optional.fromNullable((Object)this.barrel.item));
            this.field_70180_af.func_187227_b(BARREL_ITEM_COUNT, (Object)this.barrel.getItemCount());
            if (full) {
                this.field_70180_af.func_187227_b(BARREL_LOG, (Object)Optional.fromNullable((Object)this.barrel.woodLog));
                this.field_70180_af.func_187227_b(BARREL_SLAB, (Object)Optional.fromNullable((Object)this.barrel.woodSlab));
                this.field_70180_af.func_187227_b(BARREL_ORIENTATION, (Object)((byte)this.barrel.orientation.ordinal()));
                this.field_70180_af.func_187227_b(BARREL_TYPE, (Object)((byte)this.barrel.type.ordinal()));
            }
        }
    }

    public void func_96095_a(int x, int y, int z, boolean powered) {
        if (powered) {
            this.activatorRailTicks = this.barrel.getLogicSpeed();
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.field_70180_af.func_187223_a()) {
            this.barrel.item = (ItemStack)((Optional)this.field_70180_af.func_187225_a(BARREL_ITEM)).orNull();
            this.barrel.setItemCount((Integer)this.field_70180_af.func_187225_a(BARREL_ITEM_COUNT));
            this.barrel.woodLog = (ItemStack)((Optional)this.field_70180_af.func_187225_a(BARREL_LOG)).or((Object)TileEntityDayBarrel.DEFAULT_LOG);
            this.barrel.woodSlab = (ItemStack)((Optional)this.field_70180_af.func_187225_a(BARREL_SLAB)).or((Object)TileEntityDayBarrel.DEFAULT_SLAB);
            this.barrel.orientation = FzOrientation.getOrientation(((Byte)this.field_70180_af.func_187225_a(BARREL_ORIENTATION)).intValue());
            this.barrel.type = TileEntityDayBarrel.Type.values()[(Byte)this.field_70180_af.func_187225_a(BARREL_TYPE)];
        }
        if (!this.field_70170_p.field_72995_K) {
            this.barrel.func_174878_a(new BlockPos((Entity)this));
            if (this.activatorRailTicks > 0) {
                --this.activatorRailTicks;
            }
            if (this.activatorRailTicks <= 0 && this.field_70170_p.func_82737_E() % (long)this.barrel.getLogicSpeed() == 0L) {
                this.barrel.tick();
                this.updateDataWatcher(false);
            }
        }
    }

    public IBlockState func_174897_t() {
        return ((IExtendedBlockState)ModCharsetStorage.barrelBlock.func_176223_P()).withProperty(BlockBarrel.BARREL_INFO, (Object)BarrelCacheInfo.from(this.barrel));
    }

    public IBlockState func_180457_u() {
        return ModCharsetStorage.barrelBlock.func_176223_P();
    }

    public boolean func_70097_a(DamageSource source, float f) {
        if (source.func_76346_g() instanceof EntityPlayer) {
            int oldItemCount = this.barrel.getItemCount();
            this.barrel.click((EntityPlayer)source.func_76346_g());
            this.updateDataWatcher(false);
            if (source.func_76346_g().func_70093_af()) {
                return super.func_70097_a(source, f);
            }
            if (this.barrel.type == TileEntityDayBarrel.Type.CREATIVE) {
                return false;
            }
            if (this.barrel.getItemCount() != oldItemCount) {
                return false;
            }
        }
        return super.func_70097_a(source, f);
    }

    public boolean func_184230_a(EntityPlayer player, @Nullable ItemStack stack, EnumHand hand) {
        if (MinecraftForge.EVENT_BUS.post((Event)new MinecartInteractEvent((EntityMinecart)this, player, stack, hand))) {
            return true;
        }
        boolean result = this.barrel.activate(player, null, hand);
        this.updateDataWatcher(false);
        return result;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.itemHandler) : null);
    }

    public class MinecartItemHandler
    implements IItemHandler {
        public int getSlots() {
            return 2;
        }

        public ItemStack getStackInSlot(int slot) {
            return EntityMinecartDayBarrel.this.barrel.getStackInSlot(slot);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (!simulate && slot == 0) {
                EntityMinecartDayBarrel.this.updateDataWatcher(false);
            }
            return slot == 0 ? EntityMinecartDayBarrel.this.barrel.getItemHandler(1).insertItem(slot, stack, simulate) : stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (!simulate && slot == 1) {
                EntityMinecartDayBarrel.this.updateDataWatcher(false);
            }
            return slot == 1 ? EntityMinecartDayBarrel.this.barrel.getItemHandler(0).extractItem(slot, amount, simulate) : null;
        }
    }
}

