/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.storage.barrel;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import pl.asie.charset.lib.blocks.TileBase;
import pl.asie.charset.lib.factorization.FzOrientation;
import pl.asie.charset.lib.factorization.SpaceUtil;
import pl.asie.charset.lib.notify.Notice;
import pl.asie.charset.lib.notify.NoticeUpdater;
import pl.asie.charset.lib.utils.CapabilityUtils;
import pl.asie.charset.lib.utils.ItemUtils;
import pl.asie.charset.lib.utils.PlayerUtils;
import pl.asie.charset.lib.utils.RayTraceUtils;
import pl.asie.charset.storage.ModCharsetStorage;

public class TileEntityDayBarrel
extends TileBase
implements ITickable {
    public ItemStack item;
    private ItemStack topStack;
    private int middleCount;
    private ItemStack bottomStack;
    static final ItemStack DEFAULT_LOG = new ItemStack(Blocks.field_150364_r);
    static final ItemStack DEFAULT_SLAB = new ItemStack(Blocks.field_150344_f);
    public ItemStack woodLog = DEFAULT_LOG.func_77946_l();
    public ItemStack woodSlab = DEFAULT_SLAB.func_77946_l();
    public FzOrientation orientation = FzOrientation.FACE_UP_POINT_NORTH;
    public Type type = Type.NORMAL;
    Object notice_target = this;
    private static final int maxStackDrop = 8192;
    private int last_mentioned_count = -1;
    private boolean scheduledTick = true;
    private boolean spammed = false;
    private final IItemHandler[] handlers = new IItemHandler[]{new ExtractionHandler(), new InsertionHandler(), new ReadableItemHandler()};
    long lastClick = -1000L;
    boolean broken_with_silk_touch = false;

    private void markChunkDirty() {
        this.field_145850_b.func_175646_b(this.field_174879_c, (TileEntity)this);
    }

    @Override
    public void readNBTData(NBTTagCompound compound, boolean isClient) {
        this.item = ItemStack.func_77949_a((NBTTagCompound)compound.func_74775_l("item"));
        this.setItemCount(compound.func_74762_e("count"));
        this.orientation = FzOrientation.getOrientation(compound.func_74771_c("dir"));
        this.woodLog = ItemStack.func_77949_a((NBTTagCompound)compound.func_74775_l("log"));
        this.woodSlab = ItemStack.func_77949_a((NBTTagCompound)compound.func_74775_l("slab"));
        this.type = Type.VALUES[compound.func_74771_c("type")];
        if (this.woodLog == null) {
            this.woodLog = DEFAULT_LOG;
        }
        if (this.woodSlab == null) {
            this.woodSlab = DEFAULT_SLAB;
        }
        this.last_mentioned_count = this.getItemCount();
    }

    @Override
    public NBTTagCompound writeNBTData(NBTTagCompound compound, boolean isClient) {
        if (this.woodLog == null) {
            this.woodLog = DEFAULT_LOG;
        }
        if (this.woodSlab == null) {
            this.woodSlab = DEFAULT_SLAB;
        }
        ItemUtils.writeToNBT(this.item, compound, "item");
        ItemUtils.writeToNBT(this.woodLog, compound, "log");
        ItemUtils.writeToNBT(this.woodSlab, compound, "slab");
        compound.func_74774_a("dir", (byte)this.orientation.ordinal());
        compound.func_74774_a("type", (byte)this.type.ordinal());
        compound.func_74768_a("count", this.getItemCount());
        return compound;
    }

    public int getLogicSpeed() {
        return 8;
    }

    public void func_73660_a() {
        if (this.func_145831_w() == null || this.func_145831_w().field_72995_K) {
            return;
        }
        if (!this.scheduledTick || this.func_145831_w().func_82737_E() % (long)this.getLogicSpeed() != 0L) {
            return;
        }
        this.tick();
    }

    void tick() {
        IItemHandler handler;
        if (!this.type.isHopping() || this.orientation == null) {
            return;
        }
        if (this.notice_target == this && this.field_145850_b.func_175676_y(this.field_174879_c) > 0) {
            return;
        }
        boolean youve_changed_jim = false;
        int itemCount = this.getItemCount();
        if (itemCount < this.getMaxSize()) {
            BlockPos upPos = this.func_174877_v().func_177972_a(this.orientation.top);
            handler = (IItemHandler)CapabilityUtils.getCapability(this.func_145831_w(), upPos, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.orientation.top.func_176734_d(), true, true);
            if (handler != null) {
                for (int i = 0; i < handler.getSlots(); ++i) {
                    ItemStack got = handler.extractItem(i, 1, true);
                    if (got == null || !this.taint(got)) continue;
                    got = handler.extractItem(i, 1, false);
                    this.taint(got);
                    this.changeItemCount(1);
                    this.updateStacks();
                    youve_changed_jim = true;
                }
            }
        }
        if (itemCount > 0) {
            ItemStack bottom_item;
            BlockPos downPos = this.func_174877_v().func_177972_a(this.orientation.top.func_176734_d());
            handler = (IItemHandler)CapabilityUtils.getCapability(this.func_145831_w(), downPos, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.orientation.top, true, true);
            if (handler != null && (bottom_item = this.getStackInSlot(1)) != null) {
                ItemStack toPush = bottom_item.func_77979_a(1);
                if (handler != null) {
                    boolean inserted = false;
                    for (int i = 0; i < handler.getSlots(); ++i) {
                        ItemStack got = handler.insertItem(i, toPush, false);
                        if (got != null) continue;
                        inserted = true;
                        this.updateStacks();
                        this.cleanBarrel();
                        youve_changed_jim = true;
                        break;
                    }
                    if (!inserted) {
                        ++bottom_item.field_77994_a;
                    }
                }
            }
        }
        if (youve_changed_jim) {
            this.func_70296_d();
        }
    }

    private void needLogic() {
        this.scheduledTick = true;
    }

    public void neighborChanged() {
        if (this.type.isHopping()) {
            this.needLogic();
        }
    }

    public int getItemCount() {
        if (this.item == null) {
            return 0;
        }
        if (this.type == Type.CREATIVE) {
            return 32 * this.item.func_77976_d();
        }
        if (this.topStack == null || !this.itemMatch(this.topStack)) {
            this.topStack = this.item.func_77946_l();
            this.topStack.field_77994_a = 0;
        }
        if (this.bottomStack == null || !this.itemMatch(this.bottomStack)) {
            this.bottomStack = this.item.func_77946_l();
            this.bottomStack.field_77994_a = 0;
        }
        int ret = this.bottomStack.field_77994_a + this.middleCount + this.topStack.field_77994_a;
        return ret;
    }

    public int getItemCountSticky() {
        int count = this.getItemCount();
        if (this.type == Type.STICKY) {
            return Math.max(0, --count);
        }
        return count;
    }

    public int getMaxSize() {
        int size = 4096;
        if (this.item != null) {
            size = this.item.func_77976_d() * 64;
        }
        if (this.type == Type.LARGER) {
            size *= 2;
        }
        return size;
    }

    public boolean itemMatch(ItemStack is) {
        if (is == null || this.item == null) {
            return false;
        }
        return ItemUtils.canMerge(this.item, is);
    }

    boolean taint(ItemStack is) {
        if (is == null && this.item == null) {
            return true;
        }
        if (is == null || TileEntityDayBarrel.isNested(is)) {
            return false;
        }
        if (this.item == null) {
            this.item = is.func_77946_l();
            this.item.field_77994_a = 0;
            return true;
        }
        return ItemUtils.canMerge(this.item, is);
    }

    boolean isTop(EnumFacing d) {
        return d == this.orientation.top;
    }

    boolean isTopOrBack(EnumFacing d) {
        return d == this.orientation.top || d == this.orientation.facing.func_176734_d();
    }

    boolean isBottom(EnumFacing d) {
        return d == this.orientation.top.func_176734_d();
    }

    boolean isBack(EnumFacing d) {
        return d == this.orientation.facing.func_176734_d();
    }

    public void setItemCount(int val) {
        this.bottomStack = null;
        this.topStack = null;
        this.middleCount = val;
        this.changeItemCount(0);
    }

    public void changeItemCount(int delta) {
        this.middleCount = this.getItemCount() + delta;
        if (this.middleCount < 0) {
            if (!this.spammed) {
                ModCharsetStorage.logger.error("Tried to set the item count to negative value " + this.middleCount + " at " + this.func_174877_v());
                Thread.dumpStack();
                this.spammed = true;
            }
            this.middleCount = 0;
            this.item = null;
        }
        if (this.middleCount == 0) {
            this.item = null;
            this.bottomStack = null;
            this.topStack = null;
            this.updateClients(BarrelMessage.BarrelCount);
            this.func_70296_d();
            return;
        }
        if (this.middleCount > this.getMaxSize() && !this.spammed && this.field_145850_b != null) {
            ModCharsetStorage.logger.error("Factorization barrel size, " + this.middleCount + ", is larger than the maximum, " + this.getMaxSize() + ". Contents: " + this.item + " " + (this.item != null ? this.item.func_77973_b() : "<null>") + " At: " + this.func_174877_v() + " BarrelType = " + (Object)((Object)this.type));
            ModCharsetStorage.logger.error("Did the max stack size go down, or is someone doing something bad?");
            Thread.dumpStack();
            this.spammed = true;
        }
        if (this.topStack == null) {
            this.topStack = this.item.func_77946_l();
        }
        if (this.bottomStack == null) {
            this.bottomStack = this.item.func_77946_l();
        }
        this.bottomStack.field_77994_a = 0;
        this.topStack.field_77994_a = 0;
        this.updateStacks();
        this.updateClients(BarrelMessage.BarrelCount);
        this.func_70296_d();
    }

    @Override
    public void onPlacedBy(EntityLivingBase placer, ItemStack stack) {
        RayTraceResult hit = RayTraceUtils.getCollision(this.func_145831_w(), this.func_174877_v(), placer, Block.field_185505_j, 0);
        if (hit != null) {
            if (hit.field_72307_f != null) {
                this.orientation = SpaceUtil.getOrientation(placer, hit.field_178784_b, hit.field_72307_f.func_178788_d(new Vec3d((Vec3i)this.func_174877_v())));
            } else if (hit.field_178784_b != null) {
                this.orientation = FzOrientation.fromDirection(hit.field_178784_b);
            }
        }
        this.loadFromStack(stack);
        this.needLogic();
    }

    public void loadFromStack(ItemStack is) {
        ItemStack loadItem;
        NBTTagCompound tag;
        int loadCount;
        this.woodLog = TileEntityDayBarrel.getLog(is);
        this.woodSlab = TileEntityDayBarrel.getSlab(is);
        this.type = TileEntityDayBarrel.getUpgrade(is);
        if (this.type == Type.SILKY && is.func_77942_o() && (loadCount = (tag = is.func_77978_p()).func_74762_e("SilkCount")) != 0 && (loadItem = TileEntityDayBarrel.getSilkedItem(is)) != null) {
            this.item = loadItem;
            this.setItemCount(loadCount);
        }
    }

    public static ItemStack getSilkedItem(ItemStack is) {
        if (is == null || !is.func_77942_o()) {
            return null;
        }
        NBTTagCompound tag = is.func_77978_p();
        if (tag.func_74764_b("SilkItem")) {
            return ItemStack.func_77949_a((NBTTagCompound)is.func_77978_p().func_74775_l("SilkItem"));
        }
        return null;
    }

    public static boolean isNested(ItemStack is) {
        return TileEntityDayBarrel.getSilkedItem(is) != null;
    }

    void updateClients(BarrelMessage messageType) {
        if (this.func_145830_o()) {
            this.markBlockForUpdate();
        }
    }

    void cleanBarrel() {
        if (this.getItemCount() == 0) {
            this.item = null;
            this.bottomStack = null;
            this.topStack = null;
            this.middleCount = 0;
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.cleanBarrel();
        this.updateStacks();
        this.sync();
        if (this.type.isHopping()) {
            this.needLogic();
        }
    }

    void sync() {
        int c = this.getItemCount();
        if (c != this.last_mentioned_count) {
            if (this.last_mentioned_count * c <= 0) {
                this.updateClients(BarrelMessage.BarrelItem);
            } else {
                this.updateClients(BarrelMessage.BarrelCount);
            }
            this.last_mentioned_count = c;
        }
    }

    private void updateStacks() {
        if (this.item == null) {
            this.bottomStack = null;
            this.topStack = null;
            this.middleCount = 0;
            return;
        }
        int count = this.getItemCount();
        if (count == 0) {
            this.bottomStack = null;
            this.topStack = null;
            this.middleCount = 0;
            return;
        }
        if (this.bottomStack == null) {
            this.bottomStack = this.item.func_77946_l();
            this.bottomStack.field_77994_a = 0;
        }
        if (this.type == Type.STICKY && --count < 0) {
            return;
        }
        int upperLine = this.getMaxSize() - this.item.func_77976_d();
        if (this.topStack == null) {
            this.topStack = this.item.func_77946_l();
        }
        if (count > upperLine) {
            this.topStack.field_77994_a = count - upperLine;
            count -= this.topStack.field_77994_a;
        } else {
            this.topStack.field_77994_a = 0;
        }
        this.bottomStack.field_77994_a = Math.min(this.item.func_77976_d(), count);
        this.middleCount = count -= this.bottomStack.field_77994_a;
        if (this.type == Type.STICKY) {
            ++this.middleCount;
        }
    }

    public ItemStack getStackInSlot(int i) {
        this.updateStacks();
        if (i == 0) {
            return this.topStack;
        }
        if (i == 1) {
            return this.bottomStack;
        }
        return null;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.isTop(facing) || this.isBottom(facing) || facing == null;
        }
        return false;
    }

    IItemHandler getItemHandler(int id) {
        return this.handlers[id];
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.isBottom(facing)) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.handlers[0]);
            }
            if (this.isTop(facing)) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.handlers[1]);
            }
            if (facing == null) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.handlers[2]);
            }
        }
        return null;
    }

    public void clear() {
        this.setItemCount(0);
    }

    public boolean activate(EntityPlayer entityplayer, EnumFacing side, EnumHand hand) {
        if (this.field_145850_b.func_82737_E() - this.lastClick < 10L && this.item != null) {
            this.addAllItems(entityplayer, hand);
            return true;
        }
        this.lastClick = this.field_145850_b.func_82737_E();
        ItemStack held = entityplayer.func_184586_b(hand);
        if (held == null) {
            this.info(entityplayer);
            return true;
        }
        if (!this.field_145850_b.field_72995_K && TileEntityDayBarrel.isNested(held) && (this.item == null || this.itemMatch(held))) {
            new Notice(this.notice_target, "notice.charset.barrel.no", new String[0]).sendTo(entityplayer);
            return true;
        }
        NBTTagCompound tag = held.func_77978_p();
        if (tag != null && tag.func_74764_b("noFzBarrel")) {
            return false;
        }
        boolean veryNew = this.taint(held);
        if (!this.itemMatch(held)) {
            this.info(entityplayer);
            return true;
        }
        int free = this.getMaxSize() - this.getItemCount();
        if (free <= 0) {
            this.info(entityplayer);
            return true;
        }
        int take = Math.min(free, held.field_77994_a);
        held.field_77994_a -= take;
        this.changeItemCount(take);
        if (veryNew) {
            this.updateClients(BarrelMessage.BarrelItem);
        }
        if (held.field_77994_a == 0) {
            entityplayer.func_184611_a(hand, null);
        }
        return true;
    }

    void addAllItems(EntityPlayer entityplayer, EnumHand hand) {
        int free_space;
        ItemStack held = entityplayer.func_184586_b(hand);
        if (held != null) {
            this.taint(held);
        }
        InventoryPlayer inv = entityplayer.field_71071_by;
        int total_delta = 0;
        for (int i = 0; i < inv.func_70302_i_() && (free_space = this.getMaxSize() - (this.getItemCount() + total_delta)) > 0; ++i) {
            ItemStack is = inv.func_70301_a(i);
            if (is == null || is.field_77994_a <= 0 || !this.itemMatch(is)) continue;
            int toAdd = Math.min(is.field_77994_a, free_space);
            if (is == held && toAdd > 1) {
                --toAdd;
            }
            total_delta += toAdd;
            is.field_77994_a -= toAdd;
            if (is.field_77994_a > 0) continue;
            inv.func_70299_a(i, null);
        }
        this.changeItemCount(total_delta);
        if (total_delta > 0) {
            entityplayer.field_71071_by.func_70296_d();
        }
    }

    static boolean isStairish(World w, BlockPos pos) {
        IBlockState b = w.func_180495_p(pos);
        AxisAlignedBB ab = b.func_185890_d(w, pos);
        ArrayList list = new ArrayList();
        b.func_185908_a(w, pos, ab, list, null);
        for (AxisAlignedBB bb : list) {
            if (!(bb.field_72337_e - (double)pos.func_177956_o() <= 0.51)) continue;
            return true;
        }
        return false;
    }

    boolean punt(EntityPlayer player, EnumHand hand) {
        BlockPos src;
        int distance = PlayerUtils.getPuntStrengthInt(player);
        if (distance <= 0) {
            return false;
        }
        RayTraceResult result = RayTraceUtils.getCollision(this.func_145831_w(), this.func_174877_v(), (EntityLivingBase)player, Block.field_185505_j, 0);
        if (result == null || result.field_178784_b == null) {
            return false;
        }
        EnumFacing dir = result.field_178784_b.func_176734_d();
        BlockPos next = src = this.func_174877_v();
        FzOrientation newOrientation = this.orientation;
        boolean doRotation = dir.func_176730_m().func_177956_o() == 0;
        EnumFacing rotationAxis = null;
        if (doRotation) {
            rotationAxis = SpaceUtil.rotate(dir, EnumFacing.UP);
        }
        if (player.func_70093_af() && distance > 1) {
            distance = 1;
        }
        int spillage = distance;
        int doubleRolls = 0;
        for (int i = 0; i < distance && i <= 6; ++i) {
            boolean must_rise_or_fail = false;
            BlockPos peek = next.func_177972_a(dir);
            if (!this.func_145831_w().func_175667_e(peek)) break;
            IBlockState peekState = this.func_145831_w().func_180495_p(peek);
            BlockPos below = peek.func_177972_a(EnumFacing.DOWN);
            int rotateCount = 1;
            if (!peekState.func_177230_c().func_176200_f((IBlockAccess)this.func_145831_w(), peek)) {
                if (!TileEntityDayBarrel.isStairish(this.func_145831_w(), peek)) break;
                BlockPos above = peek.func_177972_a(EnumFacing.UP);
                if (!this.func_145831_w().func_175623_d(above)) break;
                next = above;
                spillage += 3;
                ++rotateCount;
                ++doubleRolls;
            } else if (this.func_145831_w().func_180495_p(below).func_177230_c().func_176200_f((IBlockAccess)this.func_145831_w(), below) && i != distance - 1) {
                next = below;
                ++spillage;
            } else {
                next = peek;
            }
            if (!doRotation) {
                rotateCount = 0;
            }
            for (int r = rotateCount; r > 0; --r) {
                EnumFacing nTop = SpaceUtil.rotate(newOrientation.top, rotationAxis);
                EnumFacing nFace = SpaceUtil.rotate(newOrientation.facing, rotationAxis);
                newOrientation = FzOrientation.fromDirection(nFace).pointTopTo(nTop);
            }
        }
        if (src.equals((Object)next)) {
            return false;
        }
        if (!doRotation && this.orientation.top == EnumFacing.UP && dir == EnumFacing.UP) {
            spillage = 0;
        }
        this.func_145831_w().func_175713_t(src);
        this.func_145831_w().func_175698_g(src);
        if (newOrientation != null) {
            this.orientation = newOrientation;
        }
        this.func_145829_t();
        this.func_145831_w().func_175656_a(next, ModCharsetStorage.barrelBlock.func_176223_P());
        this.func_145831_w().func_175690_a(next, (TileEntity)this);
        player.func_71020_j(0.5f);
        ItemStack is = player.func_184586_b(hand);
        if (is != null && is.func_77984_f() && this.field_145850_b.field_73012_v.nextInt(4) == 0) {
            is.func_77972_a(distance, (EntityLivingBase)player);
            if (is.field_77994_a <= 0) {
                player.func_184611_a(hand, null);
            }
        }
        return true;
    }

    public void click(EntityPlayer entityplayer) {
        ItemStack newHeld;
        EnumHand hand = EnumHand.MAIN_HAND;
        if (this.punt(entityplayer, hand)) {
            return;
        }
        if (this.getItemCount() == 0 || this.item == null) {
            this.info(entityplayer);
            return;
        }
        ItemStack origHeldItem = entityplayer.func_184586_b(hand);
        if (ForgeHooks.canToolHarvestBlock((IBlockAccess)this.field_145850_b, (BlockPos)this.field_174879_c, (ItemStack)origHeldItem)) {
            return;
        }
        int to_remove = Math.min(this.item.func_77976_d(), this.getItemCount());
        if (entityplayer.func_70093_af() && to_remove >= 1) {
            to_remove = 1;
        }
        if (to_remove > 1 && to_remove == this.getItemCount()) {
            --to_remove;
        }
        BlockPos dropPos = this.func_174877_v();
        RayTraceResult result = RayTraceUtils.getCollision(this.func_145831_w(), this.func_174877_v(), (EntityLivingBase)entityplayer, Block.field_185505_j, 0);
        if (result != null && result.field_178784_b != null) {
            dropPos = dropPos.func_177972_a(result.field_178784_b);
        }
        ItemUtils.spawnItemEntity(this.field_145850_b, new Vec3d((Vec3i)dropPos).func_72441_c(0.5, 0.5, 0.5), this.makeStack(to_remove), 0.2f, 0.2f, 0.2f, 1.0f);
        Object ent = null;
        if (ent == null || !ent.field_70128_L || entityplayer instanceof FakePlayer || (newHeld = entityplayer.func_184586_b(hand)) != origHeldItem) {
            // empty if block
        }
        this.changeItemCount(-to_remove);
        this.cleanBarrel();
    }

    void info(EntityPlayer entityplayer) {
        new Notice(this.notice_target, new NoticeUpdater(){

            @Override
            public void update(Notice msg) {
                if (TileEntityDayBarrel.this.item == null && TileEntityDayBarrel.this.getItemCount() == 0) {
                    msg.setMessage("notice.charset.barrel.empty", new String[0]);
                } else {
                    int count;
                    String countMsg = null;
                    countMsg = TileEntityDayBarrel.this.type == Type.CREATIVE ? "notice.charset.barrel.infinite" : ((count = TileEntityDayBarrel.this.getItemCount()) >= TileEntityDayBarrel.this.getMaxSize() ? "notice.charset.barrel.full" : "" + count);
                    msg.withItem(TileEntityDayBarrel.this.item).setMessage("%s {ITEM_NAME}{ITEM_INFOS_NEWLINE}", countMsg);
                }
            }
        }).sendTo(entityplayer);
    }

    private ItemStack makeStack(int count) {
        if (this.item == null) {
            return null;
        }
        ItemStack ret = this.item.func_77946_l();
        ret.field_77994_a = count;
        assert (ret.field_77994_a > 0 && ret.field_77994_a <= this.item.func_77976_d());
        return ret;
    }

    @Override
    public int getComparatorValue() {
        int count = this.getItemCount();
        if (count == 0) {
            return 0;
        }
        int max = this.getMaxSize();
        if (count == max) {
            return 15;
        }
        float v = (float)count / (float)max;
        return (int)Math.max(1.0f, v * 14.0f);
    }

    @Override
    public void dropContents() {
        if (this.type == Type.CREATIVE || this.type == Type.SILKY && this.broken_with_silk_touch) {
            return;
        }
        if (this.item == null || this.getItemCount() <= 0) {
            return;
        }
        int count = this.getItemCount();
        for (int i = 0; i < 8192; ++i) {
            int to_drop = Math.min(this.item.func_77976_d(), count);
            ItemUtils.spawnItemEntity(this.field_145850_b, new Vec3d((Vec3i)this.func_174877_v()).func_72441_c(0.5, 0.5, 0.5), this.makeStack(to_drop), 0.2f, 0.2f, 0.2f, 1.0f);
            if ((count -= to_drop) <= 0) break;
        }
        this.topStack = null;
        this.middleCount = 0;
        this.bottomStack = null;
    }

    public boolean canLose() {
        return this.item != null && this.getItemCount() > 8192 * this.item.func_77976_d();
    }

    public static ItemStack makeBarrel(Type type, ItemStack log, ItemStack slab) {
        ItemStack barrel_item = new ItemStack((Item)ModCharsetStorage.barrelItem);
        barrel_item = TileEntityDayBarrel.addUpgrade(barrel_item, type);
        NBTTagCompound compound = ItemUtils.getTagCompound(barrel_item, true);
        ItemUtils.writeToNBT(log, compound, "log");
        ItemUtils.writeToNBT(slab, compound, "slab");
        return barrel_item;
    }

    public static Type getUpgrade(ItemStack is) {
        if (is == null) {
            return Type.NORMAL;
        }
        NBTTagCompound tag = is.func_77978_p();
        if (tag == null) {
            return Type.NORMAL;
        }
        String name = tag.func_74779_i("type");
        if (name == null || name.equals("")) {
            return Type.NORMAL;
        }
        try {
            return Type.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            ModCharsetStorage.logger.warn("%s has invalid barrel Type %s. Resetting it.", new Object[]{is, name});
            e.printStackTrace();
            tag.func_82580_o("type");
            return Type.NORMAL;
        }
    }

    public static ItemStack getLog(ItemStack is) {
        return TileEntityDayBarrel.get(is, "log", DEFAULT_LOG);
    }

    public static ItemStack getSlab(ItemStack is) {
        return TileEntityDayBarrel.get(is, "slab", DEFAULT_SLAB);
    }

    private static ItemStack get(ItemStack is, String name, ItemStack default_) {
        ItemStack stack1;
        ItemStack stack = default_;
        if (is != null && is.func_77942_o() && is.func_77978_p().func_74764_b(name) && (stack1 = ItemStack.func_77949_a((NBTTagCompound)is.func_77978_p().func_74775_l(name))) != null) {
            stack = stack1;
        }
        return stack;
    }

    static ItemStack addUpgrade(ItemStack barrel, Type upgrade) {
        if (upgrade == Type.NORMAL) {
            return barrel;
        }
        barrel = barrel.func_77946_l();
        NBTTagCompound tag = ItemUtils.getTagCompound(barrel, true);
        tag.func_74778_a("type", upgrade.toString());
        return barrel;
    }

    public boolean canRotate(EnumFacing axis) {
        return axis != null;
    }

    public void rotate(EnumFacing axis) {
        FzOrientation oldOrientation = this.orientation;
        this.orientation = axis == this.orientation.facing.func_176734_d() ? this.orientation.getNextRotationOnFace() : FzOrientation.getOrientation(FzOrientation.fromDirection(axis.func_176734_d()).ordinal() & 0xFFFFFFFC | this.orientation.ordinal() & 3);
        if (this.orientation != oldOrientation) {
            this.markBlockForUpdate();
        }
    }

    @Override
    public ItemStack getPickedBlock() {
        return this.getDroppedBlock();
    }

    public ItemStack getDroppedBlock() {
        ItemStack is = TileEntityDayBarrel.makeBarrel(this.type, this.woodLog, this.woodSlab);
        if (this.type == Type.SILKY && this.item != null && this.getItemCount() > 0) {
            NBTTagCompound tag = is.func_77978_p();
            if (tag == null) {
                tag = new NBTTagCompound();
                is.func_77982_d(tag);
            }
            tag.func_74768_a("SilkCount", this.getItemCount());
            NBTTagCompound si = new NBTTagCompound();
            this.item.func_77955_b(si);
            tag.func_74782_a("SilkItem", (NBTBase)si);
            tag.func_74772_a("rnd", (long)((Object)((Object)this)).hashCode() + this.field_145850_b.func_82737_E());
        }
        return is;
    }

    public boolean removedByPlayer(EntityPlayer player, boolean willHarvest) {
        if (this.cancelRemovedByPlayer(player)) {
            return false;
        }
        this.broken_with_silk_touch = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)player.func_184607_cu()) > 0;
        return true;
    }

    private boolean cancelRemovedByPlayer(EntityPlayer player) {
        if (this.item == null) {
            return false;
        }
        if (player == null || !player.field_71075_bZ.field_75098_d || player.func_70093_af()) {
            return false;
        }
        if (player.field_70170_p.field_72995_K) {
            player.func_184609_a(EnumHand.MAIN_HAND);
        } else {
            this.click(player);
        }
        return true;
    }

    public boolean isWooden() {
        return ItemUtils.getBlockState(this.woodLog).func_185904_a() == Material.field_151575_d;
    }

    public int getFlamability() {
        try {
            return ItemUtils.getBlockState(this.woodLog).func_177230_c().getFlammability((IBlockAccess)this.func_145831_w(), this.func_174877_v(), null);
        }
        catch (Exception e) {
            return this.isWooden() ? 20 : 0;
        }
    }

    public Enum[] getMessages() {
        return BarrelMessage.VALUES;
    }

    static enum BarrelMessage {
        BarrelItem,
        BarrelCount,
        BarrelDoubleClickHack;

        static final BarrelMessage[] VALUES;

        static {
            VALUES = BarrelMessage.values();
        }
    }

    public static enum Type {
        NORMAL,
        SILKY,
        HOPPING,
        LARGER,
        STICKY,
        CREATIVE;

        public static final Type[] VALUES;

        public static Type valueOf(int ordinal) {
            if (ordinal < 0 || ordinal >= VALUES.length) {
                return NORMAL;
            }
            return VALUES[ordinal];
        }

        public boolean isHopping() {
            return this == HOPPING || this == CREATIVE;
        }

        static {
            VALUES = Type.values();
        }
    }

    public class ExtractionHandler
    extends BaseItemHandler {
        public ItemStack getStackInSlot(int slot) {
            TileEntityDayBarrel.this.updateStacks();
            return TileEntityDayBarrel.this.bottomStack;
        }

        @Override
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            TileEntityDayBarrel.this.updateStacks();
            int amt = Math.min(amount, TileEntityDayBarrel.this.bottomStack != null ? ((TileEntityDayBarrel)TileEntityDayBarrel.this).bottomStack.field_77994_a : 0);
            if (amt > 0) {
                ItemStack stack = TileEntityDayBarrel.this.bottomStack.func_77946_l();
                stack.field_77994_a = amount;
                if (!simulate) {
                    ((TileEntityDayBarrel)TileEntityDayBarrel.this).bottomStack.field_77994_a -= amount;
                    TileEntityDayBarrel.this.sync();
                    TileEntityDayBarrel.this.cleanBarrel();
                    TileEntityDayBarrel.this.markChunkDirty();
                }
                return stack;
            }
            return null;
        }
    }

    public class ReadableItemHandler
    extends BaseItemHandler {
        public ItemStack getStackInSlot(int slot) {
            TileEntityDayBarrel.this.updateStacks();
            return TileEntityDayBarrel.this.topStack;
        }
    }

    public class InsertionHandler
    extends BaseItemHandler {
        public ItemStack getStackInSlot(int slot) {
            TileEntityDayBarrel.this.updateStacks();
            return TileEntityDayBarrel.this.topStack;
        }

        @Override
        public ItemStack insertItem(int slot, ItemStack is, boolean simulate) {
            TileEntityDayBarrel.this.updateStacks();
            if (is == null || !TileEntityDayBarrel.this.taint(is)) {
                if (!TileEntityDayBarrel.this.spammed) {
                    ModCharsetStorage.logger.warn("Bye bye, %s", new Object[]{is});
                    Thread.dumpStack();
                    TileEntityDayBarrel.this.spammed = true;
                }
                return is;
            }
            if (TileEntityDayBarrel.this.topStack == null) {
                if (!simulate) {
                    TileEntityDayBarrel.this.topStack = is.func_77946_l();
                    TileEntityDayBarrel.this.sync();
                    TileEntityDayBarrel.this.markChunkDirty();
                }
                return null;
            }
            int inserted = Math.min(TileEntityDayBarrel.this.topStack.func_77976_d() - ((TileEntityDayBarrel)TileEntityDayBarrel.this).topStack.field_77994_a, is.field_77994_a);
            if (!simulate) {
                ((TileEntityDayBarrel)TileEntityDayBarrel.this).topStack.field_77994_a += inserted;
                TileEntityDayBarrel.this.sync();
                TileEntityDayBarrel.this.markChunkDirty();
            }
            if (inserted == is.field_77994_a) {
                return null;
            }
            ItemStack leftover = is.func_77946_l();
            leftover.field_77994_a -= inserted;
            return leftover;
        }
    }

    public abstract class BaseItemHandler
    implements IItemHandler {
        public int getSlots() {
            return 1;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return null;
        }
    }
}

