/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.storage.crate;

import java.util.EnumSet;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import pl.asie.charset.lib.blocks.TileBase;
import pl.asie.charset.lib.utils.DirectionUtils;
import pl.asie.charset.lib.utils.ItemUtils;
import pl.asie.charset.storage.ModCharsetStorage;
import pl.asie.charset.storage.crate.CrateCacheInfo;
import pl.asie.charset.storage.crate.CrateShapeCache;

public class TileEntityCrate
extends TileBase {
    public static final int CRATE_SIZE = 18;
    public CrateShapeCache cache;
    ItemStackHandler handler = new ItemStackHandler(18);
    private ItemStack plank;
    private int clientCM;

    void setCache(CrateShapeCache cache) {
        this.cache = cache;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            this.initCache();
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.cache.getHandler());
        }
        return null;
    }

    private void initCache() {
        if (this.cache == null || !this.cache.isValid()) {
            for (EnumFacing facing : DirectionUtils.NEGATIVES) {
                TileEntity tile = this.getNeighbourTile(facing);
                if (!(tile instanceof TileEntityCrate)) continue;
                TileEntityCrate other = (TileEntityCrate)tile;
                if (other.cache == null || !other.cache.add(this)) continue;
                return;
            }
            this.cache = new CrateShapeCache(this);
        }
    }

    private int getConnectionMatrix() {
        this.initCache();
        this.cache.checkDirty();
        int connectionMatrix = 0;
        EnumSet<EnumFacing> facingSet = EnumSet.noneOf(EnumFacing.class);
        if (this.func_145831_w() != null) {
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                if (!this.cache.contains(this.func_174877_v().func_177972_a(facing))) continue;
                connectionMatrix |= 1 << facing.ordinal();
                facingSet.add(facing);
            }
        }
        for (int z = 0; z < 2; ++z) {
            for (int y = 0; y < 2; ++y) {
                for (int x = 0; x < 2; ++x) {
                    EnumFacing fx = x == 0 ? EnumFacing.WEST : EnumFacing.EAST;
                    EnumFacing fy = y == 0 ? EnumFacing.DOWN : EnumFacing.UP;
                    EnumFacing fz = z == 0 ? EnumFacing.NORTH : EnumFacing.SOUTH;
                    boolean match = false;
                    if (facingSet.contains(fx) && facingSet.contains(fz)) {
                        if (this.cache.contains(this.func_174877_v().func_177972_a(fx).func_177972_a(fz))) continue;
                        match = true;
                    }
                    if (facingSet.contains(fy) && facingSet.contains(fz)) {
                        if (this.cache.contains(this.func_174877_v().func_177972_a(fy).func_177972_a(fz))) continue;
                        match = true;
                    }
                    if (facingSet.contains(fx) && facingSet.contains(fy)) {
                        if (this.cache.contains(this.func_174877_v().func_177972_a(fx).func_177972_a(fy))) continue;
                        match = true;
                    }
                    if (!match) continue;
                    connectionMatrix |= 1 << 6 + x * 4 + y * 2 + z;
                }
            }
        }
        return connectionMatrix;
    }

    @Override
    public void onPlacedBy(EntityLivingBase placer, ItemStack stack) {
        this.loadFromStack(stack);
        this.initCache();
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            TileEntity tile = this.getNeighbourTile(facing);
            if (!(tile instanceof TileEntityCrate)) continue;
            TileEntityCrate other = (TileEntityCrate)tile;
            if (other.cache == this.cache) continue;
            CrateShapeCache oldCache = other.cache;
            if (!this.cache.add(other)) continue;
            oldCache.invalidate();
            this.cache.addNeighborsRecursively(other);
        }
    }

    @Override
    public void readNBTData(NBTTagCompound compound, boolean isClient) {
        this.plank = ItemStack.func_77949_a((NBTTagCompound)compound.func_74775_l("plank"));
        if (this.plank == null) {
            this.plank = new ItemStack(Blocks.field_150344_f);
        }
        if (isClient && compound.func_74764_b("c")) {
            int oldCM = this.clientCM;
            this.clientCM = compound.func_74762_e("c");
            if (oldCM != this.clientCM) {
                this.markBlockForRenderUpdate();
            }
        } else if (!isClient && compound.func_74764_b("inv")) {
            this.handler.deserializeNBT(compound.func_74775_l("inv"));
        }
    }

    @Override
    public NBTTagCompound writeNBTData(NBTTagCompound compound, boolean isClient) {
        ItemUtils.writeToNBT(this.plank, compound, "plank");
        if (isClient) {
            compound.func_74768_a("c", this.getConnectionMatrix());
        } else {
            compound.func_74782_a("inv", (NBTBase)this.handler.serializeNBT());
        }
        return compound;
    }

    public static ItemStack create(ItemStack plank) {
        TileEntityCrate crate = new TileEntityCrate();
        crate.plank = plank;
        return crate.getDroppedBlock();
    }

    @Override
    public void dropContents() {
    }

    @Override
    public ItemStack getPickedBlock() {
        return this.getDroppedBlock();
    }

    public ItemStack getDroppedBlock() {
        ItemStack stack = new ItemStack((Block)ModCharsetStorage.crateBlock);
        ItemUtils.writeToNBT(this.plank, ItemUtils.getTagCompound(stack, true), "plank");
        return stack;
    }

    public void loadFromStack(ItemStack stack) {
        NBTTagCompound compound = stack.func_77978_p();
        this.readNBTData(compound != null ? stack.func_77978_p() : new NBTTagCompound(), true);
    }

    public CrateCacheInfo getCacheInfo() {
        return new CrateCacheInfo(this.plank, this.clientCM);
    }

    public ItemStack getMaterial() {
        return this.plank;
    }

    public void neighborChanged(Block block) {
        if (this.func_145831_w() != null && !this.func_145831_w().field_72995_K) {
            if (this.cache == null || !this.cache.isValid()) {
                this.func_70296_d();
                this.markBlockForUpdate();
            } else {
                this.cache.checkDirty();
            }
        }
    }

    public int getFlamability() {
        try {
            return ItemUtils.getBlockState(this.plank).func_177230_c().getFlammability((IBlockAccess)this.func_145831_w(), this.func_174877_v(), null);
        }
        catch (Exception e) {
            return 20;
        }
    }
}

