/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.storage.locking;

import com.google.common.base.Predicate;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.ILockableContainer;
import net.minecraft.world.LockCode;
import net.minecraft.world.World;
import pl.asie.charset.api.storage.IKeyItem;
import pl.asie.charset.storage.ModCharsetStorage;
import pl.asie.charset.storage.locking.ItemKey;
import pl.asie.charset.storage.locking.ItemLock;

public class EntityLock
extends EntityHanging {
    static final DataParameter<Integer> COLOR_0 = EntityDataManager.func_187226_a(EntityLock.class, (DataSerializer)DataSerializers.field_187192_b);
    static final DataParameter<Integer> COLOR_1 = EntityDataManager.func_187226_a(EntityLock.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<EnumFacing> HANGING_ROTATION = EntityDataManager.func_187226_a(EntityLock.class, (DataSerializer)DataSerializers.field_187202_l);
    private static final Predicate<Entity> IS_HANGING_ENTITY = new Predicate<Entity>(){

        public boolean apply(Entity entity) {
            return entity instanceof EntityHanging;
        }
    };
    private String lockKey = null;
    private String prefixedLockKey = null;
    private int[] colors = new int[]{-1, -1};
    private TileEntity tileCached;

    public EntityLock(World worldIn) {
        super(worldIn);
    }

    public EntityLock(World worldIn, ItemStack stack, BlockPos p_i45852_2_, EnumFacing p_i45852_3_) {
        super(worldIn, p_i45852_2_);
        this.setColors(stack.func_77978_p());
        this.setLockKey(((ItemLock)stack.func_77973_b()).getRawKey(stack));
        this.func_174859_a(p_i45852_3_);
    }

    private void setColors(NBTTagCompound compound) {
        if (compound != null) {
            this.colors[0] = compound.func_74764_b("color0") ? compound.func_74762_e("color0") : -1;
            this.colors[1] = compound.func_74764_b("color1") ? compound.func_74762_e("color1") : -1;
        } else {
            this.colors[0] = -1;
            this.colors[1] = -1;
        }
        this.func_184212_Q().func_187227_b(COLOR_0, (Object)this.colors[0]);
        this.func_184212_Q().func_187227_b(COLOR_1, (Object)this.colors[1]);
        this.func_184212_Q().func_187217_b(COLOR_0);
        this.func_184212_Q().func_187217_b(COLOR_1);
    }

    private void setLockKey(String s) {
        this.lockKey = s;
        this.prefixedLockKey = s != null ? "charset:key:" + s : null;
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setLockKey(compound.func_74764_b("key") ? compound.func_74779_i("key") : null);
        this.setColors(compound);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.lockKey != null) {
            compound.func_74778_a("key", this.lockKey);
        }
        if (this.colors[0] != -1) {
            compound.func_74768_a("color0", this.colors[0]);
        }
        if (this.colors[1] != -1) {
            compound.func_74768_a("color1", this.colors[1]);
        }
    }

    public TileEntity getAttachedTile() {
        if (this.tileCached == null || this.tileCached.func_145837_r()) {
            BlockPos pos = this.field_174861_a.func_177972_a(this.field_174860_b.func_176734_d());
            this.tileCached = this.field_70170_p.func_175625_s(pos);
        }
        return this.tileCached;
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(HANGING_ROTATION, null);
        this.func_184212_Q().func_187214_a(COLOR_0, null);
        this.func_184212_Q().func_187214_a(COLOR_1, null);
        this.func_184224_h(true);
    }

    public boolean func_85031_j(Entity entityIn) {
        if (entityIn instanceof EntityPlayer && entityIn.func_70093_af()) {
            if (!this.field_70170_p.field_72995_K) {
                ItemStack stack = ((EntityPlayer)entityIn).func_184614_ca();
                if (!(stack != null && stack.func_77973_b() instanceof ItemKey && ((ItemKey)stack.func_77973_b()).canUnlock(this.prefixedLockKey, stack) || (stack = ((EntityPlayer)entityIn).func_184592_cb()) != null && stack.func_77973_b() instanceof ItemKey && ((ItemKey)stack.func_77973_b()).canUnlock(this.prefixedLockKey, stack))) {
                    return super.func_85031_j(entityIn);
                }
                if (!this.field_70128_L) {
                    this.func_70106_y();
                    this.func_110128_b(entityIn);
                }
                return true;
            }
            return super.func_85031_j(entityIn);
        }
        return super.func_85031_j(entityIn);
    }

    public void func_70071_h_() {
        ILockableContainer container;
        super.func_70071_h_();
        if (!(this.lockKey == null || this.lockKey.length() <= 0 || !(this.getAttachedTile() instanceof ILockableContainer) || (container = (ILockableContainer)this.tileCached).func_174893_q_() && this.prefixedLockKey.equals(container.func_174891_i().func_180159_b()))) {
            container.func_174892_a(new LockCode(this.prefixedLockKey));
        }
    }

    protected void func_174859_a(EnumFacing facingDirectionIn) {
        super.func_174859_a(facingDirectionIn);
        this.func_184212_Q().func_187227_b(HANGING_ROTATION, (Object)facingDirectionIn);
        this.func_184212_Q().func_187217_b(HANGING_ROTATION);
    }

    public void func_184206_a(DataParameter<?> key) {
        EnumFacing facing;
        if (key == HANGING_ROTATION && (facing = (EnumFacing)this.func_184212_Q().func_187225_a(HANGING_ROTATION)) != null) {
            this.func_174859_a(facing);
        }
    }

    public EnumActionResult func_184199_a(EntityPlayer player, Vec3d vec, ItemStack stack, EnumHand hand) {
        if (hand == EnumHand.MAIN_HAND && this.lockKey != null) {
            IKeyItem key;
            boolean canUnlock = false;
            if (stack != null && stack.func_77973_b() instanceof IKeyItem) {
                key = (IKeyItem)stack.func_77973_b();
                canUnlock = key.canUnlock(this.prefixedLockKey, stack);
            }
            if (!canUnlock && (stack = player.func_184592_cb()) != null && stack.func_77973_b() instanceof IKeyItem) {
                key = (IKeyItem)stack.func_77973_b();
                canUnlock = key.canUnlock(this.prefixedLockKey, stack);
            }
            if (this.getAttachedTile() instanceof ILockableContainer) {
                ILockableContainer container = (ILockableContainer)this.tileCached;
                if (canUnlock) {
                    this.unlockContainer();
                }
                BlockPos pos = this.field_174861_a.func_177972_a(this.field_174860_b.func_176734_d());
                IBlockState state = this.field_70170_p.func_180495_p(pos);
                state.func_177230_c().func_180639_a(this.field_70170_p, pos, state, player, hand, stack, this.field_174860_b, 0.5f + (float)this.field_174860_b.func_82601_c() * 0.5f, 0.5f + (float)this.field_174860_b.func_96559_d() * 0.5f, 0.5f + (float)this.field_174860_b.func_82599_e() * 0.5f);
                if (canUnlock) {
                    container.func_174892_a(new LockCode(this.prefixedLockKey));
                    return EnumActionResult.SUCCESS;
                }
                return EnumActionResult.FAIL;
            }
        }
        return EnumActionResult.SUCCESS;
    }

    public float func_70111_Y() {
        return 0.0f;
    }

    public boolean func_70518_d() {
        if (!this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty()) {
            return false;
        }
        BlockPos pos = this.field_174861_a.func_177972_a(this.field_174860_b.func_176734_d());
        TileEntity tile = this.field_70170_p.func_175625_s(pos);
        if (!(tile instanceof ILockableContainer)) {
            return false;
        }
        return this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ(), IS_HANGING_ENTITY).isEmpty();
    }

    public int func_82329_d() {
        return 8;
    }

    public int func_82330_g() {
        return 8;
    }

    private void unlockContainer() {
        if (this.getAttachedTile() instanceof ILockableContainer) {
            this.unlockContainer((ILockableContainer)this.tileCached);
        }
        if (this.tileCached instanceof TileEntityChest) {
            ((TileEntityChest)this.tileCached).func_145979_i();
            if (((TileEntityChest)this.tileCached).field_145991_k != null) {
                this.unlockContainer((ILockableContainer)((TileEntityChest)this.tileCached).field_145991_k);
            }
            if (((TileEntityChest)this.tileCached).field_145990_j != null) {
                this.unlockContainer((ILockableContainer)((TileEntityChest)this.tileCached).field_145990_j);
            }
            if (((TileEntityChest)this.tileCached).field_145992_i != null) {
                this.unlockContainer((ILockableContainer)((TileEntityChest)this.tileCached).field_145992_i);
            }
            if (((TileEntityChest)this.tileCached).field_145988_l != null) {
                this.unlockContainer((ILockableContainer)((TileEntityChest)this.tileCached).field_145988_l);
            }
        }
    }

    private void unlockContainer(ILockableContainer container) {
        if (container.func_174893_q_()) {
            if (this.lockKey != null && !this.prefixedLockKey.equals(container.func_174891_i().func_180159_b())) {
                return;
            }
            container.func_174892_a(null);
        }
    }

    private ItemStack createItemStack(Item item) {
        ItemStack lock = new ItemStack(item);
        lock.func_77982_d(new NBTTagCompound());
        if (this.lockKey != null) {
            lock.func_77978_p().func_74778_a("key", this.lockKey);
        }
        if (this.colors[0] != -1) {
            lock.func_77978_p().func_74768_a("color0", this.colors[0]);
        }
        if (this.colors[1] != -1) {
            lock.func_77978_p().func_74768_a("color1", this.colors[1]);
        }
        return lock;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return this.createItemStack(ModCharsetStorage.keyItem);
    }

    public void func_110128_b(Entity brokenEntity) {
        this.unlockContainer();
        this.func_70099_a(this.createItemStack(ModCharsetStorage.lockItem), 0.0f);
    }

    public void func_184523_o() {
    }
}

