/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.wires;

import java.util.HashSet;
import java.util.Set;
import mcmultipart.microblock.IMicroblock;
import mcmultipart.multipart.IMultipart;
import mcmultipart.multipart.IMultipartContainer;
import mcmultipart.multipart.IRedstonePart;
import mcmultipart.multipart.ISlottedPart;
import mcmultipart.multipart.MultipartHelper;
import mcmultipart.multipart.PartSlot;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import pl.asie.charset.api.wires.WireFace;
import pl.asie.charset.api.wires.WireType;
import pl.asie.charset.lib.Capabilities;
import pl.asie.charset.lib.utils.MultipartUtils;
import pl.asie.charset.wires.logic.PartWireSignalBase;

public final class WireUtils {
    private static final Set<Block> WIRE_PLACEABLE = new HashSet<Block>();

    private WireUtils() {
    }

    public static int getRedstoneWireLevel(IMultipartContainer container, WireFace face) {
        PartWireSignalBase wire = WireUtils.getWire(container, face);
        return wire.getSignalLevel();
    }

    public static int getInsulatedWireLevel(IMultipartContainer container, WireFace face, int color) {
        PartWireSignalBase wire = WireUtils.getWire(container, face);
        switch (wire.getWireType()) {
            case NORMAL: {
                return wire.getSignalLevel();
            }
            case INSULATED: {
                return wire.getColor() == color ? wire.getSignalLevel() : 0;
            }
            case BUNDLED: {
                return wire.getBundledSignalLevel(color);
            }
        }
        return 0;
    }

    public static int getBundledWireLevel(IMultipartContainer container, WireFace face, int color) {
        PartWireSignalBase wire = WireUtils.getWire(container, face);
        switch (wire.getWireType()) {
            case INSULATED: {
                return wire.getColor() == color ? wire.getSignalLevel() : 0;
            }
            case BUNDLED: {
                return wire.getBundledSignalLevel(color);
            }
        }
        return 0;
    }

    private static boolean isBlockingPart(IMultipartContainer container, PartSlot slot) {
        ISlottedPart part = container.getPartInSlot(slot);
        if (part instanceof IMicroblock.IFaceMicroblock) {
            return !((IMicroblock.IFaceMicroblock)part).isEdgeHollow();
        }
        return part != null;
    }

    public static PartSlot getSlotForFace(WireFace face) {
        return PartSlot.VALUES[face.ordinal()];
    }

    public static PartWireSignalBase getWire(IMultipartContainer container, WireFace face) {
        if (container != null) {
            ISlottedPart part = container.getPartInSlot(WireUtils.getSlotForFace(face));
            return part instanceof PartWireSignalBase ? (PartWireSignalBase)part : null;
        }
        return null;
    }

    public static int getRedstoneLevel(World world, BlockPos pos, IBlockState state, EnumFacing facing, WireFace face, boolean weak) {
        EnumFacing facingOpposite = facing == null ? null : facing.func_176734_d();
        int power = 0;
        IMultipartContainer container = MultipartHelper.getPartContainer((IBlockAccess)world, (BlockPos)pos);
        if (container != null) {
            if (WireUtils.getWire(container, face) != null || WireUtils.getWire(container, WireFace.get(facingOpposite)) != null) {
                return 0;
            }
            for (IMultipart part : container.getParts()) {
                if (part instanceof PartWireSignalBase || !(part instanceof IRedstonePart)) continue;
                power = Math.max(power, ((IRedstonePart)part).getWeakSignal(facingOpposite));
            }
        }
        if (MultipartUtils.hasCapability(Capabilities.REDSTONE_EMITTER, world, pos, WireUtils.getSlotForFace(face), facingOpposite)) {
            power = Math.max(power, MultipartUtils.getCapability(Capabilities.REDSTONE_EMITTER, world, pos, WireUtils.getSlotForFace(face), facingOpposite).getRedstoneSignal());
        }
        Block block = state.func_177230_c();
        if (power == 0) {
            if (weak) {
                if (block instanceof BlockRedstoneWire && face == WireFace.DOWN) {
                    return (Integer)state.func_177229_b((IProperty)BlockRedstoneWire.field_176351_O);
                }
                return block.shouldCheckWeakPower(state, (IBlockAccess)world, pos, facing) ? state.func_185893_b((IBlockAccess)world, pos, facing) : state.func_185911_a((IBlockAccess)world, pos, facing);
            }
            return state.func_185893_b((IBlockAccess)world, pos, facing);
        }
        return power;
    }

    public static int width(WireType type) {
        switch (type) {
            case NORMAL: {
                return 2;
            }
            case INSULATED: {
                return 4;
            }
            case BUNDLED: {
                return 6;
            }
        }
        return 0;
    }

    public static int height(WireType type) {
        switch (type) {
            case NORMAL: {
                return 2;
            }
            case INSULATED: {
                return 3;
            }
            case BUNDLED: {
                return 4;
            }
        }
        return 0;
    }

    public static boolean canPlaceWire(IBlockAccess world, BlockPos pos, EnumFacing side) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (WIRE_PLACEABLE.contains(state.func_177230_c())) {
            return true;
        }
        return block.isSideSolid(state, world, pos, side);
    }

    static {
        WIRE_PLACEABLE.add(Blocks.field_150426_aN);
        WIRE_PLACEABLE.add((Block)Blocks.field_150331_J);
        WIRE_PLACEABLE.add((Block)Blocks.field_180384_M);
        WIRE_PLACEABLE.add((Block)Blocks.field_150320_F);
    }
}

