/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.wires.logic;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import mcmultipart.MCMultiPartMod;
import mcmultipart.multipart.IMultipartContainer;
import mcmultipart.multipart.MultipartHelper;
import mcmultipart.multipart.PartSlot;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.asie.charset.api.wires.IRedstoneEmitter;
import pl.asie.charset.api.wires.IRedstoneReceiver;
import pl.asie.charset.api.wires.WireFace;
import pl.asie.charset.api.wires.WireType;
import pl.asie.charset.lib.Capabilities;
import pl.asie.charset.wires.WireUtils;
import pl.asie.charset.wires.logic.PartWireSignalBase;

public class PartWireNormal
extends PartWireSignalBase
implements IRedstoneEmitter,
IRedstoneReceiver {
    private int signalLevel;

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getRenderColor() {
        if (this.getWireType() == WireType.INSULATED) {
            return EnumDyeColor.func_176764_b((int)this.getColor()).func_176768_e().field_76291_p;
        }
        int signalValue = this.signalLevel >> 8;
        int v = (signalValue > 0 ? 150 : 120) + signalValue * 7;
        return v << 16 | v << 8 | v;
    }

    @Override
    public void handlePacket(ByteBuf data) {
        super.handlePacket(data);
        if (this.getWireType() == WireType.NORMAL) {
            byte d = data.readByte();
            this.signalLevel = d << 8;
            this.markRenderUpdate();
        }
    }

    @Override
    public void writeUpdatePacket(PacketBuffer data) {
        super.writeUpdatePacket(data);
        if (this.getWireType() == WireType.NORMAL) {
            data.writeByte(this.signalLevel >> 8);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        if (nbt.func_74764_b("s")) {
            this.signalLevel = nbt.func_74765_d("s");
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74777_a("s", (short)this.signalLevel);
        return nbt;
    }

    @Override
    protected void onSignalChanged(int color) {
        if (this.getWorld() != null && !this.getWorld().field_72995_K) {
            this.propagate(color);
        }
    }

    protected int getRedstoneLevel(IMultipartContainer container, WireFace location) {
        return WireUtils.getRedstoneWireLevel(container, location);
    }

    @Override
    public void propagate(int color) {
        EnumFacing facing;
        if (DEBUG) {
            System.out.println("--- PROPAGATE " + this.getPos().toString() + " " + this.location.name() + " (" + this.getWorld().func_82737_E() + ") ---");
        }
        int maxSignal = 0;
        int oldSignal = this.signalLevel;
        int[] neighborLevel = new int[7];
        boolean[] isWire = new boolean[7];
        boolean hasRedstoneWire = false;
        PartWireSignalBase.PROPAGATING = true;
        if (this.getWireType() == WireType.NORMAL && this.location != WireFace.CENTER) {
            EnumFacing facing2 = this.location.facing;
            BlockPos pos = this.getPos().func_177972_a(facing2);
            IBlockState state = this.getWorld().func_180495_p(pos);
            int power = WireUtils.getRedstoneLevel(this.getWorld(), pos, state, facing2, this.location, false);
            if (power > 0) {
                neighborLevel[facing2.ordinal()] = Math.min(15, power) << 8 | 0xFF;
            }
        }
        if (this.internalConnections > 0) {
            for (EnumFacing location : WireFace.VALUES) {
                if (!this.connectsInternal((WireFace)location)) continue;
                isWire[location.ordinal()] = true;
                neighborLevel[location.ordinal()] = this.getRedstoneLevel(this.getContainer(), (WireFace)location);
            }
        }
        for (EnumFacing facing3 : EnumFacing.field_82609_l) {
            IMultipartContainer container;
            BlockPos pos;
            int facidx = facing3.ordinal();
            if (facing3 == this.location.facing && this.getWireType() == WireType.NORMAL) {
                pos = this.getPos().func_177972_a(facing3);
                int i = 0;
                for (EnumFacing enumfacing : EnumFacing.values()) {
                    IBlockState state;
                    Block block;
                    if (enumfacing == facing3.func_176734_d() || (block = (state = this.getWorld().func_180495_p(pos.func_177972_a(enumfacing))).func_177230_c()) instanceof BlockRedstoneWire) continue;
                    int power = WireUtils.getRedstoneLevel(this.getWorld(), pos.func_177972_a(enumfacing), state, enumfacing, this.location, true);
                    if (power >= 15) {
                        i = 15;
                        break;
                    }
                    if (power <= i) continue;
                    i = power;
                }
                if (i <= 0) continue;
                neighborLevel[facidx] = i << 8 | 0xFF;
                continue;
            }
            if (this.connectsExternal(facing3)) {
                pos = this.getPos().func_177972_a(facing3);
                IMultipartContainer container2 = MultipartHelper.getPartContainer((IBlockAccess)this.getWorld(), (BlockPos)pos);
                if (WireUtils.getWire(container2, this.location) != null) {
                    isWire[facidx] = true;
                    neighborLevel[facidx] = this.getRedstoneLevel(container2, this.location);
                    continue;
                }
                IBlockState state = this.getWorld().func_180495_p(pos);
                int power = WireUtils.getRedstoneLevel(this.getWorld(), pos, state, facing3, this.location, true);
                if (state.func_177230_c() instanceof BlockRedstoneWire) {
                    isWire[facidx] = true;
                    hasRedstoneWire = true;
                    --power;
                }
                if (power <= 0) continue;
                neighborLevel[facidx] = Math.min(power, 15) << 8 | 0xFF;
                continue;
            }
            if (!this.connectsCorner(facing3) || (container = MultipartHelper.getPartContainer((IBlockAccess)this.getWorld(), (BlockPos)this.getPos().func_177972_a(facing3).func_177972_a(this.location.facing))) == null) continue;
            isWire[facidx] = true;
            neighborLevel[facidx] = this.getRedstoneLevel(container, WireFace.get(facing3.func_176734_d()));
        }
        PartWireSignalBase.PROPAGATING = false;
        int maxSignalNonWire = 0;
        for (int i = 0; i < 7; ++i) {
            if (neighborLevel[i] > maxSignal) {
                maxSignal = neighborLevel[i];
            }
            if (isWire[i] || neighborLevel[i] <= maxSignalNonWire) continue;
            maxSignalNonWire = neighborLevel[i];
        }
        if (DEBUG) {
            System.out.println("ConnectionCache: " + Integer.toBinaryString(this.internalConnections) + " " + Integer.toBinaryString(this.externalConnections) + " " + Integer.toBinaryString(this.cornerConnections));
            System.out.println("Levels: " + Arrays.toString(neighborLevel));
        }
        if (maxSignal > this.signalLevel) {
            this.signalLevel = maxSignal - 1;
            if ((this.signalLevel & 0xFF) == 0 || (this.signalLevel & 0xFF) == 255) {
                this.signalLevel = 0;
            }
        } else {
            this.signalLevel = maxSignalNonWire;
        }
        if (oldSignal == this.signalLevel) {
            return;
        }
        if (DEBUG) {
            System.out.println("Switch: " + oldSignal + " -> " + this.signalLevel);
        }
        if (this.signalLevel == 0) {
            for (WireFace nLoc : WireFace.VALUES) {
                TileEntity nt;
                if (this.connectsInternal(nLoc)) {
                    if (neighborLevel[nLoc.ordinal()] <= 0) continue;
                    WireUtils.getWire(this.getContainer(), nLoc).onSignalChanged(this.getColor());
                    continue;
                }
                if (nLoc == WireFace.CENTER) continue;
                facing = nLoc.facing;
                if (this.connectsExternal(facing)) {
                    IMultipartContainer container = MultipartHelper.getPartContainer((IBlockAccess)this.getWorld(), (BlockPos)this.getPos().func_177972_a(facing));
                    if (container != null && WireUtils.getWire(container, this.location) != null && neighborLevel[facing.ordinal()] <= 0) continue;
                    this.propagateNotify(facing, this.getColor());
                    continue;
                }
                if (this.connectsCorner(facing)) {
                    if (neighborLevel[nLoc.ordinal()] <= 0) continue;
                    this.propagateNotifyCorner(this.location.facing, facing, this.getColor());
                    continue;
                }
                if (this.getWireType() != WireType.NORMAL || facing.func_176734_d() == this.location.facing || (nt = this.getWorld().func_175625_s(this.getPos().func_177972_a(facing))) instanceof IRedstoneReceiver) continue;
                this.getWorld().func_180496_d(this.getPos().func_177972_a(facing), (Block)MCMultiPartMod.multipart);
            }
        } else {
            for (WireFace nLoc : WireFace.VALUES) {
                TileEntity nt;
                if (neighborLevel[nLoc.ordinal()] >= this.signalLevel - 1 && neighborLevel[nLoc.ordinal()] <= this.signalLevel + 1) continue;
                if (this.connectsInternal(nLoc)) {
                    WireUtils.getWire(this.getContainer(), nLoc).onSignalChanged(this.getColor());
                    continue;
                }
                if (nLoc == WireFace.CENTER) continue;
                facing = nLoc.facing;
                if (this.connectsExternal(facing)) {
                    this.propagateNotify(facing, this.getColor());
                    continue;
                }
                if (this.connectsCorner(facing)) {
                    this.propagateNotifyCorner(this.location.facing, facing, this.getColor());
                    continue;
                }
                if (this.getWireType() != WireType.NORMAL || facing.func_176734_d() == this.location.facing || (nt = this.getWorld().func_175625_s(this.getPos().func_177972_a(facing))) instanceof IRedstoneReceiver) continue;
                this.getWorld().func_180496_d(this.getPos().func_177972_a(facing), (Block)MCMultiPartMod.multipart);
            }
        }
        if (this.getWireType() == WireType.NORMAL) {
            if ((oldSignal & 0xF00) != (this.signalLevel & 0xF00)) {
                this.scheduleRenderUpdate();
                if (this.location != WireFace.CENTER) {
                    BlockPos uPos = this.getPos().func_177972_a(this.location.facing);
                    this.getWorld().func_175695_a(uPos, (Block)MCMultiPartMod.multipart, this.location.facing.func_176734_d());
                }
            }
        } else if ((oldSignal & 0xF00) != (this.signalLevel & 0xF00) && this.location != WireFace.CENTER) {
            this.getWorld().func_180496_d(this.getPos().func_177972_a(this.location.facing), (Block)MCMultiPartMod.multipart);
        }
        this.finishPropagation();
    }

    @Override
    public int getSignalLevel() {
        return this.signalLevel;
    }

    @Override
    public int getRedstoneLevel() {
        return this.signalLevel >> 8;
    }

    public boolean hasCapability(Capability<?> capability, PartSlot partSlot, EnumFacing face) {
        if (capability == Capabilities.REDSTONE_RECEIVER) {
            return this.connects(face);
        }
        if (capability == Capabilities.REDSTONE_EMITTER) {
            return this.connects(face);
        }
        return false;
    }

    public <T> T getCapability(Capability<T> capability, PartSlot partSlot, EnumFacing enumFacing) {
        if (!this.hasCapability(capability, partSlot, enumFacing)) {
            return null;
        }
        if (capability == Capabilities.REDSTONE_RECEIVER) {
            return (T)this;
        }
        if (capability == Capabilities.REDSTONE_EMITTER) {
            return (T)this;
        }
        return null;
    }

    @Override
    public int getRedstoneSignal() {
        return this.getRedstoneLevel();
    }

    @Override
    public void onRedstoneInputChange() {
        this.scheduleLogicUpdate();
    }
}

