/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.wires.logic;

import mcmultipart.multipart.IMultipart;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import pl.asie.charset.api.wires.WireFace;
import pl.asie.charset.api.wires.WireType;
import pl.asie.charset.lib.wires.PartWire;
import pl.asie.charset.lib.wires.WireFactory;
import pl.asie.charset.wires.WireUtils;
import pl.asie.charset.wires.logic.PartWireBundled;
import pl.asie.charset.wires.logic.PartWireInsulated;
import pl.asie.charset.wires.logic.PartWireNormal;
import pl.asie.charset.wires.logic.PartWireSignalBase;

public class WireSignalFactory
extends WireFactory {
    public final WireType type;
    public final int color;

    public WireSignalFactory(WireType type, int color) {
        this.type = type;
        this.color = color;
    }

    protected PartWire create() {
        PartWire wire = null;
        switch (this.type) {
            case NORMAL: {
                wire = new PartWireNormal();
                break;
            }
            case INSULATED: {
                wire = new PartWireInsulated();
                ((PartWireSignalBase)wire).setColor(this.color);
                break;
            }
            case BUNDLED: {
                wire = new PartWireBundled();
            }
        }
        return wire.setFactory(this);
    }

    public IMultipart createPart(ResourceLocation loc, boolean client) {
        return this.create();
    }

    @Override
    public PartWire createPart(ItemStack stack) {
        return this.create();
    }

    @Override
    public boolean canPlace(IBlockAccess access, BlockPos pos, WireFace face) {
        return face == WireFace.CENTER || WireUtils.canPlaceWire(access, pos.func_177972_a(face.facing), face.facing != null ? face.facing.func_176734_d() : null);
    }

    @Override
    public float getWidth() {
        return (float)WireUtils.width(this.type) / 16.0f;
    }

    @Override
    public float getHeight() {
        return (float)WireUtils.height(this.type) / 16.0f;
    }

    @Override
    public ResourceLocation getTexturePrefix() {
        return new ResourceLocation("charsetwires:blocks/wire_" + this.type.name().toLowerCase());
    }
}

