/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.common.packet.mod;

import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import me.ichun.mods.ichunutil.client.module.patron.PatronEffectRenderer;
import me.ichun.mods.ichunutil.common.core.network.AbstractPacket;
import me.ichun.mods.ichunutil.common.iChunUtil;
import me.ichun.mods.ichunutil.common.module.patron.PatronInfo;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;

public class PacketPatrons
extends AbstractPacket {
    public PatronInfo info;
    public HashSet<PatronInfo> patrons;

    public PacketPatrons() {
    }

    public PacketPatrons(PatronInfo info) {
        this.info = info;
    }

    @Override
    public void writeTo(ByteBuf buf) {
        HashSet patrons = this.info != null ? new HashSet<PatronInfo>(){
            {
                this.add(PacketPatrons.this.info);
            }
        } : iChunUtil.eventHandlerServer.patrons;
        for (PatronInfo info : patrons) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)info.id);
            buf.writeInt(info.effectType);
            buf.writeBoolean(info.showEffect);
        }
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)"##endPacket");
    }

    @Override
    public void readFrom(ByteBuf buf) {
        this.patrons = new HashSet();
        String s = ByteBufUtils.readUTF8String((ByteBuf)buf);
        while (!s.equals("##endPacket")) {
            int type = buf.readInt();
            boolean show = buf.readBoolean();
            this.patrons.add(new PatronInfo(s, type, show));
            s = ByteBufUtils.readUTF8String((ByteBuf)buf);
        }
    }

    @Override
    public AbstractPacket execute(Side side, EntityPlayer player) {
        for (PatronInfo info : this.patrons) {
            PatronEffectRenderer.patrons.remove(info);
            PatronEffectRenderer.patrons.add(info);
        }
        return null;
    }

    @Override
    public Side receivingSide() {
        return Side.CLIENT;
    }
}

