/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.portalgun.client.render;

import java.io.InputStream;
import java.util.Map;
import me.ichun.mods.ichunutil.client.render.RendererHelper;
import me.ichun.mods.ichunutil.client.render.ShaderHelper;
import me.ichun.mods.ichunutil.common.core.util.EntityHelper;
import me.ichun.mods.ichunutil.common.iChunUtil;
import me.ichun.mods.ichunutil.common.item.ItemHandler;
import me.ichun.mods.ichunutil.common.module.worldportals.client.render.WorldPortalRenderer;
import me.ichun.mods.ichunutil.common.module.worldportals.common.portal.EntityTransformationStack;
import me.ichun.mods.ichunutil.common.module.worldportals.common.portal.WorldPortal;
import me.ichun.mods.portalgun.common.PortalGun;
import me.ichun.mods.portalgun.common.portal.world.PortalPlacement;
import me.ichun.mods.portalgun.common.tileentity.TilePortalMaster;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.MinecraftForgeClient;
import org.apache.commons.io.IOUtils;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;

public class TileEntityRendererPortalMaster
extends TileEntitySpecialRenderer<TilePortalMaster> {
    public static final ResourceLocation texPortalOpen = new ResourceLocation("portalgun", "textures/blocks/portalopen.png");
    public static final ResourceLocation texPortalClosed = new ResourceLocation("portalgun", "textures/blocks/portalclose.png");
    public static final ResourceLocation texPortalOutline = new ResourceLocation("portalgun", "textures/blocks/portaloutline.png");
    public static final ResourceLocation texPortalOutlineFancy = new ResourceLocation("portalgun", "textures/blocks/portaloutlinefancy.png");
    private int shader = -1;
    private PortalShaderCallback shaderCallback;

    public void renderTileEntityAt(TilePortalMaster selfTe, double x, double y, double z, float partialTick, int destroyStage) {
        Minecraft mc = Minecraft.func_71410_x();
        int renderPass = MinecraftForgeClient.getRenderPass();
        if (mc.field_71474_y.field_74320_O == 2) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        for (Map.Entry e : selfTe.portals.entrySet()) {
            boolean renderFront;
            PortalPlacement self = (PortalPlacement)((Object)e.getValue());
            if (!self.getPortal().getPos().equals((Object)selfTe.func_174877_v()) || !self.setup) continue;
            boolean bl = renderFront = self.shouldRenderFront(mc.func_175606_aa(), partialTick) || renderPass == 1;
            if (renderPass == 0) {
                NBTTagCompound tag;
                EntityLivingBase living;
                ItemStack is;
                Entity renderer;
                boolean renderOutline = false;
                if (!mc.field_71474_y.field_74319_N && (renderer = mc.func_175606_aa()) instanceof EntityLivingBase && (is = ItemHandler.getUsableDualHandedItem((EntityLivingBase)(living = (EntityLivingBase)renderer))) != null && is.func_77973_b() == PortalGun.itemPortalGun && is.func_77978_p() != null && self.getPortal().uuid.equals((tag = is.func_77978_p()).func_74779_i("uuid")) && self.getPortal().channelName.equals(tag.func_74779_i("channelName"))) {
                    renderOutline = true;
                }
                if (!renderOutline && !renderFront) continue;
                GlStateManager.func_179094_E();
                double offsetX = self.getPosition().field_72450_a - (double)selfTe.func_174877_v().func_177958_n();
                double offsetY = self.getPosition().field_72448_b - (double)selfTe.func_174877_v().func_177956_o();
                double offsetZ = self.getPosition().field_72449_c - (double)selfTe.func_174877_v().func_177952_p();
                GlStateManager.func_179137_b((double)(x + offsetX), (double)(y + offsetY), (double)(z + offsetZ));
                if (renderFront && self.hasPair()) {
                    Entity entity = mc.func_175606_aa();
                    GlStateManager.func_179090_x();
                    GlStateManager.func_179133_A();
                    GlStateManager.func_179140_f();
                    AxisAlignedBB flatPlane = self.getFlatPlane();
                    double centerX = (flatPlane.field_72336_d + flatPlane.field_72340_a) / 2.0;
                    double centerY = (flatPlane.field_72337_e + flatPlane.field_72338_b) / 2.0;
                    double centerZ = (flatPlane.field_72334_f + flatPlane.field_72339_c) / 2.0;
                    PortalPlacement pair = (PortalPlacement)self.getPair();
                    AxisAlignedBB pairFlatPlane = pair.getFlatPlane();
                    double destX = (pairFlatPlane.field_72336_d + pairFlatPlane.field_72340_a) / 2.0;
                    double destY = (pairFlatPlane.field_72337_e + pairFlatPlane.field_72338_b) / 2.0;
                    double destZ = (pairFlatPlane.field_72334_f + pairFlatPlane.field_72339_c) / 2.0;
                    float[] appliedOffset = self.getQuaternionFormula().applyPositionalRotation(new float[]{EntityHelper.interpolateValues((float)((float)mc.func_175606_aa().field_70169_q), (float)((float)mc.func_175606_aa().field_70165_t), (float)partialTick) - (float)centerX, EntityHelper.interpolateValues((float)((float)mc.func_175606_aa().field_70167_r), (float)((float)mc.func_175606_aa().field_70163_u), (float)partialTick) + mc.func_175606_aa().func_70047_e() - (float)centerY, EntityHelper.interpolateValues((float)((float)mc.func_175606_aa().field_70166_s), (float)((float)mc.func_175606_aa().field_70161_v), (float)partialTick) - (float)centerZ});
                    float[] appliedRotation = self.getQuaternionFormula().applyRotationalRotation(new float[]{EntityHelper.interpolateValues((float)mc.func_175606_aa().field_70126_B, (float)mc.func_175606_aa().field_70177_z, (float)partialTick), EntityHelper.interpolateValues((float)mc.func_175606_aa().field_70127_C, (float)mc.func_175606_aa().field_70125_A, (float)partialTick), WorldPortalRenderer.getRollFactor((int)WorldPortalRenderer.renderLevel, (float)partialTick)});
                    EntityTransformationStack ets = new EntityTransformationStack(entity).moveEntity(destX, destY, destZ, new float[]{0.0f, 0.0f, 0.0f}, appliedRotation, partialTick);
                    mc.field_71460_t.func_78466_h(partialTick);
                    ets.reset();
                    GlStateManager.func_179089_o();
                    GlStateManager.func_179131_c((float)mc.field_71460_t.field_175080_Q, (float)mc.field_71460_t.field_175082_R, (float)mc.field_71460_t.field_175081_S, (float)1.0f);
                    self.drawPlane(partialTick);
                    if (PortalGun.config.seeThroughPortals == 1 && RendererHelper.canUseStencils()) {
                        WorldPortalRenderer.renderWorldPortal((Minecraft)mc, (WorldPortal)self, (Entity)entity, (float[])appliedOffset, (float[])appliedRotation, (float)partialTick);
                    }
                    GlStateManager.func_179098_w();
                }
                this.drawPortalBorderAndOutline(self, renderFront, renderOutline, partialTick, renderPass);
                GlStateManager.func_179121_F();
                continue;
            }
            if (renderPass != 1 || !renderFront) continue;
            GlStateManager.func_179094_E();
            double offsetX = self.getPosition().field_72450_a - (double)selfTe.func_174877_v().func_177958_n();
            double offsetY = self.getPosition().field_72448_b - (double)selfTe.func_174877_v().func_177956_o();
            double offsetZ = self.getPosition().field_72449_c - (double)selfTe.func_174877_v().func_177952_p();
            GlStateManager.func_179137_b((double)(x + offsetX), (double)(y + offsetY), (double)(z + offsetZ));
            this.drawPortalBorderAndOutline(self, true, false, partialTick, renderPass);
            GlStateManager.func_179121_F();
        }
        if (mc.field_71474_y.field_74320_O == 2) {
            GlStateManager.func_179121_F();
        }
    }

    public void drawPortalBorderAndOutline(PortalPlacement self, boolean renderFront, boolean renderOutline, float partialTick, int pass) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179133_A();
        GlStateManager.func_179140_f();
        GlStateManager.func_179092_a((int)516, (float)0.005f);
        float r = (float)(self.getPortal().colour >> 16 & 0xFF) / 255.0f;
        float g = (float)(self.getPortal().colour >> 8 & 0xFF) / 255.0f;
        float b = (float)(self.getPortal().colour & 0xFF) / 255.0f;
        GlStateManager.func_179124_c((float)r, (float)g, (float)b);
        float sizeProg = MathHelper.func_76131_a((float)(((float)(self.time - 1) + partialTick) / 5.0f), (float)0.0f, (float)1.0f);
        float scaleX = 1.0f * self.getWidth() * sizeProg;
        float scaleY = 1.0f * self.getHeight() * sizeProg;
        float scaleZ = 0.95f;
        double pushback = -0.49;
        int horiOrient = (self.getFaceOn().func_176740_k() == EnumFacing.Axis.Y ? self.getUpDir() : self.getFaceOn()).func_176734_d().func_176736_b();
        GlStateManager.func_179114_b((float)((self.getFaceOn().func_176745_a() > 0 ? 180.0f : 0.0f) + (float)(-horiOrient) * 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        if (self.getFaceOn().func_176740_k() == EnumFacing.Axis.Y) {
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(self.getFaceOn() == EnumFacing.UP ? -90.0f : 90.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)pushback);
        GlStateManager.func_179152_a((float)scaleX, (float)scaleY, (float)scaleZ);
        if (renderFront && (PortalGun.config.fancyPortals != 1 || !this.drawFrontShader(self, r, g, b, partialTick, pass))) {
            this.func_147499_a(self.hasPair() ? texPortalOpen : texPortalClosed);
            this.drawTextureGradient(r, g, b);
        }
        if (WorldPortalRenderer.renderLevel == 0 && renderOutline) {
            GlStateManager.func_179129_p();
            GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)0.0025);
            this.func_147499_a(PortalGun.config.fancyPortals == 1 ? texPortalOutlineFancy : texPortalOutline);
            if (RendererHelper.canUseStencils()) {
                GL11.glEnable((int)2960);
                GlStateManager.func_179135_a((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                GlStateManager.func_179132_a((boolean)false);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glStencilFunc((int)519, (int)iChunUtil.config.stencilValue, (int)255);
                GL11.glStencilOp((int)7680, (int)7681, (int)7680);
                GL11.glStencilMask((int)255);
                GL11.glClearStencil((int)0);
                GlStateManager.func_179086_m((int)1024);
                GlStateManager.func_179090_x();
                this.drawPlane(1.0);
                GlStateManager.func_179098_w();
                GL11.glStencilMask((int)0);
                GL11.glStencilFunc((int)514, (int)iChunUtil.config.stencilValue, (int)255);
                GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                GlStateManager.func_179124_c((float)r, (float)g, (float)b);
                GlStateManager.func_179132_a((boolean)false);
                GlStateManager.func_179097_i();
                this.drawTextureGradient(r, g, b);
                GlStateManager.func_179126_j();
                GlStateManager.func_179132_a((boolean)true);
                GL11.glDisable((int)2960);
            } else if (!renderFront) {
                GlStateManager.func_179132_a((boolean)false);
                GlStateManager.func_179097_i();
                this.drawTextureGradient(r, g, b);
                GlStateManager.func_179126_j();
                GlStateManager.func_179132_a((boolean)true);
            }
            GlStateManager.func_179089_o();
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179145_e();
        GlStateManager.func_179108_z();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    private boolean drawFrontShader(PortalPlacement self, float r, float g, float b, float partialTick, int pass) {
        boolean shadersSupported = ShaderHelper.supportsShaders();
        if (shadersSupported && this.shader < 0) {
            if (this.shader == -1) {
                try {
                    InputStream stream = PortalGun.class.getResourceAsStream("/assets/portalgun/shaders/portal.fsh");
                    String shaderString = IOUtils.toString((InputStream)stream, (String)"UTF-8");
                    stream.close();
                    this.shader = ShaderHelper.createProgram(null, (String)shaderString);
                    this.shaderCallback = new PortalShaderCallback();
                    this.shaderCallback.init(this.shader);
                    if (this.shader == -1) {
                        this.shader = -2;
                        shadersSupported = false;
                    }
                }
                catch (Exception e) {
                    shadersSupported = false;
                }
            } else {
                shadersSupported = false;
            }
        }
        if (shadersSupported) {
            this.shaderCallback.set(((float)(self.time + self.getPos().func_177958_n() + self.getPos().func_177956_o() + self.getPos().func_177952_p() + self.getFaceOn().func_176745_a()) + iChunUtil.eventHandlerClient.renderTick) / 20.0f % 3600.0f, r, g, b, self.hasPair() ? MathHelper.func_76131_a((float)(1.0f - ((float)self.pairTime + partialTick) / 5.0f), (float)0.0f, (float)1.0f) : 1.0f, pass);
            if (pass == 1) {
                GlStateManager.func_179129_p();
            }
            ShaderHelper.useShader((int)this.shader, (ShaderHelper.IShaderCallback)this.shaderCallback);
            this.drawPlane(2.45);
            ShaderHelper.releaseShader();
            if (pass == 1) {
                GlStateManager.func_179089_o();
            }
        }
        return shadersSupported;
    }

    public void drawPlane(double mult) {
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexbuffer.func_181662_b(-0.5 * mult, -0.5 * mult, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        vertexbuffer.func_181662_b(0.5 * mult, -0.5 * mult, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        vertexbuffer.func_181662_b(0.5 * mult, 0.5 * mult, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        vertexbuffer.func_181662_b(-0.5 * mult, 0.5 * mult, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        tessellator.func_78381_a();
    }

    public void drawTextureGradient(float r, float g, float b) {
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        float brightness = 1.6f;
        float r1 = MathHelper.func_76131_a((float)(r * brightness), (float)0.0f, (float)1.0f);
        float g1 = MathHelper.func_76131_a((float)(g * brightness), (float)0.0f, (float)1.0f);
        float b1 = MathHelper.func_76131_a((float)(b * brightness), (float)0.0f, (float)1.0f);
        vertexbuffer.func_181662_b(-0.5, -0.5, 0.0).func_187315_a(0.0, 0.0).func_181666_a(r1, g1, b1, 1.0f).func_181675_d();
        vertexbuffer.func_181662_b(0.5, -0.5, 0.0).func_187315_a(1.0, 0.0).func_181666_a(r1, g1, b1, 1.0f).func_181675_d();
        vertexbuffer.func_181662_b(0.5, 0.5, 0.0).func_187315_a(1.0, 1.0).func_181666_a(r, g, b, 1.0f).func_181675_d();
        vertexbuffer.func_181662_b(-0.5, 0.5, 0.0).func_187315_a(0.0, 1.0).func_181666_a(r, g, b, 1.0f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
    }

    private class PortalShaderCallback
    implements ShaderHelper.IShaderCallback {
        private int indexCloseAlpha = -1;
        private int indexColorR = -1;
        private int indexColorG = -1;
        private int indexColorB = -1;
        private int indexTime = -1;
        private int indexPass = -1;
        private float time = 0.0f;
        private float r = 1.0f;
        private float g = 1.0f;
        private float b = 1.0f;
        private float closeAlpha = 1.0f;
        private int pass = 0;

        private PortalShaderCallback() {
        }

        private void set(float time, float r, float g, float b, float closeAlpha, int pass) {
            this.time = time;
            this.r = r;
            this.g = g;
            this.b = b;
            this.closeAlpha = closeAlpha;
            this.pass = pass;
        }

        public void init(int shader) {
            this.indexCloseAlpha = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"closeAlpha");
            this.indexColorR = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"theColorR");
            this.indexColorG = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"theColorG");
            this.indexColorB = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"theColorB");
            this.indexTime = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"time");
            this.indexPass = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"pass");
        }

        public void call(int shader, boolean newFrame) {
            GL20.glUniform1f((int)this.indexCloseAlpha, (float)this.closeAlpha);
            GL20.glUniform1f((int)this.indexColorR, (float)this.r);
            GL20.glUniform1f((int)this.indexColorG, (float)this.g);
            GL20.glUniform1f((int)this.indexColorB, (float)this.b);
            GL20.glUniform1f((int)this.indexTime, (float)this.time);
            GL20.glUniform1i((int)this.indexPass, (int)this.pass);
        }
    }
}

