/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.portalgun.common.block;

import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import me.ichun.mods.portalgun.common.portal.world.PortalPlacement;
import me.ichun.mods.portalgun.common.tileentity.TilePortalBase;
import me.ichun.mods.portalgun.common.tileentity.TilePortalMaster;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockPortal
extends BlockContainer {
    public static final PropertyBool MASTER = PropertyBool.func_177716_a((String)"master");
    public static final AxisAlignedBB AABB = new AxisAlignedBB(0.5, 0.5, 0.5, 0.5, 0.5, 0.5);

    public BlockPortal() {
        super(Material.field_151594_q);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)MASTER, (Comparable)Boolean.valueOf(false)));
    }

    public TileEntity func_149915_a(World world, int meta) {
        if (meta == 1) {
            return new TilePortalMaster();
        }
        return new TilePortalBase();
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{MASTER});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)MASTER, (Comparable)Boolean.valueOf(meta == 1));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)MASTER) != false ? 1 : 0;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149703_v() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, World world, BlockPos pos) {
        return AABB.func_186670_a(pos);
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB mask, List<AxisAlignedBB> list, Entity collidingEntity) {
        if (collidingEntity == null) {
            return;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TilePortalBase) {
            TilePortalBase portalBase = (TilePortalBase)te;
            for (Map.Entry<EnumFacing, PortalPlacement> e : portalBase.portals.entrySet()) {
                AxisAlignedBB plane;
                PortalPlacement placement = e.getValue();
                if (!placement.hasPair() || !placement.setup || placement.destroyed || !(plane = placement.scanRange).func_72326_a(mask)) continue;
                list.addAll(placement.getCollisionBoundaries().stream().filter(arg_0 -> ((AxisAlignedBB)mask).func_72326_a(arg_0)).collect(Collectors.toList()));
            }
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity te;
        if (!world.field_72995_K && (te = world.func_175625_s(pos)) instanceof TilePortalBase) {
            ((TilePortalBase)te).onBlockRemoval();
        }
        super.func_180663_b(world, pos, state);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighborBlock) {
        TileEntity te;
        if (!world.field_72995_K && (te = world.func_175625_s(pos)) instanceof TilePortalBase) {
            ((TilePortalBase)te).checkValidity();
        }
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
    }

    public boolean func_149659_a(Explosion explosionIn) {
        return false;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return super.getLightValue(state, world, pos);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return null;
    }
}

