/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.portalgun.common.core;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import me.ichun.mods.portalgun.common.PortalGun;
import me.ichun.mods.portalgun.common.entity.EntityPortalProjectile;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.event.entity.EntityEvent;

public class ChunkLoadHandler
implements ForgeChunkManager.LoadingCallback {
    public static LinkedHashMap<EntityPortalProjectile, ForgeChunkManager.Ticket> entToTicketMap = new LinkedHashMap();

    public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
        if (PortalGun.config.canPortalProjectilesChunkload == 1) {
            for (ForgeChunkManager.Ticket ticket : tickets) {
                if (ticket.getEntity() instanceof EntityPortalProjectile) {
                    EntityPortalProjectile epp = (EntityPortalProjectile)ticket.getEntity();
                    ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)new ChunkPos(epp.func_180425_c()));
                    entToTicketMap.put(epp, ticket);
                    while (entToTicketMap.size() > 20) {
                        Iterator<Map.Entry<EntityPortalProjectile, ForgeChunkManager.Ticket>> ite = entToTicketMap.entrySet().iterator();
                        if (!ite.hasNext()) continue;
                        ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ite.next().getValue());
                        ite.remove();
                    }
                    continue;
                }
                ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
            }
        }
    }

    public static void checkAndCreateTicket(EntityEvent.EnteringChunk event) {
        if (!event.getEntity().field_70170_p.field_72995_K && event.getEntity() instanceof EntityPortalProjectile && !event.getEntity().field_70128_L) {
            EntityPortalProjectile epp = (EntityPortalProjectile)event.getEntity();
            ForgeChunkManager.Ticket ticket = entToTicketMap.get((Object)epp);
            if (ticket == null && (ticket = ForgeChunkManager.requestTicket((Object)PortalGun.instance, (World)epp.field_70170_p, (ForgeChunkManager.Type)ForgeChunkManager.Type.ENTITY)) != null) {
                ticket.bindEntity((Entity)epp);
                entToTicketMap.put(epp, ticket);
            }
            if (ticket != null) {
                if (event.getOldChunkX() != 0 && event.getOldChunkZ() != 0) {
                    ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)new ChunkPos(event.getOldChunkX(), event.getOldChunkZ()));
                }
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)new ChunkPos(event.getNewChunkX(), event.getNewChunkZ()));
            }
        }
    }

    public static void removeTicket(EntityPortalProjectile epp) {
        if (PortalGun.config.canPortalProjectilesChunkload == 1) {
            ForgeChunkManager.Ticket ticket = entToTicketMap.get((Object)epp);
            if (ticket != null) {
                ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
            }
            entToTicketMap.remove((Object)epp);
        }
    }
}

