/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.portalgun.common.packet;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.stream.Collectors;
import me.ichun.mods.ichunutil.common.core.network.AbstractPacket;
import me.ichun.mods.ichunutil.common.grab.GrabHandler;
import me.ichun.mods.ichunutil.common.iChunUtil;
import me.ichun.mods.ichunutil.common.item.ItemHandler;
import me.ichun.mods.portalgun.common.PortalGun;
import me.ichun.mods.portalgun.common.portal.PortalGunGrabHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketGrabEvent
extends AbstractPacket {
    public String ident;
    public int grabberId;
    public int grabbedId;
    public float dist;
    public boolean grabbed;

    public PacketGrabEvent() {
    }

    public PacketGrabEvent(String identifier, int grabberId, int grabbedId, float grabDistance, boolean grabbing) {
        this.ident = identifier;
        this.grabberId = grabberId;
        this.grabbedId = grabbedId;
        this.dist = grabDistance;
        this.grabbed = grabbing;
    }

    public void writeTo(ByteBuf buffer) {
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.ident);
        buffer.writeInt(this.grabberId);
        buffer.writeInt(this.grabbedId);
        buffer.writeFloat(this.dist);
        buffer.writeBoolean(this.grabbed);
    }

    public void readFrom(ByteBuf buffer) {
        this.ident = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.grabberId = buffer.readInt();
        this.grabbedId = buffer.readInt();
        this.dist = buffer.readFloat();
        this.grabbed = buffer.readBoolean();
    }

    public AbstractPacket execute(Side side, EntityPlayer player) {
        this.handleClient();
        return null;
    }

    public Side receivingSide() {
        return Side.CLIENT;
    }

    @SideOnly(value=Side.CLIENT)
    public void handleClient() {
        block5: {
            ArrayList handlers;
            ArrayList grabbedEntities;
            block4: {
                grabbedEntities = (ArrayList)GrabHandler.grabbedEntities.get(Side.CLIENT);
                handlers = grabbedEntities.stream().filter(handler -> handler instanceof PortalGunGrabHandler).map(handler -> (PortalGunGrabHandler)((Object)handler)).collect(Collectors.toCollection(ArrayList::new));
                if (!this.grabbed) break block4;
                boolean has = false;
                for (PortalGunGrabHandler handler2 : handlers) {
                    if (!handler2.identifier.equals(this.ident)) continue;
                    has = true;
                    if (handler2.grabberId != this.grabberId || handler2.grabbedId != this.grabbedId) {
                        handler2.grabber = null;
                        handler2.grabbed = null;
                        handler2.grabberId = this.grabberId;
                        handler2.grabbedId = this.grabbedId;
                        handler2.getIDs();
                    }
                    handler2.grabDistance = this.dist;
                    break;
                }
                if (has) break block5;
                PortalGunGrabHandler handler3 = new PortalGunGrabHandler(this.ident, this.grabberId, this.grabbedId, this.dist);
                grabbedEntities.add(handler3);
                handler3.getIDs();
                ItemStack is = ItemHandler.getUsableDualHandedItem((EntityLivingBase)Minecraft.func_71410_x().field_71439_g);
                if (this.grabberId == Minecraft.func_71410_x().field_71439_g.func_145782_y() && is != null && is.func_77973_b() == PortalGun.itemPortalGun) {
                    iChunUtil.proxy.nudgeHand(15.0f);
                }
                break block5;
            }
            for (PortalGunGrabHandler handler4 : handlers) {
                if (!handler4.identifier.equals(this.ident)) continue;
                grabbedEntities.remove((Object)handler4);
                handler4.terminate();
                ItemStack is = ItemHandler.getUsableDualHandedItem((EntityLivingBase)Minecraft.func_71410_x().field_71439_g);
                if (this.grabberId != Minecraft.func_71410_x().field_71439_g.func_145782_y() || is == null || is.func_77973_b() != PortalGun.itemPortalGun) break;
                iChunUtil.proxy.nudgeHand(15.0f);
                break;
            }
        }
    }
}

