/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.portalgun.common.packet;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashSet;
import me.ichun.mods.ichunutil.common.core.network.AbstractPacket;
import me.ichun.mods.ichunutil.common.core.util.EntityHelper;
import me.ichun.mods.ichunutil.common.grab.GrabHandler;
import me.ichun.mods.ichunutil.common.item.ItemHandler;
import me.ichun.mods.portalgun.common.PortalGun;
import me.ichun.mods.portalgun.common.core.SoundIndex;
import me.ichun.mods.portalgun.common.item.ItemPortalGun;
import me.ichun.mods.portalgun.common.portal.PortalGunGrabHandler;
import me.ichun.mods.portalgun.common.portal.PortalGunHelper;
import me.ichun.mods.portalgun.common.portal.info.PortalInfo;
import me.ichun.mods.portalgun.common.portal.world.PortalPlacement;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;

public class PacketKeyEvent
extends AbstractPacket {
    public int event;

    public PacketKeyEvent() {
    }

    public PacketKeyEvent(int event) {
        this.event = event;
    }

    public void writeTo(ByteBuf buf) {
        buf.writeInt(this.event);
    }

    public void readFrom(ByteBuf buf) {
        this.event = buf.readInt();
    }

    public AbstractPacket execute(Side side, EntityPlayer player) {
        ItemStack is = ItemHandler.getUsableDualHandedItem((EntityLivingBase)player);
        boolean isHoldingPortalGun = is != null && is.func_77973_b() == PortalGun.itemPortalGun;
        switch (this.event) {
            case 0: 
            case 1: 
            case 2: {
                if (!isHoldingPortalGun) break;
                NBTTagCompound tag = is.func_77978_p();
                if (tag == null) {
                    ItemPortalGun.setRandomNBTTags(is, player);
                    tag = is.func_77978_p();
                }
                if (tag == null) break;
                HashSet<PortalInfo> infos = PortalGun.eventHandlerServer.getWorldSaveData((int)player.field_70170_p.field_73011_w.getDimension()).portalList;
                ArrayList<PortalInfo> infoToRemove = new ArrayList<PortalInfo>();
                for (PortalInfo info : infos) {
                    if (!info.uuid.equals(tag.func_74779_i("uuid")) || !info.channelName.equals(tag.func_74779_i("channelName")) || this.event != 0 && (this.event != 1 || !info.isTypeA) && (this.event != 2 || info.isTypeA)) continue;
                    infoToRemove.add(info);
                }
                for (PortalInfo info : infoToRemove) {
                    PortalPlacement placement = info.getPortalPlacement(player.field_70170_p);
                    if (placement == null) continue;
                    placement.remove(BlockPos.field_177992_a);
                }
                EntityHelper.playSoundAtEntity((Entity)player, (SoundEvent)SoundIndex.pg_wpn_portal_fizzler_shimmy, (SoundCategory)player.func_184176_by(), (float)0.2f, (float)1.0f);
                break;
            }
            case 3: 
            case 4: {
                if (!isHoldingPortalGun) break;
                if (GrabHandler.hasHandlerType((EntityLivingBase)player, (Side)Side.SERVER, PortalGunGrabHandler.class)) {
                    PortalGunHelper.tryGrab((EntityLivingBase)player);
                    break;
                }
                PortalGunHelper.shootPortal((EntityLivingBase)player, is, this.event == 3);
                break;
            }
            case 5: {
                if (PortalGunHelper.tryGrab((EntityLivingBase)player) || !isHoldingPortalGun) break;
                EntityHelper.playSoundAtEntity((Entity)player, (SoundEvent)SoundIndex.pg_object_use_failure, (SoundCategory)player.func_184176_by(), (float)0.2f, (float)1.0f);
            }
        }
        return null;
    }

    public Side receivingSide() {
        return Side.SERVER;
    }
}

