/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.portalgun.common.packet;

import io.netty.buffer.ByteBuf;
import me.ichun.mods.ichunutil.common.core.network.AbstractPacket;
import me.ichun.mods.portalgun.common.PortalGun;
import me.ichun.mods.portalgun.common.portal.info.ChannelIndicator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;

public class PacketPortalChannelIndicator
extends AbstractPacket {
    public String uuid;
    public String channelName;
    public int dimension;
    public int portalAColour;
    public boolean portalAAvailable;
    public int portalBColour;
    public boolean portalBAvailable;

    public PacketPortalChannelIndicator() {
    }

    public PacketPortalChannelIndicator(String uuid, String channelName, int dimension, int portalAColour, boolean portalAAvailable, int portalBColour, boolean portalBAvailable) {
        this.uuid = uuid;
        this.channelName = channelName;
        this.dimension = dimension;
        this.portalAColour = portalAColour;
        this.portalAAvailable = portalAAvailable;
        this.portalBColour = portalBColour;
        this.portalBAvailable = portalBAvailable;
    }

    public void writeTo(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.uuid);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.channelName);
        buf.writeInt(this.dimension);
        buf.writeInt(this.portalAColour);
        buf.writeBoolean(this.portalAAvailable);
        buf.writeInt(this.portalBColour);
        buf.writeBoolean(this.portalBAvailable);
    }

    public void readFrom(ByteBuf buf) {
        this.uuid = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.channelName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.dimension = buf.readInt();
        this.portalAColour = buf.readInt();
        this.portalAAvailable = buf.readBoolean();
        this.portalBColour = buf.readInt();
        this.portalBAvailable = buf.readBoolean();
    }

    public AbstractPacket execute(Side side, EntityPlayer player) {
        ChannelIndicator indicator = PortalGun.eventHandlerClient.getPortalChannelIndicator(this.uuid, this.channelName, this.dimension);
        indicator.info.setColour(this.portalAColour, this.portalBColour);
        indicator.setPortalAStatus(this.portalAAvailable).setPortalBStatus(this.portalBAvailable);
        PortalGun.eventHandlerClient.requestedChannels.remove(indicator);
        return null;
    }

    public Side receivingSide() {
        return Side.CLIENT;
    }
}

