/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.portalgun.common.portal;

import java.awt.Color;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import me.ichun.mods.ichunutil.common.core.network.AbstractPacket;
import me.ichun.mods.ichunutil.common.core.util.EntityHelper;
import me.ichun.mods.ichunutil.common.entity.EntityBlock;
import me.ichun.mods.ichunutil.common.grab.GrabHandler;
import me.ichun.mods.ichunutil.common.item.ItemHandler;
import me.ichun.mods.portalgun.common.PortalGun;
import me.ichun.mods.portalgun.common.core.SoundIndex;
import me.ichun.mods.portalgun.common.entity.EntityPortalProjectile;
import me.ichun.mods.portalgun.common.item.ItemPortalGun;
import me.ichun.mods.portalgun.common.packet.PacketGrabEvent;
import me.ichun.mods.portalgun.common.portal.PortalGunGrabHandler;
import me.ichun.mods.portalgun.common.portal.info.ChannelInfo;
import me.ichun.mods.portalgun.common.portal.info.PortalInfo;
import me.ichun.mods.portalgun.common.portal.world.PortalPlacement;
import me.ichun.mods.portalgun.common.portal.world.PortalsInWorldSavedData;
import me.ichun.mods.portalgun.common.tileentity.TilePortalBase;
import me.ichun.mods.portalgun.common.tileentity.TilePortalMaster;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraftforge.fml.relauncher.Side;

public class PortalGunHelper {
    public static void shootPortal(EntityLivingBase living, ItemStack is, boolean isTypeA) {
        NBTTagCompound tag = is.func_77978_p();
        if (tag == null && living instanceof EntityPlayer) {
            ItemPortalGun.setRandomNBTTags(is, (EntityPlayer)living);
            tag = is.func_77978_p();
        }
        if (tag != null) {
            ChannelInfo channel = PortalGun.eventHandlerServer.lookupChannel(tag.func_74779_i("uuid"), tag.func_74779_i("channelName"));
            PortalInfo info = new PortalInfo().setInfo(tag.func_74779_i("uuid"), tag.func_74779_i("channelName"), isTypeA).setColour(isTypeA ? channel.colourA : channel.colourB);
            living.field_70170_p.func_72838_d((Entity)new EntityPortalProjectile(living.field_70170_p, (Entity)living, tag.func_74762_e("width"), tag.func_74762_e("height"), info, PortalGun.config.maxShootDistance));
            EntityHelper.playSoundAtEntity((Entity)living, (SoundEvent)(isTypeA ? SoundIndex.pg_wpn_portal_gun_fire_blue : SoundIndex.pg_wpn_portal_gun_fire_red), (SoundCategory)living.func_184176_by(), (float)0.2f, (float)(1.0f + (living.func_70681_au().nextFloat() - living.func_70681_au().nextFloat()) * 0.1f));
        }
    }

    public static boolean tryGrab(EntityLivingBase living) {
        boolean isHoldingPortalGun;
        ItemStack currentItem = ItemHandler.getUsableDualHandedItem((EntityLivingBase)living);
        boolean bl = isHoldingPortalGun = currentItem != null && currentItem.func_77973_b() == PortalGun.itemPortalGun;
        if (GrabHandler.hasHandlerType((EntityLivingBase)living, (Side)Side.SERVER, null)) {
            GrabHandler.release((EntityLivingBase)living, (Side)Side.SERVER, null);
            return true;
        }
        int strength = 1;
        if (isHoldingPortalGun) {
            strength = PortalGunHelper.getGrabStrength(currentItem, living);
        }
        RayTraceResult mop = EntityHelper.getEntityLook((Entity)living, (double)5.0);
        Entity grabbedEnt = null;
        if (mop.field_72313_a == RayTraceResult.Type.ENTITY && PortalGunHelper.canEntityBeGrabbed(strength, mop.field_72308_g, isHoldingPortalGun)) {
            grabbedEnt = mop.field_72308_g;
        } else if (mop.field_72313_a == RayTraceResult.Type.BLOCK && strength > 1) {
            final BlockPos pos = mop.func_178782_a();
            IBlockState state = living.field_70170_p.func_180495_p(pos);
            Block block = state.func_177230_c();
            if (state.func_185887_b(living.field_70170_p, pos) < 0.0f) {
                return false;
            }
            if (block.hasTileEntity(state) && strength < 3 || !block.isNormalCube(state, (IBlockAccess)living.field_70170_p, pos) && !PortalGunHelper.isGrabableBlockType(state, block)) {
                return false;
            }
            grabbedEnt = EntityBlock.createEntityBlock((World)living.field_70170_p, (EntityLivingBase)living, (Set)new HashSet<BlockPos>(){
                {
                    this.add(pos);
                }
            });
            if (grabbedEnt != null) {
                living.field_70170_p.func_72838_d(grabbedEnt);
            }
        }
        if (grabbedEnt != null) {
            ArrayList handlers = (ArrayList)GrabHandler.grabbedEntities.get(Side.SERVER);
            for (GrabHandler handler : handlers) {
                if (handler.grabbed != grabbedEnt) continue;
                handler.terminate();
                handlers.remove(handler);
            }
            float dist = 3.5f;
            float width = grabbedEnt.field_70130_N;
            if ((double)width > 2.0) {
                dist = MathHelper.func_76131_a((float)(dist + width - 2.0f), (float)3.5f, (float)6.0f);
            }
            PortalGunGrabHandler handler = new PortalGunGrabHandler(living, grabbedEnt, dist);
            GrabHandler.grab((GrabHandler)handler, (Side)Side.SERVER);
            PortalGun.channel.sendToAll((AbstractPacket)new PacketGrabEvent(handler.identifier, handler.grabberId, handler.grabbedId, handler.grabDistance, true));
            return true;
        }
        return false;
    }

    private static boolean canEntityBeGrabbed(int strength, Entity ent, boolean isHoldingPortalGun) {
        if (!isHoldingPortalGun) {
            return false;
        }
        if (ent instanceof EntityPlayer) {
            return false;
        }
        int weight = PortalGun.config.entityGrabWeightBase;
        double totalStrength = (double)((float)weight / 100.0f) * (strength == 1 ? 1.0 : (strength == 2 ? 1.5 : (strength == 3 ? 2.25 : 3.0)));
        double volume = Math.pow(ent.field_70131_O * ent.field_70130_N * ent.field_70130_N, 0.3333333333333333);
        return volume < totalStrength;
    }

    private static int getGrabStrength(ItemStack is, EntityLivingBase living) {
        NBTTagCompound tag = is.func_77978_p();
        if (tag == null && living instanceof EntityPlayer) {
            ItemPortalGun.setRandomNBTTags(is, (EntityPlayer)living);
            tag = is.func_77978_p();
        }
        if (tag != null) {
            return MathHelper.func_76125_a((int)tag.func_74762_e("grabStrength"), (int)1, (int)4);
        }
        return 1;
    }

    private static boolean isGrabableBlockType(IBlockState state, Block block) {
        return state.func_185901_i() == EnumBlockRenderType.ENTITYBLOCK_ANIMATED || state.func_185904_a() == Material.field_151592_s || block == Blocks.field_150426_aN || block == Blocks.field_150414_aQ || block == Blocks.field_150335_W || block == Blocks.field_150432_aD || block instanceof BlockSlab || block == Blocks.field_150467_bQ || block instanceof BlockStairs;
    }

    public static PortalsInWorldSavedData getSaveDataForWorld(World world) {
        PortalsInWorldSavedData savedData = (PortalsInWorldSavedData)world.func_72943_a(PortalsInWorldSavedData.class, "PortalGunPortalData");
        if (savedData == null) {
            savedData = new PortalsInWorldSavedData();
            world.func_72823_a("PortalGunPortalData", (WorldSavedData)savedData);
            if (world.field_73011_w.getDimension() == 0) {
                ArrayList<ChannelInfo> list = new ArrayList<ChannelInfo>();
                list.add(new ChannelInfo("Global", "Chell").setColour(361215, 16756742));
                list.add(new ChannelInfo("Global", "Atlas").setColour(5482192, 4064209));
                list.add(new ChannelInfo("Global", "P-body").setColour(16373344, 8394260));
                savedData.channelList.put("Global", list);
            }
        }
        savedData.initialize(world);
        PortalGun.eventHandlerServer.portalInfoByDimension.put(world.field_73011_w.getDimension(), savedData);
        return savedData;
    }

    public static boolean spawnPortal(World world, BlockPos blockHitPos, EnumFacing sideHit, EnumFacing upDir, PortalInfo portal, int portalWidth, int portalHeight, boolean variableSize) {
        for (int height = portalHeight; height >= 2; --height) {
            for (int width = portalWidth; width >= 1; --width) {
                BlockPos[] portalPos = PortalGunHelper.canPlacePortal(world, blockHitPos, sideHit, upDir, portal, width, height);
                if (portalPos != null) {
                    portal.setPos(portalPos[0]);
                    TileEntity te = world.func_175625_s(portal.getPos());
                    if (te instanceof TilePortalMaster) {
                        TilePortalMaster pm = (TilePortalMaster)te;
                        PortalPlacement placedPortal = (PortalPlacement)((Object)pm.portals.get(sideHit));
                        if (placedPortal != null && placedPortal.getPortal().equals(portal) && placedPortal.getWidth() == (float)width && placedPortal.getHeight() == (float)height && placedPortal.getFaceOn().equals((Object)sideHit) && (placedPortal.getFaceOn() != EnumFacing.UP && placedPortal.getFaceOn() != EnumFacing.DOWN || placedPortal.getUpDir() == upDir)) {
                            placedPortal.time = 0;
                            IBlockState state = world.func_180495_p(portal.getPos());
                            world.func_184138_a(portal.getPos(), state, state, 3);
                            world.func_184148_a(null, placedPortal.getPosition().field_72450_a, placedPortal.getPosition().field_72448_b, placedPortal.getPosition().field_72449_c, SoundIndex.p_portal_fizzle, SoundCategory.BLOCKS, 0.4f, 1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.1f);
                            return true;
                        }
                    }
                    PortalGun.eventHandlerServer.getWorldSaveData(world.field_73011_w.getDimension()).removePortal(world, portal);
                    EnumMap<EnumFacing, Object> portals = new EnumMap(EnumFacing.class);
                    te = world.func_175625_s(portal.getPos());
                    if (te instanceof TilePortalBase) {
                        portals = ((TilePortalBase)te).portals;
                    }
                    world.func_180501_a(portal.getPos(), PortalGun.blockPortal.func_176203_a(1), 2);
                    te = world.func_175625_s(portal.getPos());
                    if (!(te instanceof TilePortalMaster)) continue;
                    TilePortalMaster pm = (TilePortalMaster)te;
                    pm.portals = portals;
                    PortalPlacement newPortal = new PortalPlacement(world, PortalGunHelper.getCentralPosition(portalPos), sideHit, upDir, width, height, portal, portalPos);
                    pm.addPortal(newPortal);
                    if (newPortal.create()) {
                        return true;
                    }
                    newPortal.remove(portal.getPos());
                    pm.removePortal(newPortal);
                    continue;
                }
                if (variableSize) continue;
                return false;
            }
        }
        return false;
    }

    public static Vec3d getCentralPosition(BlockPos[] poses) {
        int[][] boundaries = new int[2][3];
        int lowX = Integer.MAX_VALUE;
        int lowY = Integer.MAX_VALUE;
        int lowZ = Integer.MAX_VALUE;
        int highX = Integer.MIN_VALUE;
        int highY = Integer.MIN_VALUE;
        int highZ = Integer.MIN_VALUE;
        for (BlockPos pos : poses) {
            if (pos.func_177958_n() < lowX) {
                lowX = pos.func_177958_n();
            }
            if (pos.func_177956_o() < lowY) {
                lowY = pos.func_177956_o();
            }
            if (pos.func_177952_p() < lowZ) {
                lowZ = pos.func_177952_p();
            }
            if (pos.func_177958_n() > highX) {
                highX = pos.func_177958_n();
            }
            if (pos.func_177956_o() > highY) {
                highY = pos.func_177956_o();
            }
            if (pos.func_177952_p() <= highZ) continue;
            highZ = pos.func_177952_p();
        }
        boundaries[0][0] = lowX;
        boundaries[0][1] = lowY;
        boundaries[0][2] = lowZ;
        boundaries[1][0] = highX + 1;
        boundaries[1][1] = highY + 1;
        boundaries[1][2] = highZ + 1;
        double centerX = (double)(boundaries[0][0] + boundaries[1][0]) / 2.0;
        double centerY = (double)(boundaries[0][1] + boundaries[1][1]) / 2.0;
        double centerZ = (double)(boundaries[0][2] + boundaries[1][2]) / 2.0;
        return new Vec3d(centerX, centerY, centerZ);
    }

    /*
     * Unable to fully structure code
     */
    public static BlockPos[] canPlacePortal(World world, BlockPos blockPlacementPos, EnumFacing sideHit, EnumFacing lookEF, PortalInfo portalInfo, int portalWidth, int portalHeight) {
        checkedPositions = new HashMap<BlockPos, Boolean>();
        for (i = -portalWidth + 1; i < portalWidth; ++i) {
            for (k = -portalHeight + 1; k < portalHeight; ++k) {
                offsetX = 0;
                offsetY = 0;
                offsetZ = 0;
                block0 : switch (2.$SwitchMap$net$minecraft$util$EnumFacing[sideHit.ordinal()]) {
                    case 5: 
                    case 6: {
                        switch (2.$SwitchMap$net$minecraft$util$EnumFacing[lookEF.ordinal()]) {
                            case 1: 
                            case 2: {
                                offsetX = i;
                                offsetZ = k;
                                break block0;
                            }
                            case 3: 
                            case 4: {
                                offsetX = k;
                                offsetZ = i;
                                break block0;
                            }
                        }
                        break;
                    }
                    case 1: 
                    case 2: {
                        offsetX = i;
                        offsetY = k;
                        break;
                    }
                    case 3: 
                    case 4: {
                        offsetZ = i;
                        offsetY = k;
                    }
                }
                offsetPos = blockPlacementPos.func_177982_a(offsetX, offsetY, offsetZ);
                checkedPositions.put(offsetPos, null);
            }
        }
        order = new ArrayList<Integer>();
        for (i = 0; i < Math.max(portalWidth, portalHeight); ++i) {
            order.add(i);
        }
        firstTry = (int)Math.floor((double)Math.max(portalWidth, portalHeight) / 2.0);
        order.remove(new Integer(firstTry));
        order.add(0, firstTry);
        for (Integer radius : order) {
            for (i = radius.intValue(); i >= 0; --i) {
                for (k = radius.intValue(); k >= 0; --k) {
                    validPositions = new ArrayList<BlockPos>();
                    for (l = -portalWidth + 1; l <= 0; ++l) {
                        for (m = -portalHeight + 1; m <= 0; ++m) {
                            checkX = 0;
                            checkY = 0;
                            checkZ = 0;
                            offsetX = 0;
                            offsetY = 0;
                            offsetZ = 0;
                            switch (2.$SwitchMap$net$minecraft$util$EnumFacing[sideHit.ordinal()]) {
                                case 5: 
                                case 6: {
                                    switch (2.$SwitchMap$net$minecraft$util$EnumFacing[lookEF.ordinal()]) {
                                        case 1: {
                                            checkX = l;
                                            checkZ = m;
                                            offsetX = i;
                                            offsetZ = k;
                                            break;
                                        }
                                        case 2: {
                                            checkX = l;
                                            checkZ = -m;
                                            offsetX = i;
                                            offsetZ = -k;
                                            break;
                                        }
                                        case 3: {
                                            checkX = -m;
                                            checkZ = l;
                                            offsetX = -k;
                                            offsetZ = i;
                                            break;
                                        }
                                        case 4: {
                                            checkX = m;
                                            checkZ = l;
                                            offsetX = k;
                                            offsetZ = i;
                                        }
                                    }
                                    break;
                                }
                                case 1: 
                                case 2: {
                                    checkX = l;
                                    checkY = -m;
                                    offsetX = i;
                                    offsetY = -k;
                                    break;
                                }
                                case 3: 
                                case 4: {
                                    checkZ = l;
                                    checkY = -m;
                                    offsetZ = i;
                                    offsetY = -k;
                                }
                            }
                            checkedPos = blockPlacementPos.func_177982_a(offsetX + checkX, offsetY + checkY, offsetZ + checkZ);
                            if (!checkedPositions.containsKey(checkedPos)) ** GOTO lbl114
                            if (checkedPositions.get(checkedPos) == null) {
                                valid = world.isSideSolid(checkedPos, sideHit);
                                if (valid) {
                                    portalOffset = checkedPos.func_177972_a(sideHit);
                                    te = world.func_175625_s(portalOffset);
                                    if (te instanceof TilePortalBase) {
                                        portalBase = (TilePortalBase)te;
                                        valid = portalBase.portals.containsKey(sideHit) == false || portalBase.portals.get(sideHit).getPortal().isSameType(portalInfo) != false;
                                    } else {
                                        valid = world.func_180495_p(portalOffset).func_185890_d(world, portalOffset) == null;
                                    }
                                }
                                checkedPositions.put(checkedPos, valid);
                                if (blockPlacementPos.equals((Object)checkedPos) && !valid) {
                                    return null;
                                }
                            }
                            if (((Boolean)checkedPositions.get(checkedPos)).booleanValue()) {
                                if (!validPositions.contains(checkedPos)) {
                                    validPositions.add(checkedPos);
                                }
                            } else {
                                validPositions.clear();
                                continue;
lbl114:
                                // 1 sources

                                validPositions.clear();
                                continue;
                            }
                            if (validPositions.size() != portalWidth * portalHeight || !validPositions.contains(blockPlacementPos)) continue;
                            masterPos = null;
                            for (BlockPos masterPosition : validPositions) {
                                if (!world.func_175716_a(PortalGun.blockPortal, masterPosition.func_177972_a(sideHit), true, sideHit, null, null) || world.func_180495_p(masterPosition.func_177972_a(sideHit)).func_185904_a() instanceof MaterialLiquid) continue;
                                masterPos = masterPosition;
                                break;
                            }
                            if (masterPos == null) {
                                return null;
                            }
                            validPositions.add(0, masterPos);
                            portalPositions = validPositions.stream().map((Function<BlockPos, BlockPos>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$canPlacePortal$0(net.minecraft.util.EnumFacing net.minecraft.util.math.BlockPos ), (Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/util/math/BlockPos;)((EnumFacing)sideHit)).collect(Collectors.toCollection((Supplier<ArrayList>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, <init>(), ()Ljava/util/ArrayList;)()));
                            return portalPositions.toArray(new BlockPos[portalWidth * portalHeight]);
                        }
                    }
                }
            }
        }
        return null;
    }

    public static int[] generateChannelColour(String uuid, String channelName) {
        String generator = uuid + "_" + channelName;
        Random rand = new Random();
        rand.setSeed(Math.abs(generator.hashCode() * uuid.hashCode()));
        int colourA = Math.round(1.6777215E7f * rand.nextFloat());
        float[] hsb = new float[3];
        Color.RGBtoHSB(colourA >> 16 & 0xFF, colourA >> 8 & 0xFF, colourA & 0xFF, hsb);
        hsb[2] = 0.65f + 0.25f * hsb[2];
        colourA = Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]);
        hsb[0] = hsb[0] + 0.5f;
        if (hsb[0] > 1.0f) {
            hsb[0] = hsb[0] - 1.0f;
        }
        int colourB = Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]);
        return new int[]{colourA, colourB};
    }

    private static /* synthetic */ BlockPos lambda$canPlacePortal$0(EnumFacing sideHit, BlockPos pos) {
        return pos.func_177972_a(sideHit);
    }
}

