/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.portalgun.common.portal.world;

import java.util.HashSet;
import me.ichun.mods.ichunutil.common.core.util.EntityHelper;
import me.ichun.mods.ichunutil.common.module.worldportals.common.portal.WorldPortal;
import me.ichun.mods.portalgun.client.sound.PortalAmbienceSound;
import me.ichun.mods.portalgun.common.PortalGun;
import me.ichun.mods.portalgun.common.core.SoundIndex;
import me.ichun.mods.portalgun.common.entity.EntityPortalProjectile;
import me.ichun.mods.portalgun.common.portal.info.PortalInfo;
import me.ichun.mods.portalgun.common.tileentity.TilePortalBase;
import net.minecraft.block.material.MaterialLiquid;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PortalPlacement
extends WorldPortal {
    private PortalInfo portal;
    public BlockPos[] portalSpots;
    public HashSet<BlockPos> compensatedSpots;
    public int pairTime;
    public boolean setup;
    public boolean destroyed;
    public boolean playedAmbience;
    public boolean playerIsIn;

    public PortalPlacement(World world) {
        super(world);
        this.portal = new PortalInfo().setInfo("Unknown", "Unknown", false);
        this.portalSpots = new BlockPos[0];
        this.compensatedSpots = new HashSet();
    }

    public PortalPlacement(World world, Vec3d position, EnumFacing faceOn, EnumFacing upDir, float width, float height, PortalInfo info, BlockPos[] portalSpots) {
        super(world, position, faceOn, upDir, width, height);
        this.portal = info;
        this.portalSpots = portalSpots;
        this.compensatedSpots = new HashSet();
    }

    public PortalInfo getPortal() {
        return this.portal;
    }

    public void setPortal(PortalInfo info) {
        this.portal = info;
    }

    public float getPlaneOffset() {
        return -0.5f;
    }

    public boolean canCollideWithBorders() {
        return true;
    }

    public String owner() {
        return "PortalGun";
    }

    public void setWorld(World world) {
        this.world = world;
    }

    public boolean onLoad() {
        return this.portal != null && !this.portal.uuid.equals("Unknown") && this.portalSpots.length != 0;
    }

    public void setPortalPair(PortalInfo info) {
        this.pairTime = 0;
        this.portal.setPair(info);
        if (this.portal.getPair() != null) {
            this.portal.getPair().setPair(this.portal);
            PortalPlacement pp = this.portal.getPair().getPortalPlacement(this.world);
            if (pp != null) {
                this.setPair(pp);
                pp.setPair(this);
            }
        } else {
            this.setPair(null);
        }
    }

    public boolean tick() {
        if (!this.setup || this.destroyed) {
            return true;
        }
        if (this.isFirstUpdate()) {
            for (BlockPos pos : this.portalSpots) {
                if (pos.equals((Object)this.portal.getPos())) continue;
                boolean flag = false;
                for (BlockPos compensated : this.compensatedSpots) {
                    if (!compensated.equals((Object)pos)) continue;
                    flag = true;
                    break;
                }
                if (flag) continue;
                TileEntity te = this.world.func_175625_s(pos);
                if (te != null) {
                    te.func_145834_a(this.world);
                }
                if (te instanceof TilePortalBase && ((TilePortalBase)te).addPortal(this)) continue;
                return false;
            }
            if (this.world.field_72995_K) {
                PortalPlacement pp;
                this.firstUpdateClient();
                if (this.portal.getPair() != null && (pp = this.portal.getPair().getPortalPlacement(this.world)) != null) {
                    this.setPortalPair(pp.getPortal());
                }
            } else {
                this.setPortalPair(PortalGun.eventHandlerServer.getWorldSaveData(this.world.field_73011_w.getDimension()).findPair(this.portal));
            }
        }
        if (this.time == 0) {
            this.world.func_184148_a(null, this.getPosition().field_72450_a, this.getPosition().field_72448_b, this.getPosition().field_72449_c, this.portal.isTypeA ? SoundIndex.p_portal_open_blue : SoundIndex.p_portal_open_red, SoundCategory.BLOCKS, 0.4f, 1.0f + (this.world.field_73012_v.nextFloat() - this.world.field_73012_v.nextFloat()) * 0.1f);
        }
        this.updateWorldPortal();
        if (this.hasPair()) {
            ++this.pairTime;
        }
        for (BlockPos pos : this.compensatedSpots) {
            if (this.world.isSideSolid(pos.func_177967_a(this.getFaceOn(), -1), this.getFaceOn()) && !(this.world.func_180495_p(pos).func_185904_a() instanceof MaterialLiquid) && this.world.func_180495_p(pos).func_185890_d(this.world, pos) == null) continue;
            this.remove(BlockPos.field_177992_a);
        }
        return true;
    }

    public boolean canEntityTeleport(Entity ent) {
        return !(ent instanceof EntityPortalProjectile);
    }

    @SideOnly(value=Side.CLIENT)
    public void firstUpdateClient() {
        if (!this.playedAmbience) {
            this.playedAmbience = true;
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new PortalAmbienceSound(SoundIndex.p_wpn_portal_ambient_lp, SoundCategory.BLOCKS, 0.003f, 1.0f, this));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void handleClient() {
        super.handleClient();
        EntityPlayerSP ent = Minecraft.func_71410_x().field_71439_g;
        float offset = Math.min(0.325f, (float)Math.abs((this.getFlatPlane().field_72340_a - ent.field_70165_t) * (double)this.getFaceOn().func_82601_c() + (this.getFlatPlane().field_72338_b - ent.field_70163_u) * (double)this.getFaceOn().func_96559_d() + (this.getFlatPlane().field_72339_c - ent.field_70161_v) * (double)this.getFaceOn().func_82599_e()));
        boolean playerIn = this.portalInsides.func_72317_d((double)((float)this.getFaceOn().func_82601_c() * offset), (double)((float)this.getFaceOn().func_96559_d() * offset), (double)((float)this.getFaceOn().func_82599_e() * offset)).func_72326_a(ent.func_174813_aQ());
        if (playerIn != this.playerIsIn) {
            this.playerIsIn = playerIn;
            double motion = Math.sqrt(ent.field_70159_w * ent.field_70159_w + ent.field_70181_x * ent.field_70181_x + ent.field_70179_y * ent.field_70179_y) * 0.1;
            if (this.playerIsIn) {
                EntityHelper.playSoundAtEntity((Entity)ent, (SoundEvent)SoundIndex.p_portal_enter, (SoundCategory)ent.func_184176_by(), (float)0.01f, (float)(1.0f + (ent.field_70170_p.field_73012_v.nextFloat() - ent.field_70170_p.field_73012_v.nextFloat()) * 0.1f + (float)motion));
            } else {
                EntityHelper.playSoundAtEntity((Entity)ent, (SoundEvent)SoundIndex.p_portal_exit, (SoundCategory)ent.func_184176_by(), (float)0.01f, (float)(1.0f + (ent.field_70170_p.field_73012_v.nextFloat() - ent.field_70170_p.field_73012_v.nextFloat()) * 0.1f + (float)motion));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void handleClientEntityTeleport(Entity ent, float[] rotations) {
        if (ent == Minecraft.func_71410_x().field_71439_g) {
            PortalPlacement pp = this.portal.getPair().getPortalPlacement(this.world);
            if (pp != null) {
                pp.playerIsIn = true;
            }
            this.playerIsIn = false;
        }
        super.handleClientEntityTeleport(ent, rotations);
    }

    public boolean create() {
        TileEntity te;
        for (BlockPos pos : this.portalSpots) {
            if (this.world.func_180495_p(pos).func_177230_c() != PortalGun.blockPortal || !((te = this.world.func_175625_s(pos)) instanceof TilePortalBase)) continue;
            TilePortalBase portalBase = (TilePortalBase)te;
            if (portalBase.portals.get(this.getFaceOn()) == this) continue;
            portalBase.removePortal(portalBase.portals.get(this.getFaceOn()));
        }
        this.compensatedSpots.clear();
        for (BlockPos pos : this.portalSpots) {
            if (this.world.func_180495_p(pos).func_177230_c() != PortalGun.blockPortal) {
                if (this.world.func_175716_a(PortalGun.blockPortal, pos, true, this.getFaceOn(), null, null)) {
                    this.world.func_180501_a(pos, PortalGun.blockPortal.func_176203_a(pos.equals((Object)this.portalSpots[0]) ? 1 : 0), 2);
                } else {
                    if (pos.equals((Object)this.portalSpots[0])) {
                        return false;
                    }
                    this.compensatedSpots.add(pos);
                }
            }
            if ((te = this.world.func_175625_s(pos)) instanceof TilePortalBase) {
                ((TilePortalBase)te).addPortal(this);
                continue;
            }
            if (this.compensatedSpots.contains(pos)) continue;
            this.setup = true;
            this.remove(BlockPos.field_177992_a);
            return false;
        }
        for (BlockPos pos : this.portalSpots) {
            this.world.func_175722_b(pos, PortalGun.blockPortal);
        }
        PortalGun.eventHandlerServer.updatePortalInfo(this.world, this.portal, false);
        this.setup = true;
        return true;
    }

    public void addCompensationIfRequired(BlockPos pos) {
        if (!(this.world.func_175625_s(pos) instanceof TilePortalBase) && !this.compensatedSpots.contains(pos) && this.world.isSideSolid(pos.func_177967_a(this.getFaceOn(), -1), this.getFaceOn()) && !(this.world.func_180495_p(pos).func_185904_a() instanceof MaterialLiquid) && this.world.func_180495_p(pos).func_185890_d(this.world, pos) == null) {
            this.compensatedSpots.add(pos);
        }
    }

    public void remove(BlockPos callPos) {
        if (this.setup && !this.destroyed) {
            this.destroyed = true;
            if (this.portalSpots != null) {
                for (BlockPos pos : this.portalSpots) {
                    TileEntity te;
                    if (pos.equals((Object)callPos) || !((te = this.world.func_175625_s(pos)) instanceof TilePortalBase)) continue;
                    ((TilePortalBase)te).removePortal(this);
                }
            }
            this.terminate();
            this.world.func_184148_a(null, this.getPosition().field_72450_a, this.getPosition().field_72448_b, this.getPosition().field_72449_c, SoundIndex.p_portal_fizzle, SoundCategory.BLOCKS, 0.4f, 1.0f + (this.world.field_73012_v.nextFloat() - this.world.field_73012_v.nextFloat()) * 0.1f);
            PortalGun.eventHandlerServer.updatePortalInfo(this.world, this.portal, true);
        }
    }

    public boolean isAgainstWall() {
        return true;
    }

    public boolean isValid() {
        if (this.setup && !this.destroyed) {
            boolean valid;
            boolean bl = valid = this.portalSpots != null;
            if (valid) {
                for (BlockPos pos : this.portalSpots) {
                    if (!this.world.isSideSolid(pos.func_177967_a(this.getFaceOn(), -1), this.getFaceOn())) {
                        valid = false;
                        break;
                    }
                    TileEntity te = this.world.func_175625_s(pos);
                    if (te instanceof TilePortalBase && ((TilePortalBase)te).portals.get(this.getFaceOn()) == this || this.compensatedSpots.contains(pos)) continue;
                    valid = false;
                    break;
                }
            }
            return valid && super.isValid();
        }
        return true;
    }

    public PortalPlacement createFakeInstance(NBTTagCompound tag) {
        PortalPlacement portal = new PortalPlacement(this.world);
        portal.readFromNBT(tag, true);
        return portal;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        int i;
        this.write(tag);
        tag.func_74782_a("portal", (NBTBase)this.portal.writeToNBT(new NBTTagCompound()));
        if (this.hasPair()) {
            tag.func_74757_a("hasPair", true);
            tag.func_74782_a("infoPair", (NBTBase)this.portal.getPair().writeToNBT(new NBTTagCompound()));
        }
        tag.func_74768_a("portalSpotsSize", this.portalSpots.length);
        for (i = 0; i < this.portalSpots.length; ++i) {
            tag.func_74768_a("portalSpot_" + i + "_X", this.portalSpots[i].func_177958_n());
            tag.func_74768_a("portalSpot_" + i + "_Y", this.portalSpots[i].func_177956_o());
            tag.func_74768_a("portalSpot_" + i + "_Z", this.portalSpots[i].func_177952_p());
        }
        tag.func_74768_a("compensatedSpotsSize", this.compensatedSpots.size());
        i = 0;
        for (BlockPos com : this.compensatedSpots) {
            tag.func_74768_a("compensatedSpot_" + i + "_X", com.func_177958_n());
            tag.func_74768_a("compensatedSpot_" + i + "_Y", com.func_177956_o());
            tag.func_74768_a("compensatedSpot_" + i + "_Z", com.func_177952_p());
            ++i;
        }
        tag.func_74757_a("setup", this.setup);
        tag.func_74757_a("destroyed", this.destroyed);
        return tag;
    }

    public PortalPlacement readFromNBT(NBTTagCompound tag, boolean fake) {
        if (fake) {
            this.readSelf(tag);
        } else {
            this.read(tag);
        }
        this.portal = new PortalInfo().readFromNBT(tag.func_74775_l("portal"));
        if (tag.func_74767_n("hasPair")) {
            this.portal.setPair(new PortalInfo().readFromNBT(tag.func_74775_l("infoPair")));
        } else {
            this.portal.setPair(null);
        }
        this.portalSpots = new BlockPos[tag.func_74762_e("portalSpotsSize")];
        for (int i = 0; i < this.portalSpots.length; ++i) {
            this.portalSpots[i] = new BlockPos(tag.func_74762_e("portalSpot_" + i + "_X"), tag.func_74762_e("portalSpot_" + i + "_Y"), tag.func_74762_e("portalSpot_" + i + "_Z"));
        }
        this.compensatedSpots = new HashSet();
        int compensatedLength = tag.func_74762_e("compensatedSpotsSize");
        for (int i = 0; i < compensatedLength; ++i) {
            this.compensatedSpots.add(new BlockPos(tag.func_74762_e("compensatedSpot_" + i + "_X"), tag.func_74762_e("compensatedSpot_" + i + "_Y"), tag.func_74762_e("compensatedSpot_" + i + "_Z")));
        }
        this.setup = tag.func_74767_n("setup");
        this.destroyed = tag.func_74767_n("destroyed");
        return this;
    }

    public boolean equals(Object o) {
        if (o instanceof PortalPlacement) {
            PortalPlacement portal = (PortalPlacement)((Object)o);
            return this.portalSpots.length == portal.portalSpots.length && this.portalSpots.length > 0 && this.portalSpots[0].equals((Object)portal.portalSpots[0]) && this.portal.equals(portal.portal) && this.getWidth() == portal.getWidth() && this.getHeight() == portal.getHeight() && this.getFaceOn() == portal.getFaceOn();
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void drawPlane(float partialTick) {
        GlStateManager.func_179094_E();
        float sizeProg = MathHelper.func_76131_a((float)(((float)(this.time - 1) + partialTick) / 5.0f), (float)0.0f, (float)1.0f);
        float scaleX = 0.5f * this.getWidth() * 0.95f * sizeProg;
        float scaleY = 0.5f * this.getHeight() * 0.95f * sizeProg;
        float scaleZ = 0.475f;
        double pushback = -0.491;
        int horiOrient = (this.getFaceOn().func_176740_k() == EnumFacing.Axis.Y ? this.getUpDir() : this.getFaceOn()).func_176734_d().func_176736_b();
        GlStateManager.func_179114_b((float)((this.getFaceOn().func_176745_a() > 0 ? 180.0f : 0.0f) + (float)(-horiOrient) * 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        if (this.getFaceOn().func_176740_k() == EnumFacing.Axis.Y) {
            GlStateManager.func_179114_b((float)(this.getFaceOn() == EnumFacing.UP ? -90.0f : 90.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)pushback);
        GlStateManager.func_179152_a((float)scaleX, (float)scaleY, (float)scaleZ);
        GlStateManager.func_187447_r((int)6);
        GlStateManager.func_187435_e((float)0.0f, (float)0.0f, (float)0.0f);
        double divisions = 50.0;
        int i = 0;
        while ((double)i <= divisions) {
            double angle = Math.PI * 2 * ((double)i / divisions);
            GlStateManager.func_187435_e((float)((float)Math.cos(angle)), (float)((float)Math.sin(angle)), (float)0.0f);
            ++i;
        }
        GlStateManager.func_187437_J();
        GlStateManager.func_179121_F();
    }
}

