/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.minecraft;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Vector3;
import codechicken.multipart.IFaceRedstonePart;
import codechicken.multipart.minecraft.McSidedMetaPart;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLever;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;

public class LeverPart
extends McSidedMetaPart
implements IFaceRedstonePart {
    public static BlockLever lever = (BlockLever)Blocks.field_150442_at;
    public static Cuboid6[][] bounds = new Cuboid6[6][2];

    public LeverPart() {
        this.state = lever.func_176223_P();
    }

    public LeverPart(IBlockState state) {
        super(state);
    }

    @Override
    public Block getBlock() {
        return lever;
    }

    @Override
    public String getType() {
        return "mc_lever";
    }

    public boolean active() {
        return (Boolean)this.state.func_177229_b((IProperty)BlockLever.field_176359_b);
    }

    @Override
    public int getSideFromState() {
        return ((BlockLever.EnumOrientation)this.state.func_177229_b((IProperty)BlockLever.field_176360_a)).func_176852_c().func_176734_d().ordinal();
    }

    @Override
    public boolean activate(EntityPlayer player, CuboidRayTraceResult hit, ItemStack item, EnumHand hand) {
        if (this.world().field_72995_K) {
            return true;
        }
        this.state = this.state.func_177231_a((IProperty)BlockLever.field_176359_b);
        this.world().func_184133_a(null, this.pos(), SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 0.3f, this.active() ? 0.6f : 0.5f);
        this.sendDescUpdate();
        this.tile().func_70296_d();
        this.tile().notifyPartChange(this);
        this.tile().notifyNeighborChange(this.getSideFromState());
        return true;
    }

    @Override
    public void onRemoved() {
        if (this.active()) {
            this.tile().notifyNeighborChange(this.getSideFromState());
        }
    }

    @Override
    public void onConverted() {
        if (this.active()) {
            this.tile().notifyNeighborChange(this.getSideFromState());
        }
    }

    @Override
    public Cuboid6 getBounds() {
        BlockLever.EnumOrientation facing = (BlockLever.EnumOrientation)this.state.func_177229_b((IProperty)BlockLever.field_176360_a);
        int r = facing == BlockLever.EnumOrientation.DOWN_X || facing == BlockLever.EnumOrientation.UP_X ? 1 : 0;
        return bounds[this.getSideFromState()][r];
    }

    @Override
    public int weakPowerLevel(int side) {
        return this.active() ? 15 : 0;
    }

    @Override
    public int strongPowerLevel(int side) {
        return this.active() && side == this.getSideFromState() ? 15 : 0;
    }

    @Override
    public boolean canConnectRedstone(int side) {
        return true;
    }

    @Override
    public int getFace() {
        return this.getSideFromState();
    }

    static {
        LeverPart.bounds[0][0] = new Cuboid6(0.3125, 0.0, 0.1875, 0.6875, 0.375, 0.8125);
        for (int r = 0; r < 2; ++r) {
            for (int s = 0; s < 6; ++s) {
                LeverPart.bounds[s][r] = bounds[0][0].copy().apply(Rotation.sideOrientation((int)s, (int)r).at(Vector3.center));
            }
        }
    }
}

