/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.model;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import gnu.trove.map.hash.THashMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.ModelStateComposition;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import slimeknights.tconstruct.library.client.model.BakedBowModel;
import slimeknights.tconstruct.library.client.model.BakedMaterialModel;
import slimeknights.tconstruct.library.client.model.BakedToolModel;
import slimeknights.tconstruct.library.client.model.BakedToolModelOverride;
import slimeknights.tconstruct.library.client.model.MaterialModel;
import slimeknights.tconstruct.library.client.model.ModelHelper;
import slimeknights.tconstruct.library.client.model.ModifierModel;
import slimeknights.tconstruct.library.client.model.format.AmmoPosition;
import slimeknights.tconstruct.library.client.model.format.ToolModelOverride;

public class ToolModel
implements IModel {
    private final List<MaterialModel> partBlocks;
    private final List<MaterialModel> brokenPartBlocks;
    private final Float[] layerRotations;
    private final ModifierModel modifiers;
    private final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms;
    private final ImmutableList<ToolModelOverride> overrides;
    private final ImmutableList<ResourceLocation> textures;
    private final AmmoPosition ammoPosition;

    public ToolModel(ImmutableList<ResourceLocation> defaultTextures, List<MaterialModel> parts, List<MaterialModel> brokenPartBlocks, Float[] layerRotations, ModifierModel modifiers, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, ImmutableList<ToolModelOverride> overrides, AmmoPosition ammoPosition) {
        this.partBlocks = parts;
        this.brokenPartBlocks = brokenPartBlocks;
        this.layerRotations = layerRotations;
        this.modifiers = modifiers;
        this.transforms = transforms;
        this.overrides = overrides;
        this.textures = defaultTextures;
        this.ammoPosition = ammoPosition;
    }

    public Collection<ResourceLocation> getDependencies() {
        return ImmutableList.of();
    }

    public Collection<ResourceLocation> getTextures() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll(this.textures);
        if (this.modifiers != null) {
            builder.addAll(this.modifiers.getTextures());
        }
        for (ToolModelOverride override : this.overrides) {
            for (MaterialModel model : override.partModelReplacement.valueCollection()) {
                builder.addAll(model.getTextures());
            }
            for (MaterialModel model : override.brokenPartModelReplacement.valueCollection()) {
                builder.addAll(model.getTextures());
            }
        }
        return builder.build();
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        int i;
        IBakedModel base = new ItemLayerModel(this.textures).bake(state, format, bakedTextureGetter);
        BakedMaterialModel[] partModels = new BakedMaterialModel[this.partBlocks.size()];
        BakedMaterialModel[] brokenPartModels = new BakedMaterialModel[this.partBlocks.size()];
        for (i = 0; i < this.partBlocks.size(); ++i) {
            MaterialModel materialModel = this.partBlocks.get(i);
            partModels[i] = materialModel.bakeIt(this.getStateForPart(i, state), format, bakedTextureGetter);
        }
        for (i = 0; i < this.brokenPartBlocks.size(); ++i) {
            if (this.brokenPartBlocks.get(i) == null) continue;
            brokenPartModels[i] = this.brokenPartBlocks.get(i).bakeIt(this.getStateForPart(i, state), format, bakedTextureGetter);
        }
        Object modifierModels = this.modifiers != null ? this.modifiers.bakeModels(state, format, bakedTextureGetter) : new THashMap();
        HashMap builder = Maps.newHashMap();
        builder.putAll(IPerspectiveAwareModel.MapWrapper.getTransforms((IModelState)state));
        builder.putAll(this.transforms);
        ImmutableList.Builder overrideBuilder = ImmutableList.builder();
        for (ToolModelOverride override : this.overrides) {
            BakedMaterialModel[] overridenPartModels = new BakedMaterialModel[this.partBlocks.size()];
            BakedMaterialModel[] overridenBrokenPartModels = new BakedMaterialModel[this.partBlocks.size()];
            for (int i2 = 0; i2 < this.partBlocks.size(); ++i2) {
                overridenPartModels[i2] = override.partModelReplacement.containsKey(i2) ? ((MaterialModel)override.partModelReplacement.get(i2)).bakeIt(this.getStateForPart(i2, state), format, bakedTextureGetter) : partModels[i2];
                overridenBrokenPartModels[i2] = override.brokenPartModelReplacement.containsKey(i2) ? ((MaterialModel)override.brokenPartModelReplacement.get(i2)).bakeIt(this.getStateForPart(i2, state), format, bakedTextureGetter) : brokenPartModels[i2];
            }
            HashMap builder2 = Maps.newHashMap();
            builder2.putAll(IPerspectiveAwareModel.MapWrapper.getTransforms((IModelState)state));
            builder2.putAll(this.transforms);
            builder2.putAll(override.transforms);
            Object overriddenModifierModels = override.overrideModifierModel != null ? override.overrideModifierModel.bakeModels(state, format, bakedTextureGetter) : modifierModels;
            BakedToolModel bakedToolModel = this.getBakedToolModel(base, overridenPartModels, overridenBrokenPartModels, (Map<String, IBakedModel>)overriddenModifierModels, (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)ImmutableMap.copyOf((Map)builder2), (ImmutableList<BakedToolModelOverride>)ImmutableList.of(), override.ammoPosition);
            overrideBuilder.add((Object)new BakedToolModelOverride(override.predicates, bakedToolModel));
        }
        return this.getBakedToolModel(base, partModels, brokenPartModels, (Map<String, IBakedModel>)modifierModels, (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)ImmutableMap.copyOf((Map)builder), (ImmutableList<BakedToolModelOverride>)overrideBuilder.build(), this.ammoPosition);
    }

    private BakedToolModel getBakedToolModel(IBakedModel base, BakedMaterialModel[] partModels, BakedMaterialModel[] brokenPartModels, Map<String, IBakedModel> modifierModels, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transform, ImmutableList<BakedToolModelOverride> build, AmmoPosition ammoPosition) {
        if (ammoPosition != null) {
            AmmoPosition combined = ammoPosition.combine(this.ammoPosition);
            return new BakedBowModel(base, partModels, brokenPartModels, modifierModels, transform, build, combined);
        }
        return new BakedToolModel(base, partModels, brokenPartModels, modifierModels, transform, build);
    }

    private IModelState getStateForPart(int i, IModelState originalState) {
        if (this.layerRotations.length > i) {
            return new ModelStateComposition(originalState, (IModelState)TRSRTransformation.blockCenterToCorner((TRSRTransformation)new TRSRTransformation(null, TRSRTransformation.quatFromXYZ((float)0.0f, (float)0.0f, (float)((float)((double)this.layerRotations[i].floatValue() * Math.PI / 180.0))), null, null)));
        }
        return originalState;
    }

    public IModelState getDefaultState() {
        return ModelHelper.DEFAULT_TOOL_STATE;
    }
}

