/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.block;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.block.BlockInventory;
import slimeknights.mantle.property.PropertyString;
import slimeknights.mantle.property.PropertyUnlistedDirection;
import slimeknights.mantle.tileentity.TileInventory;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.shared.block.PropertyTableItem;
import slimeknights.tconstruct.shared.tileentity.TileTable;

public class BlockTable
extends BlockInventory
implements ITileEntityProvider {
    public static final PropertyString TEXTURE = new PropertyString("texture");
    public static final PropertyTableItem INVENTORY = new PropertyTableItem();
    public static final PropertyUnlistedDirection FACING = new PropertyUnlistedDirection("facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    private static ImmutableList<AxisAlignedBB> BOUNDS_Table = ImmutableList.of((Object)new AxisAlignedBB(0.0, 0.75, 0.0, 1.0, 1.0, 1.0), (Object)new AxisAlignedBB(0.0, 0.0, 0.0, 0.25, 0.75, 0.25), (Object)new AxisAlignedBB(0.75, 0.0, 0.0, 1.0, 0.75, 0.25), (Object)new AxisAlignedBB(0.75, 0.0, 0.75, 1.0, 0.75, 1.0), (Object)new AxisAlignedBB(0.0, 0.0, 0.75, 0.25, 0.75, 1.0));

    public BlockTable(Material materialIn) {
        super(materialIn);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_176225_a(IBlockState blockState, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nonnull
    public TileEntity func_149915_a(@Nonnull World worldIn, int meta) {
        return new TileTable("tile.table", 0, 0);
    }

    public boolean openGui(EntityPlayer player, World world, BlockPos pos) {
        return false;
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[0], new IUnlistedProperty[]{TEXTURE, INVENTORY, FACING});
    }

    @Nonnull
    public IBlockState getExtendedState(@Nonnull IBlockState state, IBlockAccess world, BlockPos pos) {
        IExtendedBlockState extendedState = (IExtendedBlockState)state;
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileTable) {
            TileTable table = (TileTable)te;
            return table.writeExtendedBlockState(extendedState);
        }
        return super.getExtendedState(state, world, pos);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        NBTTagCompound tag = TagUtil.getTagSafe(stack);
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileTable) {
            TileTable table = (TileTable)te;
            NBTTagCompound feetTag = tag.func_74775_l("textureBlock");
            if (feetTag == null) {
                feetTag = new NBTTagCompound();
            }
            table.updateTextureBlock(feetTag);
            table.setFacing(placer.func_174811_aO().func_176734_d());
            if (tag.func_74764_b("inventory")) {
                table.readInventoryFromNBT(tag.func_74775_l("inventory"));
            }
            if (stack.func_82837_s()) {
                table.setCustomName(stack.func_82833_r());
            }
        }
    }

    public boolean removedByPlayer(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player, boolean willHarvest) {
        TileEntity te;
        this.func_176206_d(world, pos, state);
        if (willHarvest) {
            this.func_180657_a(world, player, pos, state, world.func_175625_s(pos), player.func_184614_ca());
        }
        if (this.keepInventory(state) && (te = world.func_175625_s(pos)) instanceof TileInventory) {
            ((TileInventory)te).func_174888_l();
        }
        world.func_175698_g(pos);
        return false;
    }

    protected boolean keepInventory(IBlockState state) {
        return false;
    }

    private void writeDataOntoItemstack(@Nonnull ItemStack item, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull IBlockState state, boolean inventorySave) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileTable) {
            TileTable table = (TileTable)te;
            NBTTagCompound tag = TagUtil.getTagSafe(item);
            NBTTagCompound data = table.getTextureBlock();
            if (!data.func_82582_d()) {
                tag.func_74782_a("textureBlock", (NBTBase)data);
            }
            if (inventorySave && this.keepInventory(state) && !table.isInventoryEmpty()) {
                NBTTagCompound inventoryTag = new NBTTagCompound();
                table.writeInventoryToNBT(inventoryTag);
                tag.func_74782_a("inventory", (NBTBase)inventoryTag);
                table.func_174888_l();
            }
            if (!tag.func_82582_d()) {
                item.func_77982_d(tag);
            }
        }
    }

    public void func_180653_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, float chance, int fortune) {
        if (!worldIn.field_72995_K && !worldIn.restoringBlockSnapshots) {
            List items = this.getDrops((IBlockAccess)worldIn, pos, state, fortune);
            chance = ForgeEventFactory.fireBlockHarvesting((List)items, (World)worldIn, (BlockPos)pos, (IBlockState)state, (int)fortune, (float)chance, (boolean)false, (EntityPlayer)((EntityPlayer)this.harvesters.get()));
            for (ItemStack item : items) {
                if (item.func_77973_b() != Item.func_150898_a((Block)this)) continue;
                this.writeDataOntoItemstack(item, (IBlockAccess)worldIn, pos, state, chance >= 1.0f);
            }
            TileEntity te = worldIn.func_175625_s(pos);
            if (te instanceof TileInventory) {
                TileInventory tileInventory = (TileInventory)te;
                for (int i = 0; i < tileInventory.func_70302_i_(); ++i) {
                    ItemStack itemStack = tileInventory.func_70301_a(i);
                    if (itemStack == null) continue;
                    items.add(itemStack);
                }
                tileInventory.func_174888_l();
                if (tileInventory.func_145818_k_()) {
                    for (ItemStack item : items) {
                        if (item.func_77973_b() != Item.func_150898_a((Block)this)) continue;
                        item.func_151001_c(tileInventory.func_70005_c_());
                        item.func_82841_c(0);
                    }
                }
            }
            for (ItemStack item : items) {
                if (!(worldIn.field_73012_v.nextFloat() <= chance)) continue;
                BlockTable.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)item);
            }
        }
    }

    @Nonnull
    public ItemStack getPickBlock(@Nonnull IBlockState state, RayTraceResult target, @Nonnull World world, @Nonnull BlockPos pos, EntityPlayer player) {
        List drops = this.getDrops((IBlockAccess)world, pos, world.func_180495_p(pos), 0);
        if (drops.size() > 0) {
            ItemStack stack = (ItemStack)drops.get(0);
            this.writeDataOntoItemstack(stack, (IBlockAccess)world, pos, state, false);
            return stack;
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    public static ItemStack createItemstack(BlockTable table, int tableMeta, Block block, int blockMeta) {
        ItemStack stack = new ItemStack((Block)table, 1, tableMeta);
        if (block != null) {
            ItemStack blockStack = new ItemStack(block, 1, blockMeta);
            NBTTagCompound tag = new NBTTagCompound();
            NBTTagCompound subTag = new NBTTagCompound();
            blockStack.func_77955_b(subTag);
            tag.func_74782_a("textureBlock", (NBTBase)subTag);
            stack.func_77982_d(tag);
        }
        return stack;
    }

    public boolean isSideSolid(@Nonnull IBlockState base_state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
        return side == EnumFacing.UP || super.isSideSolid(base_state, world, pos, side);
    }

    public RayTraceResult func_180636_a(IBlockState blockState, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull Vec3d start, @Nonnull Vec3d end) {
        return BlockTable.raytraceMultiAABB(BOUNDS_Table, pos, start, end);
    }

    public static RayTraceResult raytraceMultiAABB(List<AxisAlignedBB> aabbs, BlockPos pos, Vec3d start, Vec3d end) {
        ArrayList list = Lists.newArrayList();
        for (AxisAlignedBB axisalignedbb : aabbs) {
            list.add(BlockTable.rayTrace2(pos, start, end, axisalignedbb));
        }
        RayTraceResult raytraceresult1 = null;
        double d1 = 0.0;
        for (RayTraceResult raytraceresult : list) {
            double d0;
            if (raytraceresult == null || !((d0 = raytraceresult.field_72307_f.func_72436_e(end)) > d1)) continue;
            raytraceresult1 = raytraceresult;
            d1 = d0;
        }
        return raytraceresult1;
    }

    private static RayTraceResult rayTrace2(BlockPos pos, Vec3d start, Vec3d end, AxisAlignedBB boundingBox) {
        Vec3d vec3d1;
        Vec3d vec3d = start.func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        RayTraceResult raytraceresult = boundingBox.func_72327_a(vec3d, vec3d1 = end.func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()));
        return raytraceresult == null ? null : new RayTraceResult(raytraceresult.field_72307_f.func_72441_c((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()), raytraceresult.field_178784_b, pos);
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileTable) {
            TileTable table = (TileTable)te;
            table.setFacing(table.getFacing().func_176746_e());
            IBlockState state = world.func_180495_p(pos);
            world.func_184138_a(pos, state, state, 0);
            return true;
        }
        return false;
    }
}

