/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerPickupXpEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.modifiers.ModifierTrait;
import slimeknights.tconstruct.library.utils.ModifierTagHolder;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;
import slimeknights.tconstruct.library.utils.ToolHelper;

public class ModMendingMoss
extends ModifierTrait {
    public static final int MENDING_MOSS_LEVELS = 10;
    private static final String TAG_STORED_XP = "stored_xp";
    private static final String TAG_LAST_HEAL = "heal_timestamp";
    private static final int DELAY = 150;

    public ModMendingMoss() {
        super("mending_moss", 4434738, 3, 0);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void onUpdate(ItemStack tool, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (!world.field_72995_K && entity instanceof EntityLivingBase) {
            if (entity instanceof EntityPlayer && !InventoryPlayer.func_184435_e((int)itemSlot) && ((EntityPlayer)entity).func_184592_cb() != tool) {
                return;
            }
            if (this.needsRepair(tool) && this.useXp(tool, world)) {
                ToolHelper.healTool(tool, this.getDurabilityPerXP(tool), (EntityLivingBase)entity);
            }
        }
    }

    @SubscribeEvent
    public void onPickupXp(PlayerPickupXpEvent event) {
        ArrayList tools = Lists.newArrayList((Object[])new ItemStack[]{event.getEntityPlayer().func_184614_ca(), event.getEntityPlayer().func_184592_cb()});
        EntityXPOrb entityXPOrb = event.getOrb();
        for (ItemStack itemStack : tools) {
            if (itemStack == null || !this.isMendingMossModified(itemStack)) continue;
            int stored = this.storeXp(entityXPOrb.field_70530_e, itemStack);
            entityXPOrb.field_70530_e -= stored;
        }
    }

    private boolean isMendingMossModified(ItemStack itemStack) {
        return TinkerUtil.hasModifier(TagUtil.getTagSafe(itemStack), this.getModifierIdentifier());
    }

    private boolean needsRepair(ItemStack itemStack) {
        return itemStack != null && itemStack.func_77952_i() > 0 && !ToolHelper.isBroken(itemStack);
    }

    private int getDurabilityPerXP(ItemStack itemStack) {
        return 2 + ModifierTagHolder.getModifier((ItemStack)itemStack, (String)this.getModifierIdentifier()).getTagData(Data.class).level;
    }

    private int getMaxXp(int level) {
        if (level <= 1) {
            return 100;
        }
        return this.getMaxXp(level - 1) * 3;
    }

    private boolean canStoreXp(Data data) {
        return data.storedXp < this.getMaxXp(data.level);
    }

    private int storeXp(int amount, ItemStack itemStack) {
        ModifierTagHolder modtag = ModifierTagHolder.getModifier(itemStack, this.getModifierIdentifier());
        Data data = modtag.getTagData(Data.class);
        int change = 0;
        if (this.canStoreXp(data)) {
            int max = this.getMaxXp(data.level);
            change = Math.min(amount, max - data.storedXp);
            data.storedXp += change;
            modtag.save();
        }
        return change;
    }

    private boolean useXp(ItemStack itemStack, World world) {
        ModifierTagHolder modtag = ModifierTagHolder.getModifier(itemStack, this.getModifierIdentifier());
        Data data = modtag.getTagData(Data.class);
        if (data.storedXp > 0 && world.func_82737_E() - data.lastHeal > 150L) {
            --data.storedXp;
            data.lastHeal = world.func_82737_E();
            modtag.save();
            return true;
        }
        return false;
    }

    @Override
    public List<String> getExtraInfo(ItemStack tool, NBTTagCompound modifierTag) {
        Data data = ModifierNBT.readTag(modifierTag, Data.class);
        String loc = String.format("modifier.%s.extra", this.getIdentifier());
        return ImmutableList.of((Object)Util.translateFormatted(loc, data.storedXp));
    }

    public static class Data
    extends ModifierNBT {
        public int storedXp;
        public long lastHeal;

        @Override
        public void read(NBTTagCompound tag) {
            super.read(tag);
            this.storedXp = tag.func_74762_e(ModMendingMoss.TAG_STORED_XP);
            this.lastHeal = tag.func_74763_f(ModMendingMoss.TAG_LAST_HEAL);
        }

        @Override
        public void write(NBTTagCompound tag) {
            super.write(tag);
            tag.func_74768_a(ModMendingMoss.TAG_STORED_XP, this.storedXp);
            tag.func_74772_a(ModMendingMoss.TAG_LAST_HEAL, this.lastHeal);
        }
    }
}

