/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.tools;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import gnu.trove.set.hash.THashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.Stack;
import javax.annotation.Nonnull;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import slimeknights.tconstruct.library.client.particle.Particles;
import slimeknights.tconstruct.library.events.TinkerToolEvent;
import slimeknights.tconstruct.library.materials.ExtraMaterialStats;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.AoeToolCore;
import slimeknights.tconstruct.library.tools.ToolNBT;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.tools.TinkerTools;

public class LumberAxe
extends AoeToolCore {
    public static final ImmutableSet<Material> effective_materials = ImmutableSet.of((Object)Material.field_151575_d, (Object)Material.field_151572_C, (Object)Material.field_151570_A);
    public static final float DURABILITY_MODIFIER = 2.0f;

    public LumberAxe() {
        super(PartMaterialType.handle(TinkerTools.toughToolRod), PartMaterialType.head(TinkerTools.broadAxeHead), PartMaterialType.head(TinkerTools.largePlate), PartMaterialType.extra(TinkerTools.toughBinding));
        this.addCategory(Category.HARVEST);
        this.setHarvestLevel("axe", 0);
    }

    @Override
    public void func_150895_a(@Nonnull Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        this.addDefaultSubItems(subItems, new slimeknights.tconstruct.library.materials.Material[0]);
        this.addInfiTool(subItems, "InfiChopper");
    }

    @Override
    public float miningSpeedModifier() {
        return 0.35f;
    }

    @Override
    public float damagePotential() {
        return 1.2f;
    }

    @Override
    public double attackSpeed() {
        return 0.8f;
    }

    @Override
    public boolean isEffective(IBlockState state) {
        return effective_materials.contains((Object)state.func_185904_a()) || ItemAxe.field_150917_c.contains(state.func_177230_c());
    }

    @Override
    public float knockback() {
        return 1.5f;
    }

    @Override
    public boolean dealDamage(ItemStack stack, EntityLivingBase player, Entity entity, float damage) {
        boolean hit = super.dealDamage(stack, player, entity, damage);
        if (hit && this.readyForSpecialAttack(player)) {
            TinkerTools.proxy.spawnAttackParticle(Particles.LUMBERAXE_ATTACK, (Entity)player, 0.8);
        }
        return hit;
    }

    @Override
    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        if (!ToolHelper.isBroken(itemstack) && ToolHelper.isToolEffective2(itemstack, player.func_130014_f_().func_180495_p(pos)) && LumberAxe.detectTree(player.func_130014_f_(), pos)) {
            return LumberAxe.fellTree(itemstack, pos, player);
        }
        return super.onBlockStartBreak(itemstack, pos, player);
    }

    @Override
    public ImmutableList<BlockPos> getAOEBlocks(ItemStack stack, World world, EntityPlayer player, BlockPos origin) {
        if (!ToolHelper.isToolEffective2(stack, world.func_180495_p(origin))) {
            return ImmutableList.of();
        }
        return ToolHelper.calcAOEBlocks(stack, world, player, origin, 3, 3, 3);
    }

    @Override
    public int[] getRepairParts() {
        return new int[]{1, 2};
    }

    @Override
    public float getRepairModifierForPart(int index) {
        return index == 1 ? 2.0f : 1.25f;
    }

    @Override
    public ToolNBT buildTagData(List<slimeknights.tconstruct.library.materials.Material> materials) {
        HandleMaterialStats handle = (HandleMaterialStats)materials.get(0).getStatsOrUnknown("handle");
        HeadMaterialStats head = (HeadMaterialStats)materials.get(1).getStatsOrUnknown("head");
        HeadMaterialStats plate = (HeadMaterialStats)materials.get(2).getStatsOrUnknown("head");
        ExtraMaterialStats binding = (ExtraMaterialStats)materials.get(3).getStatsOrUnknown("extra");
        ToolNBT data = new ToolNBT();
        data.head(head, plate);
        data.extra(binding);
        data.handle(handle);
        data.attack += 2.0f;
        data.durability = (int)((float)data.durability * 2.0f);
        return data;
    }

    public static boolean detectTree(World world, BlockPos origin) {
        BlockPos pos = null;
        Stack<BlockPos> candidates = new Stack<BlockPos>();
        candidates.add(origin);
        while (!candidates.isEmpty()) {
            BlockPos candidate = (BlockPos)candidates.pop();
            if (pos != null && candidate.func_177956_o() <= pos.func_177956_o() || !LumberAxe.isLog(world, candidate)) continue;
            pos = candidate.func_177984_a();
            while (LumberAxe.isLog(world, pos)) {
                pos = pos.func_177984_a();
            }
            candidates.add(pos.func_177978_c());
            candidates.add(pos.func_177974_f());
            candidates.add(pos.func_177968_d());
            candidates.add(pos.func_177976_e());
        }
        if (pos == null) {
            return false;
        }
        int d = 3;
        int o = -1;
        int leaves = 0;
        for (int x = 0; x < d; ++x) {
            for (int y = 0; y < d; ++y) {
                for (int z = 0; z < d; ++z) {
                    BlockPos leaf = pos.func_177982_a(o + x, o + y, o + z);
                    IBlockState state = world.func_180495_p(leaf);
                    if (!state.func_177230_c().isLeaves(state, (IBlockAccess)world, leaf) || ++leaves < 5) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isLog(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c().isWood((IBlockAccess)world, pos);
    }

    public static boolean fellTree(ItemStack itemstack, BlockPos start, EntityPlayer player) {
        if (player.func_130014_f_().field_72995_K) {
            return true;
        }
        TinkerToolEvent.ExtraBlockBreak event = TinkerToolEvent.ExtraBlockBreak.fireEvent(itemstack, player, player.func_130014_f_().func_180495_p(start), 3, 3, 3, -1);
        int speed = Math.round((float)(event.width * event.height * event.depth) / 27.0f);
        if (event.distance > 0) {
            speed = event.distance + 1;
        }
        MinecraftForge.EVENT_BUS.register((Object)new TreeChopTask(itemstack, start, player, speed));
        return true;
    }

    public static class TreeChopTask {
        public final World world;
        public final EntityPlayer player;
        public final ItemStack tool;
        public final int blocksPerTick;
        public Queue<BlockPos> blocks = Lists.newLinkedList();
        public Set<BlockPos> visited = new THashSet();

        public TreeChopTask(ItemStack tool, BlockPos start, EntityPlayer player, int blocksPerTick) {
            this.world = player.func_130014_f_();
            this.player = player;
            this.tool = tool;
            this.blocksPerTick = blocksPerTick;
            this.blocks.add(start);
        }

        @SubscribeEvent
        public void chopChop(TickEvent.WorldTickEvent event) {
            if (event.side.isClient()) {
                this.finish();
                return;
            }
            if (event.world.field_73011_w.getDimension() != this.world.field_73011_w.getDimension()) {
                return;
            }
            int left = this.blocksPerTick;
            while (left > 0) {
                if (this.blocks.isEmpty() || ToolHelper.isBroken(this.tool)) {
                    this.finish();
                    return;
                }
                BlockPos pos = this.blocks.remove();
                if (!this.visited.add(pos) || !LumberAxe.isLog(this.world, pos) || !ToolHelper.isToolEffective2(this.tool, this.world.func_180495_p(pos))) continue;
                for (EnumFacing facing : new EnumFacing[]{EnumFacing.NORTH, EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.WEST}) {
                    BlockPos pos2 = pos.func_177972_a(facing);
                    if (this.visited.contains(pos2)) continue;
                    this.blocks.add(pos2);
                }
                for (int x = 0; x < 3; ++x) {
                    for (int z = 0; z < 3; ++z) {
                        BlockPos pos2 = pos.func_177982_a(-1 + x, 1, -1 + z);
                        if (this.visited.contains(pos2)) continue;
                        this.blocks.add(pos2);
                    }
                }
                ToolHelper.breakExtraBlock(this.tool, this.world, this.player, pos, pos);
                --left;
            }
        }

        private void finish() {
            MinecraftForge.EVENT_BUS.unregister((Object)this);
        }
    }
}

