/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.experimental;

import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.coroutines.experimental.Continuation;
import kotlin.coroutines.experimental.CoroutineContext;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.experimental.CancellableContinuation;
import kotlinx.coroutines.experimental.CoroutineDispatcher;
import kotlinx.coroutines.experimental.Delay;
import kotlinx.coroutines.experimental.DisposableHandle;
import kotlinx.coroutines.experimental.EventLoop;
import kotlinx.coroutines.experimental.Job;
import kotlinx.coroutines.experimental.ResumeRunnable;
import kotlinx.coroutines.experimental.ScheduledKt;
import kotlinx.coroutines.experimental.internal.LockFreeLinkedListHead;
import kotlinx.coroutines.experimental.internal.LockFreeLinkedListKt;
import kotlinx.coroutines.experimental.internal.LockFreeLinkedListNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u0005*+,-.B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u000e\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\rJ \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u001e\u001a\u00020\u001bH\u0016J\u0014\u0010\u001f\u001a\u00020 2\n\u0010!\u001a\u00060\tR\u00020\u0000H\u0002J\u0010\u0010\"\u001a\u00020 2\u0006\u0010#\u001a\u00020$H\u0002J&\u0010%\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00110'H\u0016J\u0006\u0010(\u001a\u00020\u0011J\b\u0010)\u001a\u00020\u0011H\u0002R\"\u0010\u0007\u001a\u0016\u0012\b\u0012\u00060\tR\u00020\u0000\u0012\b\u0012\u00060\tR\u00020\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lkotlinx/coroutines/experimental/EventLoopImpl;", "Lkotlinx/coroutines/experimental/CoroutineDispatcher;", "Lkotlinx/coroutines/experimental/EventLoop;", "Lkotlinx/coroutines/experimental/Delay;", "thread", "Ljava/lang/Thread;", "(Ljava/lang/Thread;)V", "delayed", "Ljava/util/concurrent/ConcurrentSkipListMap;", "Lkotlinx/coroutines/experimental/EventLoopImpl$DelayedTask;", "nextSequence", "Ljava/util/concurrent/atomic/AtomicLong;", "parentJob", "Lkotlinx/coroutines/experimental/Job;", "queue", "Lkotlinx/coroutines/experimental/internal/LockFreeLinkedListHead;", "dispatch", "", "context", "Lkotlin/coroutines/experimental/CoroutineContext;", "block", "Ljava/lang/Runnable;", "initParentJob", "coroutine", "invokeOnTimeout", "Lkotlinx/coroutines/experimental/DisposableHandle;", "time", "", "unit", "Ljava/util/concurrent/TimeUnit;", "processNextEvent", "scheduleDelayed", "", "delayedTask", "scheduleQueued", "queuedTask", "Lkotlinx/coroutines/experimental/EventLoopImpl$QueuedTask;", "scheduleResumeAfterDelay", "continuation", "Lkotlinx/coroutines/experimental/CancellableContinuation;", "shutdown", "unpark", "DelayedResumeTask", "DelayedRunnableTask", "DelayedTask", "QueuedRunnableTask", "QueuedTask", "kotlinx-coroutines-core"})
public final class EventLoopImpl
extends CoroutineDispatcher
implements EventLoop,
Delay {
    private final LockFreeLinkedListHead queue;
    private final ConcurrentSkipListMap<DelayedTask, DelayedTask> delayed;
    private final AtomicLong nextSequence;
    private Job parentJob;
    private final Thread thread;

    public final void initParentJob(@NotNull Job coroutine) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(coroutine, "coroutine");
        boolean bl2 = bl = this.parentJob == null;
        if (!bl) {
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.parentJob = coroutine;
    }

    @Override
    public void dispatch(@NotNull CoroutineContext context, @NotNull Runnable block) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(block, "block");
        if (this.scheduleQueued(new QueuedRunnableTask(block))) {
            this.unpark();
        } else {
            block.run();
        }
    }

    @Override
    public void scheduleResumeAfterDelay(long time, @NotNull TimeUnit unit, @NotNull CancellableContinuation<? super Unit> continuation2) {
        Intrinsics.checkParameterIsNotNull((Object)unit, "unit");
        Intrinsics.checkParameterIsNotNull(continuation2, "continuation");
        if (this.scheduleDelayed(new DelayedResumeTask(time, unit, continuation2))) {
            this.unpark();
        } else {
            ScheduledKt.getScheduledExecutor().schedule(new ResumeRunnable((Continuation<? super Unit>)continuation2), time, unit);
        }
    }

    @Override
    @NotNull
    public DisposableHandle invokeOnTimeout(long time, @NotNull TimeUnit unit, @NotNull Runnable block) {
        DelayedRunnableTask delayedRunnableTask;
        Intrinsics.checkParameterIsNotNull((Object)unit, "unit");
        Intrinsics.checkParameterIsNotNull(block, "block");
        DelayedRunnableTask it = delayedRunnableTask = new DelayedRunnableTask(time, unit, block);
        this.scheduleDelayed(it);
        return delayedRunnableTask;
    }

    @Override
    public long processNextEvent() {
        LockFreeLinkedListNode lockFreeLinkedListNode;
        Object delayedTask;
        Object object;
        if (Thread.currentThread() != this.thread) {
            return Long.MAX_VALUE;
        }
        while ((object = this.delayed.firstEntry()) != null && (object = object.getKey()) != null) {
            delayedTask = object;
            long now = System.nanoTime();
            if (((DelayedTask)delayedTask).nanoTime - now > (long)0 || !this.scheduleQueued((QueuedTask)delayedTask)) break;
            this.delayed.remove(delayedTask);
        }
        if (!((lockFreeLinkedListNode = this.queue.removeFirstOrNull()) instanceof QueuedTask)) {
            lockFreeLinkedListNode = null;
        }
        QueuedTask queuedTask = (QueuedTask)lockFreeLinkedListNode;
        if (queuedTask != null) {
            Object queuedTask2 = delayedTask = queuedTask;
            queuedTask2.invoke();
        }
        if (!this.queue.isEmpty()) {
            return 0L;
        }
        Map.Entry<DelayedTask, DelayedTask> entry = this.delayed.firstEntry();
        if (entry == null || (entry = entry.getKey()) == null) {
            return Long.MAX_VALUE;
        }
        Map.Entry<DelayedTask, DelayedTask> nextDelayedTask = entry;
        return ((DelayedTask)((Object)nextDelayedTask)).nanoTime - System.nanoTime();
    }

    public final void shutdown() {
        Object object;
        while (true) {
            LockFreeLinkedListNode lockFreeLinkedListNode = this.queue.removeFirstOrNull();
            if (lockFreeLinkedListNode == null) {
                break;
            }
            if (lockFreeLinkedListNode == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlinx.coroutines.experimental.EventLoopImpl.QueuedTask");
            }
            QueuedTask queuedTask = (QueuedTask)lockFreeLinkedListNode;
            queuedTask.invoke();
        }
        while ((object = this.delayed.pollFirstEntry()) != null && (object = object.getKey()) != null) {
            Object delayedTask = object;
            ((DelayedTask)delayedTask).cancel();
        }
    }

    private final boolean scheduleQueued(QueuedTask queuedTask) {
        boolean bl;
        LockFreeLinkedListHead this_$iv;
        if (this.parentJob == null) {
            this.queue.addLast(queuedTask);
            return true;
        }
        LockFreeLinkedListHead this_$iv$iv = this_$iv = this.queue;
        LockFreeLinkedListNode.CondAddOp condAdd$iv = new LockFreeLinkedListNode.CondAddOp(queuedTask, queuedTask, this){
            final /* synthetic */ LockFreeLinkedListNode $node;
            final /* synthetic */ EventLoopImpl this$0;
            {
                this.$node = $captured_local_variable$1;
                this.this$0 = eventLoopImpl;
                super($super_call_param$2);
            }

            public Object prepare() {
                Job job = EventLoopImpl.access$getParentJob$p(this.this$0);
                if (job == null) {
                    Intrinsics.throwNpe();
                }
                return !job.isCompleted() ? null : LockFreeLinkedListKt.getCONDITION_FALSE();
            }
        };
        block4: while (true) {
            Object object = this_$iv.getPrev();
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlinx.coroutines.experimental.internal.Node /* = kotlinx.coroutines.experimental.internal.LockFreeLinkedListNode */");
            }
            LockFreeLinkedListNode prev$iv = (LockFreeLinkedListNode)object;
            switch (prev$iv.tryCondAddNext(queuedTask, this_$iv, condAdd$iv)) {
                case 1: {
                    bl = true;
                    break block4;
                }
                case 2: {
                    bl = false;
                    break block4;
                }
                default: {
                    continue block4;
                }
            }
            break;
        }
        return bl;
    }

    private final boolean scheduleDelayed(DelayedTask delayedTask) {
        this.delayed.put(delayedTask, delayedTask);
        Job job = this.parentJob;
        if (Intrinsics.areEqual(job != null ? Boolean.valueOf(job.isActive()) : null, false) ^ true) {
            return true;
        }
        delayedTask.dispose();
        return false;
    }

    private final void unpark() {
        if (Thread.currentThread() != this.thread) {
            LockSupport.unpark(this.thread);
        }
    }

    public EventLoopImpl(@NotNull Thread thread2) {
        Intrinsics.checkParameterIsNotNull(thread2, "thread");
        this.thread = thread2;
        this.queue = new LockFreeLinkedListHead();
        this.delayed = new ConcurrentSkipListMap();
        this.nextSequence = new AtomicLong();
    }

    @Override
    @Nullable
    public Object delay(long time, @NotNull TimeUnit unit, @NotNull Continuation<? super Unit> $continuation) {
        Intrinsics.checkParameterIsNotNull((Object)unit, "unit");
        Intrinsics.checkParameterIsNotNull($continuation, "$continuation");
        return Delay.DefaultImpls.delay(this, time, unit, $continuation);
    }

    @Nullable
    public static final /* synthetic */ Job access$getParentJob$p(EventLoopImpl $this) {
        return $this.parentJob;
    }

    public static final /* synthetic */ void access$setParentJob$p(EventLoopImpl $this, @Nullable Job job) {
        $this.parentJob = job;
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\"\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u0005\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lkotlinx/coroutines/experimental/EventLoopImpl$QueuedTask;", "Lkotlinx/coroutines/experimental/internal/LockFreeLinkedListNode;", "Lkotlin/Function0;", "", "()V", "kotlinx-coroutines-core"})
    private static abstract class QueuedTask
    extends LockFreeLinkedListNode
    implements Function0<Unit> {
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0005\u001a\u00020\u0006H\u0096\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lkotlinx/coroutines/experimental/EventLoopImpl$QueuedRunnableTask;", "Lkotlinx/coroutines/experimental/EventLoopImpl$QueuedTask;", "block", "Ljava/lang/Runnable;", "(Ljava/lang/Runnable;)V", "invoke", "", "kotlinx-coroutines-core"})
    private static final class QueuedRunnableTask
    extends QueuedTask {
        private final Runnable block;

        @Override
        public void invoke() {
            this.block.run();
        }

        public QueuedRunnableTask(@NotNull Runnable block) {
            Intrinsics.checkParameterIsNotNull(block, "block");
            this.block = block;
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u00a2\u0004\u0018\u00002\u00020\u00012\f\u0012\b\u0012\u00060\u0000R\u00020\u00030\u00022\u00020\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\f\u001a\u00020\rH\u0016J\u0015\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u00060\u0000R\u00020\u0003H\u0096\u0002J\u0006\u0010\u0011\u001a\u00020\rR\u0010\u0010\n\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lkotlinx/coroutines/experimental/EventLoopImpl$DelayedTask;", "Lkotlinx/coroutines/experimental/EventLoopImpl$QueuedTask;", "", "Lkotlinx/coroutines/experimental/EventLoopImpl;", "Lkotlinx/coroutines/experimental/DisposableHandle;", "time", "", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "(Lkotlinx/coroutines/experimental/EventLoopImpl;JLjava/util/concurrent/TimeUnit;)V", "nanoTime", "sequence", "cancel", "", "compareTo", "", "other", "dispose", "kotlinx-coroutines-core"})
    private abstract class DelayedTask
    extends QueuedTask
    implements Comparable<DelayedTask>,
    DisposableHandle {
        @JvmField
        public final long nanoTime;
        @JvmField
        public final long sequence;

        @Override
        public int compareTo(@NotNull DelayedTask other) {
            Intrinsics.checkParameterIsNotNull(other, "other");
            long dTime = this.nanoTime - other.nanoTime;
            if (dTime > (long)0) {
                return 1;
            }
            if (dTime < (long)0) {
                return -1;
            }
            long dSequence = this.sequence - other.sequence;
            return dSequence > (long)0 ? 1 : (dSequence < (long)0 ? -1 : 0);
        }

        @Override
        public final void dispose() {
            EventLoopImpl.this.delayed.remove(this);
            this.cancel();
        }

        public void cancel() {
        }

        public DelayedTask(@NotNull long time, TimeUnit timeUnit) {
            Intrinsics.checkParameterIsNotNull((Object)timeUnit, "timeUnit");
            this.nanoTime = System.nanoTime() + timeUnit.toNanos(time);
            this.sequence = EventLoopImpl.this.nextSequence.getAndIncrement();
        }

        @Override
        @Deprecated(message="Replace with `dispose`", replaceWith=@ReplaceWith(expression="dispose()", imports={}))
        public void unregister() {
            DisposableHandle.DefaultImpls.unregister(this);
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\tH\u0016J\t\u0010\f\u001a\u00020\tH\u0096\u0002R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lkotlinx/coroutines/experimental/EventLoopImpl$DelayedResumeTask;", "Lkotlinx/coroutines/experimental/EventLoopImpl$DelayedTask;", "Lkotlinx/coroutines/experimental/EventLoopImpl;", "time", "", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "cont", "Lkotlinx/coroutines/experimental/CancellableContinuation;", "", "(Lkotlinx/coroutines/experimental/EventLoopImpl;JLjava/util/concurrent/TimeUnit;Lkotlinx/coroutines/experimental/CancellableContinuation;)V", "cancel", "invoke", "kotlinx-coroutines-core"})
    private final class DelayedResumeTask
    extends DelayedTask {
        private final CancellableContinuation<Unit> cont;

        @Override
        public void invoke() {
            CancellableContinuation<Unit> cancellableContinuation;
            CancellableContinuation<Unit> $receiver = cancellableContinuation = this.cont;
            $receiver.resumeUndispatched(EventLoopImpl.this, Unit.INSTANCE);
        }

        @Override
        public void cancel() {
            if (!this.cont.isActive()) {
                return;
            }
            long remaining = this.nanoTime - System.nanoTime();
            ScheduledKt.getScheduledExecutor().schedule(new ResumeRunnable((Continuation<? super Unit>)this.cont), remaining, TimeUnit.NANOSECONDS);
        }

        public DelayedResumeTask(@NotNull long time, @NotNull TimeUnit timeUnit, CancellableContinuation<? super Unit> cont) {
            Intrinsics.checkParameterIsNotNull((Object)timeUnit, "timeUnit");
            Intrinsics.checkParameterIsNotNull(cont, "cont");
            super(time, timeUnit);
            this.cont = cont;
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\n\u001a\u00020\u000bH\u0096\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lkotlinx/coroutines/experimental/EventLoopImpl$DelayedRunnableTask;", "Lkotlinx/coroutines/experimental/EventLoopImpl$DelayedTask;", "Lkotlinx/coroutines/experimental/EventLoopImpl;", "time", "", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "block", "Ljava/lang/Runnable;", "(Lkotlinx/coroutines/experimental/EventLoopImpl;JLjava/util/concurrent/TimeUnit;Ljava/lang/Runnable;)V", "invoke", "", "kotlinx-coroutines-core"})
    private final class DelayedRunnableTask
    extends DelayedTask {
        private final Runnable block;

        @Override
        public void invoke() {
            this.block.run();
        }

        public DelayedRunnableTask(@NotNull long time, @NotNull TimeUnit timeUnit, Runnable block) {
            Intrinsics.checkParameterIsNotNull((Object)timeUnit, "timeUnit");
            Intrinsics.checkParameterIsNotNull(block, "block");
            super(time, timeUnit);
            this.block = block;
        }
    }
}

