/*
 * Decompiled with CFR 0.152.
 */
package tonius.simplyjetpacks.gui;

import cofh.api.energy.EnergyStorage;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tonius.simplyjetpacks.item.ItemPack;
import tonius.simplyjetpacks.item.meta.PackBase;

public class ContainerPack
extends Container {
    public final ItemStack chestplate;
    public final ItemPack packItem;
    public final PackBase pack;
    public final EnergyStorage energyStored;
    public final FluidTank fluidStored;
    private int lastFuel;
    private Short fuelFirstHalf = null;
    private Short fuelSecondHalf = null;

    public ContainerPack(ItemStack chestplate, ItemPack packItem, PackBase pack) {
        this.chestplate = chestplate;
        this.packItem = packItem;
        this.pack = pack;
        int fuel = packItem.getFuelStored(chestplate);
        int maxFuel = pack.tier > 9000 ? -1 : packItem.getMaxFuelStored(chestplate);
        switch (pack.fuelType) {
            case ENERGY: {
                this.energyStored = new EnergyStorage(maxFuel);
                this.energyStored.setEnergyStored(fuel);
                this.fluidStored = null;
                break;
            }
            case FLUID: {
                this.energyStored = null;
                this.fluidStored = new FluidTank(FluidRegistry.getFluid((String)pack.fuelFluid), fuel, maxFuel);
                break;
            }
            default: {
                this.energyStored = null;
                this.fluidStored = null;
            }
        }
        this.lastFuel = fuel;
    }

    public boolean func_75145_c(EntityPlayer player) {
        return new InventoryPlayer(player).func_70440_f(2) == this.chestplate;
    }

    public void func_75142_b() {
        super.func_75142_b();
        int fuel = this.packItem.getFuelStored(this.chestplate);
        if (fuel != this.lastFuel) {
            for (int i = 0; i < this.field_75149_d.size(); ++i) {
                ((IContainerListener)this.field_75149_d.get(i)).func_71112_a((Container)this, 0, (int)((short)(fuel >> 16)));
                ((IContainerListener)this.field_75149_d.get(i)).func_71112_a((Container)this, 1, (int)((short)(fuel & 0xFFFF)));
            }
            this.lastFuel = fuel;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int barId, int value) {
        if (barId == 0) {
            this.fuelFirstHalf = (short)value;
        } else if (barId == 1) {
            this.fuelSecondHalf = (short)value;
        }
        if (this.fuelFirstHalf != null && this.fuelSecondHalf != null) {
            int fuel = this.fuelFirstHalf << 16 | this.fuelSecondHalf & 0xFFFF;
            this.fuelFirstHalf = null;
            this.fuelSecondHalf = null;
            if (this.energyStored != null) {
                this.energyStored.setEnergyStored(fuel);
            } else if (this.fluidStored != null) {
                this.fluidStored.setFluid(new FluidStack(FluidRegistry.getFluid((String)this.pack.fuelFluid), fuel));
            }
        }
    }
}

