/*
 * Decompiled with CFR 0.152.
 */
package tonius.simplyjetpacks.item.meta;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tonius.simplyjetpacks.client.model.PackModelType;
import tonius.simplyjetpacks.handler.SyncHandler;
import tonius.simplyjetpacks.item.ItemPack;
import tonius.simplyjetpacks.item.meta.Jetpack;
import tonius.simplyjetpacks.setup.ModKey;
import tonius.simplyjetpacks.setup.ParticleType;
import tonius.simplyjetpacks.sound.SJSoundRegistry;
import tonius.simplyjetpacks.util.FireworksHelper;
import tonius.simplyjetpacks.util.NBTHelper;
import tonius.simplyjetpacks.util.SJStringHelper;
import tonius.simplyjetpacks.util.math.MathHelper;

public class JetpackPotato
extends Jetpack {
    protected static final String TAG_FIRED = "JetpackPotatoFired";
    protected static final String TAG_ROCKET_TIMER = "JetpackPotatoRocketTimer";
    protected static final String TAG_ROCKET_TIMER_SET = "JetpackPotatoRocketTimerSet";

    public JetpackPotato(int tier, EnumRarity rarity, String defaultConfigKey) {
        super(tier, rarity, defaultConfigKey);
        this.setHasStateIndicators(false);
        this.setShowEmptyInCreativeTab(false);
        this.setArmorModel(PackModelType.FLAT);
    }

    @Override
    public void flyUser(EntityPlayer user, ItemStack stack, ItemPack item, boolean force) {
        if (this.isFired(stack)) {
            super.flyUser(user, stack, item, true);
            user.field_70759_as += 37.5f;
            if (item.getFuelStored(stack) <= 0) {
                user.func_184201_a(EntityEquipmentSlot.CHEST, null);
                if (!user.field_70170_p.field_72995_K) {
                    user.field_70170_p.func_72876_a((Entity)user, user.field_70165_t, user.field_70163_u, user.field_70161_v, 4.0f, false);
                    for (int i = 0; i <= MathHelper.RANDOM.nextInt(3) + 4; ++i) {
                        ItemStack firework = FireworksHelper.getRandomFireworks(0, 1, MathHelper.RANDOM.nextInt(6) + 1, 1);
                        user.field_70170_p.func_72838_d((Entity)new EntityFireworkRocket(user.field_70170_p, user.field_70165_t + MathHelper.RANDOM.nextDouble() * 6.0 - 3.0, user.field_70163_u, user.field_70161_v + MathHelper.RANDOM.nextDouble() * 6.0 - 3.0, firework));
                    }
                    user.func_70097_a((DamageSource)new EntityDamageSource("jetpackpotato", (Entity)user), 100.0f);
                    if (user instanceof EntityPlayer) {
                        user.func_145779_a(Items.field_151168_bH, 1);
                    }
                }
            }
        } else if (force || SyncHandler.isFlyKeyDown((EntityLivingBase)user)) {
            if (this.isTimerSet(stack)) {
                this.decrementTimer(stack, user);
            } else {
                this.setTimer(stack, 50);
            }
        }
    }

    @Override
    public boolean isOn(ItemStack stack) {
        return true;
    }

    @Override
    public boolean isHoverModeOn(ItemStack stack) {
        return false;
    }

    @Override
    public void togglePrimary(ItemStack stack, EntityPlayer player, boolean showInChat) {
    }

    @Override
    public void switchModePrimary(ItemStack stack, EntityPlayer player, boolean showInChat) {
    }

    @Override
    public ModKey[] getGuiControls() {
        return new ModKey[0];
    }

    @Override
    public ParticleType getDisplayParticleType(ItemStack itemStack, ItemPack item, EntityLivingBase user) {
        if (!this.isFired(itemStack) && SyncHandler.isFlyKeyDown(user)) {
            return user.func_70681_au().nextInt(5) == 0 ? ParticleType.SMOKE : null;
        }
        if (this.isFired(itemStack)) {
            return this.getParticleType(itemStack);
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addShiftInformation(ItemStack stack, ItemPack item, EntityPlayer player, List list) {
        super.addShiftInformation(stack, item, player, list);
        list.add("\u00a7c\u00a7o" + SJStringHelper.localize("tooltip.jetpackPotato.warning", new Object[0]));
    }

    protected boolean isFired(ItemStack stack) {
        return NBTHelper.getBoolean(stack, TAG_FIRED);
    }

    protected void setFired(ItemStack stack) {
        NBTHelper.setBoolean(stack, TAG_FIRED, true);
    }

    protected void setTimer(ItemStack stack, int timer) {
        NBTHelper.setInt(stack, TAG_ROCKET_TIMER, timer);
        NBTHelper.setBoolean(stack, TAG_ROCKET_TIMER_SET, true);
    }

    protected boolean isTimerSet(ItemStack stack) {
        return NBTHelper.getBoolean(stack, TAG_ROCKET_TIMER_SET);
    }

    protected void decrementTimer(ItemStack stack, EntityPlayer user) {
        int timer = NBTHelper.getInt(stack, TAG_ROCKET_TIMER);
        timer = timer > 0 ? timer - 1 : 0;
        NBTHelper.setInt(stack, TAG_ROCKET_TIMER, timer);
        if (timer == 0) {
            this.setFired(stack);
            user.field_70170_p.func_184133_a(user, user.func_180425_c(), SJSoundRegistry.ROCKET.getSoundEvent(), SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
    }
}

