/*
 * Decompiled with CFR 0.152.
 */
package tonius.simplyjetpacks.item.rewrite;

import cofh.api.energy.IEnergyContainerItem;
import java.util.List;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tonius.simplyjetpacks.SimplyJetpacks;
import tonius.simplyjetpacks.capability.CapabilityProviderEnergy;
import tonius.simplyjetpacks.capability.EnergyConversionStorage;
import tonius.simplyjetpacks.client.model.PackModelType;
import tonius.simplyjetpacks.client.util.RenderUtils;
import tonius.simplyjetpacks.config.Config;
import tonius.simplyjetpacks.item.IHUDInfoProvider;
import tonius.simplyjetpacks.item.rewrite.Fluxpack;
import tonius.simplyjetpacks.setup.FuelType;
import tonius.simplyjetpacks.setup.ModCreativeTab;
import tonius.simplyjetpacks.setup.ModEnchantments;
import tonius.simplyjetpacks.setup.ModItems;
import tonius.simplyjetpacks.util.EquipmentSlotHelper;
import tonius.simplyjetpacks.util.NBTHelper;
import tonius.simplyjetpacks.util.SJStringHelper;

public class ItemFluxpack
extends ItemArmor
implements ISpecialArmor,
IEnergyContainerItem,
IHUDInfoProvider {
    public boolean hasFuelIndicator = true;
    public boolean hasStateIndicators = true;
    public FuelType fuelType = FuelType.ENERGY;
    public boolean isFluxBased = false;
    public boolean showTier = true;
    public static final String TAG_ENERGY = "Energy";
    public static final String TAG_ON = "PackOn";
    public String name;
    private final int numItems;

    public ItemFluxpack(String name) {
        super(ItemArmor.ArmorMaterial.IRON, 2, EntityEquipmentSlot.CHEST);
        this.name = name;
        this.func_77655_b("simplyjetpacks." + name);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77637_a(ModCreativeTab.instance);
        this.setRegistryName(name);
        this.numItems = Fluxpack.values().length;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs creativeTabs, List<ItemStack> List2) {
        if (ModItems.integrateEIO) {
            for (Fluxpack pack : Fluxpack.ALL_FLUXPACKS) {
                if (pack.usesFuel) {
                    List2.add(new ItemStack(item, 1, pack.ordinal()));
                    continue;
                }
                ItemStack stack = new ItemStack(item, 1, pack.ordinal());
                if (item instanceof ItemFluxpack) {
                    ((ItemFluxpack)item).addFuel(stack, ((ItemFluxpack)item).getMaxEnergyStored(stack), false);
                }
                List2.add(stack);
            }
        } else {
            Fluxpack pack = Fluxpack.CREATIVE_FLUXPACK;
            if (pack.usesFuel) {
                List2.add(new ItemStack(item, 1, pack.ordinal()));
            } else {
                ItemStack stack = new ItemStack(item, 1, pack.ordinal());
                if (item instanceof ItemFluxpack) {
                    ((ItemFluxpack)item).addFuel(stack, ((ItemFluxpack)item).getMaxEnergyStored(stack), false);
                }
                List2.add(stack);
            }
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        if (this.isOn(stack)) {
            this.chargeInventory((EntityLivingBase)player, stack, this);
        }
    }

    public void toggleState(boolean on, ItemStack stack, String type, String tag, EntityPlayer player, boolean showInChat) {
        NBTHelper.setBoolean(stack, tag, !on);
        if (player != null && showInChat) {
            String color = on ? TextFormatting.RED.toString() : TextFormatting.GREEN.toString();
            type = type != null && !type.equals("") ? "chat." + this.name + "." + type + ".on" : "chat." + this.name + ".on";
            String msg = SJStringHelper.localize(type, new Object[0]) + " " + color + SJStringHelper.localize("chat." + (on ? "disabled" : "enabled"), new Object[0]);
            player.func_145747_a((ITextComponent)new TextComponentString(msg));
        }
    }

    protected void chargeInventory(EntityLivingBase user, ItemStack stack, ItemFluxpack item) {
        int i = MathHelper.func_76125_a((int)stack.func_77952_i(), (int)0, (int)(this.numItems - 1));
        if (this.fuelType == FuelType.ENERGY) {
            for (int j = 0; j <= 5; ++j) {
                ItemStack currentStack = user.func_184582_a(EquipmentSlotHelper.fromSlot(j));
                if (currentStack == null || currentStack == stack || this.getIEnergyStorage(currentStack) == null || !currentStack.hasCapability(CapabilityEnergy.ENERGY, null) && !(currentStack.func_77973_b() instanceof IEnergyContainerItem)) continue;
                if (Fluxpack.values()[i].usesFuel) {
                    int energyToAdd = Math.min(item.useFuel(stack, Fluxpack.values()[i].getFuelPerTickOut(), true), this.getIEnergyStorage(currentStack).receiveEnergy(Fluxpack.values()[i].getFuelPerTickOut(), true));
                    item.useFuel(stack, energyToAdd, false);
                    this.getIEnergyStorage(currentStack).receiveEnergy(energyToAdd, false);
                    continue;
                }
                this.getIEnergyStorage(currentStack).receiveEnergy(Fluxpack.values()[i].getFuelPerTickOut(), false);
            }
        }
    }

    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        this.information(stack, this, tooltip);
        if (SJStringHelper.canShowDetails()) {
            this.shiftInformation(stack, tooltip);
        } else {
            tooltip.add(SJStringHelper.getShiftText());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void information(ItemStack stack, ItemFluxpack item, List list) {
        int i = MathHelper.func_76125_a((int)stack.func_77952_i(), (int)0, (int)(this.numItems - 1));
        if (this.showTier) {
            list.add(SJStringHelper.getTierText(Fluxpack.values()[i].getTier()));
        }
        list.add(SJStringHelper.getFuelText(this.fuelType, item.getFuelStored(stack), Fluxpack.values()[i].getFuelCapacity(), !Fluxpack.values()[i].usesFuel));
    }

    @SideOnly(value=Side.CLIENT)
    public void shiftInformation(ItemStack stack, List list) {
        int i = MathHelper.func_76125_a((int)stack.func_77952_i(), (int)0, (int)(this.numItems - 1));
        list.add(SJStringHelper.getStateText(this.isOn(stack)));
        list.add(SJStringHelper.getEnergySendText(Fluxpack.values()[i].getFuelPerTickOut()));
        if (Fluxpack.values()[i].getFuelPerTickIn() > 0) {
            list.add(SJStringHelper.getEnergyReceiveText(Fluxpack.values()[i].getFuelPerTickIn()));
        }
        SJStringHelper.addDescriptionLines(list, "fluxpack", TextFormatting.GREEN.toString());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addHUDInfo(List<String> list, ItemStack stack, boolean showFuel, boolean showState) {
        if (showFuel && this.hasFuelIndicator) {
            list.add(this.getHUDFuelInfo(stack, this));
        }
        if (showState && this.hasStateIndicators) {
            list.add(this.getHUDStatesInfo(stack));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public String getHUDFuelInfo(ItemStack stack, ItemFluxpack item) {
        int fuel = item.getFuelStored(stack);
        int maxFuel = item.getMaxFuelStored(stack);
        int percent = (int)Math.ceil((double)fuel / (double)maxFuel * 100.0);
        return SJStringHelper.getHUDFuelText(this.name, percent, this.fuelType, fuel);
    }

    @SideOnly(value=Side.CLIENT)
    public String getHUDStatesInfo(ItemStack stack) {
        return SJStringHelper.getHUDStateText(this.isOn(stack), null, null);
    }

    public boolean isOn(ItemStack stack) {
        return NBTHelper.getBooleanFallback(stack, TAG_ON, true);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        int i = MathHelper.func_76125_a((int)stack.func_77952_i(), (int)0, (int)(this.numItems - 1));
        if (Fluxpack.values()[i].getRarity() != null) {
            return Fluxpack.values()[i].getRarity();
        }
        return super.func_77613_e(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        int i = MathHelper.func_76125_a((int)stack.func_77952_i(), (int)0, (int)(this.numItems - 1));
        if (!Fluxpack.values()[i].usesFuel) {
            return false;
        }
        return this.hasFuelIndicator;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        double stored = this.getMaxFuelStored(stack) - this.getFuelStored(stack) + 1;
        double max = this.getMaxFuelStored(stack) + 1;
        return stored / max;
    }

    public String func_77667_c(ItemStack itemStack) {
        int i = MathHelper.func_76125_a((int)itemStack.func_77952_i(), (int)0, (int)(this.numItems - 1));
        return Fluxpack.values()[i].unlocalisedName;
    }

    public int getFuelStored(ItemStack stack) {
        return this.getEnergyStored(stack);
    }

    public int getMaxFuelStored(ItemStack stack) {
        return this.getMaxEnergyStored(stack);
    }

    public int addFuel(ItemStack stack, int maxAdd, boolean simulate) {
        return this.receiveEnergy(stack, maxAdd, simulate);
    }

    public int useFuel(ItemStack stack, int maxUse, boolean simulate) {
        return this.extractEnergy(stack, maxUse, simulate);
    }

    @Override
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        int i = MathHelper.func_76125_a((int)container.func_77952_i(), (int)0, (int)(this.numItems - 1));
        int energy = this.getEnergyStored(container);
        int energyReceived = Math.min(this.getMaxEnergyStored(container) - energy, Math.min(maxReceive, Fluxpack.values()[i].getFuelPerTickIn()));
        if (!simulate) {
            NBTHelper.setInt(container, TAG_ENERGY, energy += energyReceived);
        }
        return energyReceived;
    }

    @Override
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        int i = MathHelper.func_76125_a((int)container.func_77952_i(), (int)0, (int)(this.numItems - 1));
        int energy = this.getEnergyStored(container);
        int energyExtracted = Math.min(energy, Math.min(maxExtract, Fluxpack.values()[i].getFuelPerTickOut()));
        if (!simulate) {
            NBTHelper.setInt(container, TAG_ENERGY, energy -= energyExtracted);
        }
        return energyExtracted;
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        int i = MathHelper.func_76125_a((int)container.func_77952_i(), (int)0, (int)(this.numItems - 1));
        return Fluxpack.values()[i].getFuelCapacity();
    }

    @Override
    public int getEnergyStored(ItemStack container) {
        return NBTHelper.getInt(container, TAG_ENERGY);
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        int i = MathHelper.func_76125_a((int)armor.func_77952_i(), (int)0, (int)(this.numItems - 1));
        if (Fluxpack.values()[i].getIsArmored() && !source.func_76363_c()) {
            if (this.isFluxBased && source.field_76373_n.equals("flux")) {
                return new ISpecialArmor.ArmorProperties(0, 0.5, Integer.MAX_VALUE);
            }
            int energyPerDamage = this.getFuelPerDamage(armor);
            int maxAbsorbed = energyPerDamage > 0 ? 25 * (this.getFuelStored(armor) / energyPerDamage) : 0;
            return new ISpecialArmor.ArmorProperties(0, 0.85 * ((double)Fluxpack.values()[i].getArmorReduction() / 20.0), maxAbsorbed);
        }
        return new ISpecialArmor.ArmorProperties(0, 1.0, 0);
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        int i = MathHelper.func_76125_a((int)armor.func_77952_i(), (int)0, (int)(this.numItems - 1));
        if (Fluxpack.values()[i].getIsArmored() && this.getFuelStored(armor) >= Fluxpack.values()[i].getArmorFuelPerHit()) {
            return Fluxpack.values()[i].getArmorReduction();
        }
        return 0;
    }

    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        ModelBiped model;
        int i = MathHelper.func_76125_a((int)itemStack.func_77952_i(), (int)0, (int)(this.numItems - 1));
        if (Config.enableArmor3DModels && (model = RenderUtils.getArmorModel(Fluxpack.values()[i], entityLiving)) != null) {
            return model;
        }
        return super.getArmorModel(entityLiving, itemStack, armorSlot, _default);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        int i = MathHelper.func_76125_a((int)stack.func_77952_i(), (int)0, (int)(this.numItems - 1));
        String flat = Config.enableArmor3DModels || Fluxpack.values()[i].armorModel == PackModelType.FLAT ? "" : ".flat";
        return "simplyjetpacks:textures/armor/" + Fluxpack.values()[i].getBaseName() + flat + ".png";
    }

    public void damageArmor(EntityLivingBase entity, ItemStack armor, DamageSource source, int damage, int slot) {
        int i = MathHelper.func_76125_a((int)armor.func_77952_i(), (int)0, (int)(this.numItems - 1));
        if (Fluxpack.values()[i].getIsArmored() && Fluxpack.values()[i].usesFuel) {
            if (this.fuelType == FuelType.ENERGY && this.isFluxBased && source.field_76373_n.equals("flux")) {
                this.addFuel(armor, damage * (source.func_76346_g() == null ? Fluxpack.values()[i].getArmorFuelPerHit() / 2 : this.getFuelPerDamage(armor)), false);
            } else {
                this.useFuel(armor, damage * this.getFuelPerDamage(armor), false);
            }
        }
    }

    protected int getFuelPerDamage(ItemStack stack) {
        int i = MathHelper.func_76125_a((int)stack.func_77952_i(), (int)0, (int)(this.numItems - 1));
        if (ModEnchantments.fuelEffeciency == null) {
            return Fluxpack.values()[i].getArmorFuelPerHit();
        }
        int fuelEfficiencyLevel = MathHelper.func_76125_a((int)EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.fuelEffeciency, (ItemStack)stack), (int)0, (int)4);
        return (int)Math.round((double)(Fluxpack.values()[i].getArmorFuelPerHit() * (5 - fuelEfficiencyLevel)) / 5.0);
    }

    public IEnergyStorage getIEnergyStorage(ItemStack chargeItem) {
        if (chargeItem.hasCapability(CapabilityEnergy.ENERGY, null)) {
            return (IEnergyStorage)chargeItem.getCapability(CapabilityEnergy.ENERGY, null);
        }
        if (chargeItem.func_77973_b() instanceof IEnergyContainerItem) {
            return new EnergyConversionStorage((IEnergyContainerItem)chargeItem.func_77973_b(), chargeItem);
        }
        return null;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new CapabilityProviderEnergy<EnergyConversionStorage>(new EnergyConversionStorage(this, stack), CapabilityEnergy.ENERGY, null);
    }

    public void registerItemModel() {
        for (int i = 0; i < this.numItems; ++i) {
            SimplyJetpacks.proxy.registerItemRenderer((Item)this, i, Fluxpack.getTypeFromMeta(i).getBaseName());
        }
    }
}

