/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.capability;

import com.enderio.core.common.util.ItemUtil;
import crazypants.enderio.machine.AbstractInventoryMachineEntity;
import crazypants.enderio.machine.IoMode;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.util.Prep;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.IItemHandler;

public class LegacyMachineWrapper
implements IItemHandler {
    protected final AbstractInventoryMachineEntity machine;
    protected final EnumFacing side;
    protected IoMode lastIoMode = null;
    protected final List<Integer> slots = new ArrayList<Integer>();

    public LegacyMachineWrapper(AbstractInventoryMachineEntity machine, EnumFacing side) {
        this.machine = machine;
        this.side = side;
    }

    protected void computeSlotMappings() {
        IoMode ioMode = this.machine.getIoMode(this.side);
        if (ioMode != this.lastIoMode) {
            this.slots.clear();
            SlotDefinition slotDefinition = this.machine.getSlotDefinition();
            for (int i = 0; i < slotDefinition.getNumSlots(); ++i) {
                if ((!ioMode.canRecieveInput() || !slotDefinition.isInputSlot(i)) && (!ioMode.canOutput() || !slotDefinition.isOutputSlot(i))) continue;
                this.slots.add(i);
            }
            this.lastIoMode = ioMode;
        }
    }

    public int getSlots() {
        this.computeSlotMappings();
        return this.slots.size();
    }

    protected int extSlot2intSlot(int external) {
        this.computeSlotMappings();
        if (external >= 0 && external < this.slots.size()) {
            return this.slots.get(external);
        }
        return -1;
    }

    public ItemStack getStackInSlot(int slot) {
        return this.machine.func_70301_a(this.extSlot2intSlot(slot));
    }

    public ItemStack insertItem(int external, ItemStack stack, boolean simulate) {
        if (Prep.isInvalid(stack) || !this.machine.getIoMode(this.side).canRecieveInput()) {
            return stack;
        }
        int slot = this.extSlot2intSlot(external);
        if (!this.machine.getSlotDefinition().isInputSlot(slot)) {
            return stack;
        }
        return this.doInsertItem(slot, stack, simulate);
    }

    protected ItemStack doInsertItem(int internal, ItemStack stack, boolean simulate) {
        ItemStack existing = this.machine.func_70301_a(internal);
        if (Prep.isValid(existing)) {
            int max = Math.min(existing.func_77976_d(), this.machine.getInventoryStackLimit(internal));
            if (existing.field_77994_a >= max || !ItemUtil.areStackMergable((ItemStack)existing, (ItemStack)stack)) {
                return stack;
            }
            int movable = Math.min(max - existing.field_77994_a, stack.field_77994_a);
            if (!simulate) {
                existing.field_77994_a += movable;
                this.machine.func_70296_d();
            }
            if (movable >= stack.field_77994_a) {
                return Prep.getEmpty();
            }
            ItemStack copy = stack.func_77946_l();
            copy.field_77994_a -= movable;
            return copy;
        }
        if (!this.machine.isMachineItemValidForSlot(internal, stack)) {
            return stack;
        }
        int max = Math.min(stack.func_77976_d(), this.machine.getInventoryStackLimit(internal));
        if (max >= stack.field_77994_a) {
            if (!simulate) {
                this.machine.func_70299_a(internal, stack.func_77946_l());
            }
            return Prep.getEmpty();
        }
        ItemStack copy = stack.func_77946_l();
        copy.field_77994_a = max;
        if (!simulate) {
            this.machine.func_70299_a(internal, copy);
        }
        copy = stack.func_77946_l();
        copy.field_77994_a -= max;
        return copy;
    }

    public ItemStack extractItem(int external, int amount, boolean simulate) {
        if (amount <= 0 || !this.machine.getIoMode(this.side).canOutput()) {
            return Prep.getEmpty();
        }
        int slot = this.extSlot2intSlot(external);
        if (!this.machine.getSlotDefinition().isOutputSlot(slot)) {
            return Prep.getEmpty();
        }
        return this.doExtractItem(slot, amount, simulate);
    }

    protected ItemStack doExtractItem(int internal, int amount, boolean simulate) {
        ItemStack existing = this.machine.func_70301_a(internal);
        if (Prep.isInvalid(existing)) {
            return Prep.getEmpty();
        }
        int max = Math.min(amount, existing.field_77994_a);
        ItemStack copy = existing.func_77946_l();
        copy.field_77994_a = max;
        if (!simulate) {
            existing.field_77994_a -= max;
            if (existing.field_77994_a <= 0) {
                this.machine.func_70299_a(internal, Prep.getEmpty());
            } else {
                this.machine.func_70296_d();
            }
        }
        return copy;
    }
}

