/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.capacitor;

import net.minecraft.util.math.MathHelper;

public interface Scaler {
    public float scaleValue(float var1);

    public static enum Factory implements Scaler
    {
        IDENTITY(new Scaler(){

            @Override
            public float scaleValue(float idx) {
                return Math.max(idx, 0.0f);
            }
        }),
        LINEAR_0_8(new Scaler(){

            @Override
            public float scaleValue(float idx) {
                return MathHelper.func_76131_a((float)idx, (float)0.0f, (float)8.0f);
            }
        }),
        QUADRATIC(new Scaler(){

            @Override
            public float scaleValue(float idx) {
                return (float)Math.pow(2.0, idx - 1.0f);
            }
        }),
        QUADRATIC_1_8(new Scaler(){

            @Override
            public float scaleValue(float idx) {
                return (float)MathHelper.func_151237_a((double)Math.pow(2.0, idx - 1.0f), (double)1.0, (double)8.0);
            }
        }),
        CUBIC(new Scaler(){

            @Override
            public float scaleValue(float idx) {
                return (float)Math.pow(3.0, idx - 1.0f);
            }
        }),
        OCTADIC_1_8(new IndexedScaler(0.5f, 0.0f, 0.5f, 1.0f, 3.0f, 2.0f, 4.0f, 8.0f, 10.0f, 16.0f)),
        POWER(new IndexedScaler(1.0f, 0.0f, 1.0f, 3.0f, 5.0f, 8.0f, 10.0f)),
        SPEED(new IndexedScaler(1.0f, 100.0f, 20.0f, 10.0f, 2.0f, 1.0f)),
        POWER10(new IndexedScaler(1.0f, 0.0f, 1.0f, 2.0f, 10.0f, 20.0f)),
        RANGE(new IndexedScaler(1.0f, 0.0f, 4.0f, 6.0f, 10.0f)),
        FIXED_1(new Scaler(){

            @Override
            public float scaleValue(float idx) {
                return 1.0f;
            }
        }),
        SPAWNER(new IndexedScaler(1.0f, 0.0f, 1.0f, 5.0f, 10.0f, 20.0f)),
        BURNTIME(new IndexedScaler(1.0f, 1.0f, 0.5f, 0.6666667f, 0.6666667f, 0.8f, 1.0f));

        private final Scaler scaler;

        private Factory(Scaler scaler) {
            this.scaler = scaler;
        }

        @Override
        public float scaleValue(float idx) {
            return this.scaler.scaleValue(idx);
        }

        public static String toString(Scaler scaler) {
            if (scaler instanceof Factory) {
                return ((Factory)scaler).name();
            }
            if (scaler instanceof IndexedScaler) {
                return ((IndexedScaler)scaler).store();
            }
            return null;
        }

        public static Scaler fromString(String s) {
            if (s == null) {
                return null;
            }
            if (s.startsWith("idx:")) {
                try {
                    String[] split = s.split(":");
                    float scale = 0.0f;
                    float[] values = new float[split.length - 2];
                    int i = -2;
                    for (String sub : split) {
                        if (i >= -1) {
                            Float value = Float.valueOf(sub);
                            if (i == -1) {
                                scale = value.floatValue();
                            } else {
                                values[i] = value.floatValue();
                            }
                        }
                        ++i;
                    }
                    return new IndexedScaler(scale, values);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            try {
                return Factory.valueOf(s);
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    public static class IndexedScaler
    implements Scaler {
        private final float scale;
        private final float[] keyValues;

        public IndexedScaler(float scale, float ... keyValues) {
            this.scale = scale;
            this.keyValues = keyValues;
        }

        public String store() {
            StringBuffer sb = new StringBuffer();
            sb.append("idx:");
            sb.append(this.scale);
            for (float f : this.keyValues) {
                sb.append(":");
                sb.append(f);
            }
            return sb.toString();
        }

        @Override
        public float scaleValue(float idx) {
            float idx_scaled = idx / this.scale;
            int idxi = (int)idx_scaled;
            float idxf = idx_scaled - (float)idxi;
            if (idxi < 0) {
                return this.keyValues[0];
            }
            if (idxi >= this.keyValues.length - 1) {
                return this.keyValues[this.keyValues.length - 1];
            }
            return (1.0f - idxf) * this.keyValues[idxi] + idxf * this.keyValues[idxi + 1];
        }
    }
}

