/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.packet;

import crazypants.enderio.conduit.ConnectionMode;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.packet.AbstractConduitPacket;
import crazypants.enderio.conduit.redstone.IRedstoneConduit;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketConnectionMode
extends AbstractConduitPacket<IConduit>
implements IMessageHandler<PacketConnectionMode, IMessage> {
    private EnumFacing dir;
    private ConnectionMode mode;

    public PacketConnectionMode() {
    }

    public PacketConnectionMode(IConduit con, EnumFacing dir) {
        super(con.getBundle().getEntity(), con);
        this.dir = dir;
        this.mode = con.getConnectionMode(dir);
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        if (this.dir != null) {
            buf.writeShort(this.dir.ordinal());
        } else {
            buf.writeShort(-1);
        }
        buf.writeShort(this.mode.ordinal());
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        short ord = buf.readShort();
        this.dir = ord < 0 ? null : EnumFacing.values()[ord];
        this.mode = ConnectionMode.values()[buf.readShort()];
    }

    public IMessage onMessage(PacketConnectionMode message, MessageContext ctx) {
        Object conduit = message.getTileCasted(ctx);
        if (conduit == null) {
            return null;
        }
        if (conduit instanceof IRedstoneConduit) {
            ((IRedstoneConduit)conduit).forceConnectionMode(message.dir, message.mode);
        } else {
            conduit.setConnectionMode(message.dir, message.mode);
        }
        IBlockState bs = message.getWorld(ctx).func_180495_p(message.getPos());
        message.getWorld(ctx).func_184138_a(message.getPos(), bs, bs, 3);
        return null;
    }
}

