/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.render;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import crazypants.enderio.conduit.ConnectionMode;
import crazypants.enderio.conduit.IConduitComponent;
import crazypants.enderio.render.IRenderMapper;
import crazypants.enderio.render.pipeline.BlockStateWrapperBase;
import crazypants.enderio.render.util.QuadCollector;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class BlockStateWrapperConduitBundle
extends BlockStateWrapperBase {
    private static final Cache<ConduitCacheKey, QuadCollector> cache = CacheBuilder.newBuilder().maximumSize(500L).expireAfterAccess(10L, TimeUnit.MINUTES).build();
    @Nonnull
    private final ConduitCacheKey cachekey = new ConduitCacheKey();

    public String toString() {
        String r = "BlockStateWrapperConduitBundle@" + Integer.toHexString(this.hashCode()) + " [cache=";
        for (Map.Entry e : cache.asMap().entrySet()) {
            r = r + "(" + e.getKey() + "=" + ((QuadCollector)e.getValue()).toString() + ") ";
        }
        return r + "]";
    }

    public BlockStateWrapperConduitBundle(IBlockState state, IBlockAccess world, BlockPos pos, IRenderMapper.IBlockRenderMapper renderMapper) {
        super(state, world, pos, renderMapper);
    }

    public BlockStateWrapperConduitBundle(BlockStateWrapperBase parent, IBlockState state) {
        super(parent, state);
    }

    public ConduitCacheKey getCachekey() {
        return this.cachekey;
    }

    @Override
    protected void putIntoCache(QuadCollector quads) {
        cache.put((Object)this.cachekey, (Object)quads);
    }

    @Override
    protected QuadCollector getFromCache() {
        return (QuadCollector)cache.getIfPresent((Object)this.cachekey);
    }

    public static void invalidate() {
        cache.invalidateAll();
    }

    @Override
    protected void addCacheKeyInternal(@Nonnull Object addlCacheKey) {
        super.addCacheKeyInternal(addlCacheKey);
        if (addlCacheKey instanceof IConduitComponent) {
            ((IConduitComponent)addlCacheKey).hashCodeForModelCaching(this, this.cachekey);
        } else if (addlCacheKey instanceof IBlockState) {
            this.cachekey.add(Block.field_176229_d.func_148747_b((Object)((IBlockState)addlCacheKey)));
        } else {
            this.cachekey.add(addlCacheKey);
        }
    }

    @Override
    protected void resetCacheKeyInternal() {
        super.resetCacheKeyInternal();
        this.cachekey.reset();
    }

    public static class ConduitCacheKey {
        private int idx = 0;
        private int hashCode = 1;
        private int[] hashCodes = new int[16];

        public void reset() {
            this.idx = 0;
            this.hashCode = 1;
        }

        public void add(Object o) {
            this.add(o.hashCode());
        }

        public void add(int i) {
            assert (this.hashCodes != null);
            if (this.idx == this.hashCodes.length) {
                this.hashCodes = Arrays.copyOf(this.hashCodes, this.hashCodes.length * 2);
            }
            this.hashCodes[this.idx++] = i;
            this.hashCode = 31 * this.hashCode + i;
        }

        public void addBoolean(Map<EnumFacing, Boolean> o) {
            assert (EnumFacing.values().length <= 7);
            int i = 0;
            for (EnumFacing face : EnumFacing.values()) {
                Boolean b = o.get(face);
                i = i << 1 | (b != null && b != false ? 1 : 0);
            }
            this.add(i);
        }

        public <T extends Enum<?>> void addEnum(Map<EnumFacing, T> o) {
            int i = 0;
            for (EnumFacing face : EnumFacing.values()) {
                Enum value = (Enum)o.get(face);
                assert (value == null || value.ordinal() < 31) : value.getClass();
                i = i << 5 | (value == null ? 31 : value.ordinal());
            }
            this.add(i);
        }

        public void add(Set<EnumFacing> o1, Set<EnumFacing> o2, Map<EnumFacing, ConnectionMode> o3) {
            assert (EnumFacing.values().length <= 7);
            int i = 0;
            for (EnumFacing face : EnumFacing.values()) {
                i = i << 1 | (o1.contains(face) ? 1 : 0);
                i = i << 1 | (o2.contains(face) ? 1 : 0);
                i = i << 3 | (o3.containsKey(face) ? o3.get(face).ordinal() : 7);
            }
            this.add(i);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ConduitCacheKey && ((ConduitCacheKey)obj).idx == this.idx) {
                assert (this.hashCodes != null);
                assert (((ConduitCacheKey)obj).hashCodes != null);
                for (int i = 0; i < this.idx; ++i) {
                    if (this.hashCodes[i] == ((ConduitCacheKey)obj).hashCodes[i]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public String toString() {
            return "ConduitCacheKey [idx=" + this.idx + ", hashCode=" + this.hashCode + ", hashCodes=" + Arrays.toString(this.hashCodes) + "]";
        }
    }
}

