/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.config.recipes.xml;

import crazypants.enderio.config.recipes.InvalidRecipeConfigException;
import crazypants.enderio.config.recipes.RecipeGameRecipe;
import crazypants.enderio.config.recipes.StaxFactory;
import crazypants.enderio.config.recipes.xml.ConfigReference;
import crazypants.enderio.config.recipes.xml.Dependency;
import crazypants.enderio.config.recipes.xml.Level;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;

public abstract class AbstractConditional
implements RecipeGameRecipe {
    private Level level;
    private List<ConfigReference> configReferences;
    private List<Dependency> dependencies;
    protected transient boolean valid;
    protected transient boolean active;

    @Override
    public Object readResolve() throws InvalidRecipeConfigException {
        this.active = true;
        if (this.configReferences != null) {
            for (ConfigReference configReference : this.configReferences) {
                if (configReference.isValid()) continue;
                this.active = false;
            }
        }
        if (this.level != null && !this.level.isValid()) {
            this.active = false;
        }
        if (this.dependencies != null) {
            for (Dependency dependency : this.dependencies) {
                if (dependency.isValid()) continue;
                this.active = false;
            }
        }
        return this;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public boolean setAttribute(StaxFactory factory, String name, String value) throws InvalidRecipeConfigException, XMLStreamException {
        return false;
    }

    @Override
    public boolean setElement(StaxFactory factory, String name, StartElement startElement) throws InvalidRecipeConfigException, XMLStreamException {
        if ("level".equals(name) && this.level == null) {
            this.level = factory.read(new Level(), startElement);
            return true;
        }
        if ("config".equals(name)) {
            if (this.configReferences == null) {
                this.configReferences = new ArrayList<ConfigReference>();
            }
            this.configReferences.add(factory.read(new ConfigReference(), startElement));
            return true;
        }
        if ("dependency".equals(name)) {
            if (this.dependencies == null) {
                this.dependencies = new ArrayList<Dependency>();
            }
            this.dependencies.add(factory.read(new Dependency(), startElement));
            return true;
        }
        return false;
    }
}

