/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.config.recipes.xml;

import crazypants.enderio.Log;
import crazypants.enderio.config.recipes.InvalidRecipeConfigException;
import crazypants.enderio.config.recipes.StaxFactory;
import crazypants.enderio.config.recipes.xml.AbstractConditional;
import crazypants.enderio.config.recipes.xml.AbstractCrafting;
import crazypants.enderio.config.recipes.xml.Casting;
import crazypants.enderio.config.recipes.xml.Crafting;
import crazypants.enderio.config.recipes.xml.Smelting;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;

public class Recipe
extends AbstractConditional {
    private String name;
    private boolean required;
    private boolean disabled;
    private List<AbstractCrafting> craftings;

    @Override
    public Object readResolve() throws InvalidRecipeConfigException {
        if (this.disabled) {
            return this;
        }
        try {
            super.readResolve();
            if (this.craftings == null || this.craftings.isEmpty()) {
                throw new InvalidRecipeConfigException("No <crafting>s or <smelting>s");
            }
        }
        catch (InvalidRecipeConfigException e) {
            throw new InvalidRecipeConfigException(e, "in recipe '" + this.getName() + "'");
        }
        return this;
    }

    @Override
    public void enforceValidity() throws InvalidRecipeConfigException {
        if (this.disabled || !this.active) {
            return;
        }
        try {
            int count = 0;
            for (AbstractCrafting crafting : this.craftings) {
                if (this.required) {
                    if (!crafting.isActive()) continue;
                    crafting.enforceValidity();
                    if (!crafting.isValid()) continue;
                    ++count;
                    continue;
                }
                if (!crafting.isActive() || !crafting.isValid()) continue;
                ++count;
            }
            if (count > 1) {
                throw new InvalidRecipeConfigException("Multiple active <crafting>s and/or <smelting>s");
            }
            if (count < 1) {
                if (this.required) {
                    throw new InvalidRecipeConfigException("No valid <crafting>s or <smelting>s");
                }
                Log.debug("No valid <crafting>s or <smelting>s in optional recipe '" + this.name + "'");
                this.valid = false;
            } else {
                this.valid = true;
            }
        }
        catch (InvalidRecipeConfigException e) {
            throw new InvalidRecipeConfigException(e, "in recipe '" + this.getName() + "'");
        }
    }

    @Override
    public void register() {
        if (!this.disabled && this.valid && this.active) {
            Log.debug("Registering XML recipe '" + this.getName() + "'");
            if (this.craftings != null) {
                for (AbstractCrafting crafting : this.craftings) {
                    if (!crafting.isValid() || !crafting.isActive()) continue;
                    crafting.register();
                    return;
                }
            }
        } else {
            Log.debug("Skipping XML recipe '" + this.getName() + "' (valid=" + this.valid + ", active=" + this.active + ", required=" + this.required + ", disabled=" + this.disabled + ")");
        }
    }

    public String getName() {
        if (this.name != null && !this.name.trim().isEmpty()) {
            return this.name.trim();
        }
        return "unnamed recipe";
    }

    @Override
    public boolean setAttribute(StaxFactory factory, String name, String value) throws InvalidRecipeConfigException, XMLStreamException {
        if ("name".equals(name)) {
            this.name = value;
            return true;
        }
        if ("required".equals(name)) {
            this.required = Boolean.parseBoolean(value);
            return true;
        }
        if ("disabled".equals(name)) {
            this.disabled = Boolean.parseBoolean(value);
            return true;
        }
        return super.setAttribute(factory, name, value);
    }

    @Override
    public boolean setElement(StaxFactory factory, String name, StartElement startElement) throws InvalidRecipeConfigException, XMLStreamException {
        if ("crafting".equals(name)) {
            if (this.craftings == null) {
                this.craftings = new ArrayList<AbstractCrafting>();
            }
            this.craftings.add(factory.read(new Crafting(), startElement));
            return true;
        }
        if ("smelting".equals(name)) {
            if (this.craftings == null) {
                this.craftings = new ArrayList<AbstractCrafting>();
            }
            this.craftings.add(factory.read(new Smelting(), startElement));
            return true;
        }
        if ("casting".equals(name)) {
            if (this.craftings == null) {
                this.craftings = new ArrayList<AbstractCrafting>();
            }
            this.craftings.add(factory.read(new Casting(), startElement));
            return true;
        }
        return super.setElement(factory, name, startElement);
    }

    @Override
    public boolean isValid() {
        return this.disabled || super.isValid();
    }

    @Override
    public boolean isActive() {
        return !this.disabled && super.isActive();
    }
}

