/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.diagnostics;

import crazypants.enderio.Log;
import crazypants.enderio.diagnostics.DiagnosticsRegistry;
import crazypants.enderio.diagnostics.IDiagnosticsTracker;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.API;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.ICrashCallable;
import net.minecraftforge.fml.common.ModAPIManager;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.relauncher.Side;

public class EnderIOCrashCallable
implements ICrashCallable {
    private static String[] stopScreenMessage = null;

    public static void create() {
        FMLCommonHandler.instance().registerCrashCallable((ICrashCallable)new EnderIOCrashCallable());
    }

    private List<String> collectData() {
        ArrayList<String> result = new ArrayList<String>();
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT && FMLClientHandler.instance().hasOptifine()) {
            result.add(" * Optifine is installed. This is NOT supported.");
        }
        for (ModContainer modContainer : ModAPIManager.INSTANCE.getAPIList()) {
            String apiVersionString = modContainer.getVersion();
            if (apiVersionString == null) {
                apiVersionString = "";
            }
            if ("appliedenergistics2|API".equals(modContainer.getModId())) {
                if ("rv1".equals(apiVersionString) || "rv2".equals(apiVersionString) || "rv3".equals(apiVersionString)) {
                    result.add(" * An unsupportted old AE2 API is installed (" + apiVersionString + " from " + modContainer.getSource().getName() + ").");
                    result.add("   Ender IO was build against API version rv4 and will NOT work with older versions.");
                    continue;
                }
                if ("rv4".equals(apiVersionString)) continue;
                result.add(" * An unknown AE2 API is installed (" + apiVersionString + " from " + modContainer.getSource().getName() + ").");
                result.add("   Ender IO was build against API version rv4 and may or may not work with a newer version.");
                continue;
            }
            if ("CoFHAPI|energy".equals(modContainer.getModId())) {
                if ("1.8-BuildCraft-Testing".equals(apiVersionString) || apiVersionString.contains("1.7")) {
                    result.add(" * An unsupportted RF API is installed (" + apiVersionString + " from " + modContainer.getSource().getName() + ").");
                    result.add("   Ender IO needs at least 1.4.0 and will NOT work with older versions.");
                    continue;
                }
                Package caep = Package.getPackage("cofh.api.energy");
                if (caep == null) continue;
                API api = caep.getAnnotation(API.class);
                if (api != null) {
                    String apiVersion = api.apiVersion();
                    if (apiVersion != null) {
                        if (apiVersion.equals(apiVersionString)) continue;
                        if ("1.8-BuildCraft-Testing".equals(apiVersion) || apiVersion.contains("1.7")) {
                            result.add(" * An unsupportted RF API is installed (" + apiVersion + " from (guessing) " + EnderIOCrashCallable.whereFrom("cofh.api.CoFHAPIProps") + ").");
                            result.add("   Ender IO needs at least 1.4.0 and will NOT work with older versions.");
                            continue;
                        }
                        result.add(" * The RF API that is being used (" + apiVersion + " from (guessing) " + EnderIOCrashCallable.whereFrom("cofh.api.CoFHAPIProps.class") + ") differes from that that is reported as being loaded (" + apiVersionString + " from " + modContainer.getSource().getName() + ").");
                        result.add("   It is a supported version, but that difference may lead to problems.");
                        continue;
                    }
                    result.add(" * The RF API that is being used has no version number. This may lead to problems.");
                    continue;
                }
                result.add(" * The RF API that is being used has no API annotation. This may lead to problems.");
                continue;
            }
            if (modContainer.getModId() == null || !modContainer.getModId().startsWith("EnderIOAPI")) continue;
            if (!"0.0.2".equals(apiVersionString)) {
                result.add(" * Another mod is shipping a version of our API that doesn't match our version (" + apiVersionString + " from " + modContainer.getSource().getName() + "). That may not actually work.");
                continue;
            }
            if (modContainer.getSource().getName() == null || modContainer.getSource().getName().startsWith("EnderIO") || modContainer.getSource().getName().startsWith("enderio") || modContainer.getSource().getName().equals("bin")) continue;
            result.add(" * Our API got loaded from " + modContainer.getSource().getName() + ". That's unexpected.");
        }
        String badBrand = null;
        for (String brand : FMLCommonHandler.instance().getModName().split(",")) {
            if (brand == null || brand.equals("fml") || brand.equals("forge")) continue;
            badBrand = badBrand == null ? brand : badBrand + ", " + brand;
        }
        if (badBrand != null) {
            result.add("An unsupported base software is installed: '" + badBrand + "'. This is NOT supported.");
        }
        return result;
    }

    public String call() throws Exception {
        Collection<IDiagnosticsTracker> trackers;
        String msg = "";
        List<String> data = this.collectData();
        if (data.isEmpty()) {
            msg = msg + "No known problems detected.\n";
        } else {
            msg = msg + "Found the following problem(s) with your installation (That does NOT mean that Ender IO caused the crash or was involved in it in any way. We add this information to help finding common problems, not as an invitation to post any crash you encounter to Ender IO's issue tracker. Always check the stack trace above to see which mod is most likely failing.):\n";
            for (String string : data) {
                msg = msg + "                 " + string + "\n";
            }
            msg = msg + "                 This may (look up the meaning of 'may' in the dictionary if you're not sure what it means) have caused the error. Try reproducing the crash WITHOUT this/these mod(s) before reporting it.\n";
        }
        msg = msg + "\tDetailed RF API diagnostics:\n";
        for (String string : EnderIOCrashCallable.rfDiagnostics()) {
            msg = msg + "                 " + string + "\n";
        }
        msg = msg + "\tDetailed Tesla API diagnostics:\n";
        for (String string : EnderIOCrashCallable.teslaDiagnostics()) {
            msg = msg + "                 " + string + "\n";
        }
        if (stopScreenMessage != null) {
            for (String s : stopScreenMessage) {
                msg = msg + s + "\n";
            }
        }
        if ((trackers = DiagnosticsRegistry.getActiveTrackers()) != null && !trackers.isEmpty()) {
            for (IDiagnosticsTracker tracker : trackers) {
                msg = msg + "\t" + tracker.getActivityDescription() + "\n";
                for (String string : tracker.getLines()) {
                    msg = msg + "                 " + string + "\n";
                }
            }
        }
        msg = msg + "\n";
        msg = msg + "\t!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n";
        msg = msg + "\t!!!You are looking at the diagnostics information, not at the crash. Scroll up!!!\n";
        msg = msg + "\t!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n";
        return msg;
    }

    public String getLabel() {
        return "EnderIO";
    }

    public static String whereFrom(String c) {
        if (c == null) {
            return null;
        }
        try {
            return EnderIOCrashCallable.whereFrom(Class.forName(c));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String whereFrom(Class<?> c) {
        if (c == null) {
            return null;
        }
        try {
            String name;
            URL resource;
            ClassLoader loader = c.getClassLoader();
            if (loader == null) {
                for (loader = ClassLoader.getSystemClassLoader(); loader != null && loader.getParent() != null; loader = loader.getParent()) {
                }
            }
            if (loader != null && (resource = loader.getResource((name = c.getCanonicalName()).replace(".", "/") + ".class")) != null) {
                return resource.toString();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "<unknown>";
    }

    public static List<String> rfDiagnostics() {
        ArrayList<String> result = new ArrayList<String>();
        EnderIOCrashCallable.apiDiagnostics(result, "RF", "cofh.api.energy.", "EnergyStorage", "IEnergyConnection", "IEnergyContainerItem", "IEnergyHandler", "IEnergyProvider", "IEnergyReceiver", "IEnergyStorage", "ItemEnergyContainer", "TileEnergyHandler");
        return result;
    }

    public static List<String> teslaDiagnostics() {
        ArrayList<String> result = new ArrayList<String>();
        EnderIOCrashCallable.apiDiagnostics(result, "Tesla", "net.darkhax.tesla.", "Tesla");
        EnderIOCrashCallable.apiDiagnostics(result, "Tesla", "net.darkhax.tesla.capability.", "TeslaCapabilities");
        EnderIOCrashCallable.apiDiagnostics(result, "Tesla", "net.darkhax.tesla.api.", "ITeslaConsumer", "ITeslaHolder", "ITeslaProducer");
        EnderIOCrashCallable.apiDiagnostics(result, "Tesla", "net.darkhax.tesla.api.implementation.", "BaseTeslaContainer", "BaseTeslaContainerProvider", "InfiniteTeslaConsumer", "InfiniteTeslaConsumerProvider", "InfiniteTeslaProducer", "InfiniteTeslaProducerProvider");
        return result;
    }

    public static void apiDiagnostics(List<String> result, String displayName, String prefix, String ... clazzes) {
        for (String clazz : clazzes) {
            try {
                Class<?> forName = Class.forName(prefix + clazz);
                result.add(" * " + displayName + " API class '" + clazz + "' is loaded from: " + EnderIOCrashCallable.whereFrom(forName));
            }
            catch (ClassNotFoundException e) {
                result.add(" * " + displayName + " API class '" + clazz + "' could not be loaded (reason: " + e + ")");
                if (!Log.LOGGER.isDebugEnabled()) continue;
                Log.debug("Hey, you wanted diagnostics output? Guess what you're not getting it. Too many people reported it as bug. Deal with it.");
            }
        }
    }

    public static void registerStopScreenMessage(String ... message) {
        stopScreenMessage = message;
    }
}

