/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.gui;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.client.gui.button.CycleButton;
import crazypants.enderio.EnderIO;
import crazypants.enderio.machine.IRedstoneModeControlable;
import crazypants.enderio.machine.PacketRedstoneMode;
import crazypants.enderio.machine.RedstoneControlMode;
import crazypants.enderio.network.PacketHandler;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class RedstoneModeButton<T extends TileEntity>
extends CycleButton<RedstoneControlMode.IconHolder> {
    private IRedstoneModeControlable model;
    private T te;
    private String tooltipKey = "enderio.gui.tooltip.redstoneControlMode";

    public RedstoneModeButton(IGuiScreen gui, int id, int x, int y, IRedstoneModeControlable model) {
        super(gui, id, x, y, RedstoneControlMode.IconHolder.class);
        this.model = model;
        this.setModeRaw(RedstoneControlMode.IconHolder.getFromMode(model.getRedstoneControlMode()));
    }

    public RedstoneModeButton(IGuiScreen gui, int id, int x, int y, T te) {
        this(gui, id, x, y, (IRedstoneModeControlable)te);
        this.te = te;
    }

    public void setModeRaw(RedstoneControlMode.IconHolder newMode) {
        if (this.model == null) {
            return;
        }
        super.setMode((Enum)newMode);
        this.setTooltipKey(this.tooltipKey);
    }

    public void setMode(RedstoneControlMode.IconHolder newMode) {
        if (this.model == null) {
            return;
        }
        this.setModeRaw(newMode);
        this.model.setRedstoneControlMode(((RedstoneControlMode.IconHolder)this.getMode()).getMode());
        if (this.te != null) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketRedstoneMode(this.te));
        }
    }

    public void setTooltipKey(String key) {
        this.tooltipKey = key;
        this.setToolTip(new String[]{EnderIO.lang.localizeExact(this.tooltipKey), ((RedstoneControlMode.IconHolder)this.getMode()).getTooltip()});
    }
}

