/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.integration.top;

import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.api.common.util.IProgressTile;
import com.enderio.core.api.common.util.ITankAccess;
import com.enderio.core.client.render.BoundingBox;
import crazypants.enderio.capability.EnderInventory;
import crazypants.enderio.capability.InventorySlot;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.machine.AbstractCapabilityMachineEntity;
import crazypants.enderio.machine.AbstractCapabilityPoweredMachineEntity;
import crazypants.enderio.machine.AbstractMachineEntity;
import crazypants.enderio.machine.AbstractPoweredTaskEntity;
import crazypants.enderio.machine.ContinuousTask;
import crazypants.enderio.machine.IIoConfigurable;
import crazypants.enderio.machine.IRedstoneModeControlable;
import crazypants.enderio.machine.IoMode;
import crazypants.enderio.machine.RedstoneControlMode;
import crazypants.enderio.machine.invpanel.chest.TileInventoryChest;
import crazypants.enderio.machine.obelisk.spawn.AbstractMobObelisk;
import crazypants.enderio.machine.painter.blocks.TileEntityPaintedBlock;
import crazypants.enderio.machine.ranged.IRanged;
import crazypants.enderio.machine.spawner.TilePoweredSpawner;
import crazypants.enderio.paint.IPaintable;
import crazypants.enderio.paint.PainterUtil2;
import crazypants.enderio.power.EnergyTank;
import crazypants.enderio.power.IInternalPoweredTile;
import crazypants.enderio.power.IPowerStorage;
import crazypants.enderio.xp.ExperienceContainer;
import crazypants.enderio.xp.IHaveExperience;
import crazypants.util.CapturedMob;
import crazypants.util.Prep;
import crazypants.util.UserIdent;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import mcjty.theoneprobe.api.IProbeHitData;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

class TOPData {
    boolean hasStatus;
    boolean hasProgress;
    boolean hasRF;
    boolean hasRedstone;
    boolean hasIOMode;
    boolean hasRange;
    boolean hasMobs;
    boolean hasXP;
    boolean hasRFIO;
    boolean hasItemFillLevel;
    boolean isActive;
    boolean isPowered;
    boolean redstoneControlStatus;
    boolean isPainted;
    float progress;
    long rf;
    long maxrf;
    long fillMax;
    long fillCur;
    int experienceLevel;
    int xpBarScaled;
    int maxRFIn;
    int maxRFOut;
    int avgRF;
    String redstoneTooltip;
    String sideName;
    String mobAction;
    IWidgetIcon redstoneIcon;
    IoMode ioMode;
    BoundingBox bounds;
    List<CapturedMob> mobs;
    ProgressResult progressResult = ProgressResult.NONE;
    List<ITankAccess.ITankData> tankData = null;
    ItemStack paint1 = null;
    ItemStack paint2 = null;
    UserIdent owner = null;

    public TOPData(TileEntity tileEntity, IProbeHitData hitData) {
        ExperienceContainer experienceContainer;
        Object te;
        if (tileEntity instanceof AbstractMachineEntity) {
            te = (AbstractMachineEntity)tileEntity;
            this.isActive = ((AbstractMachineEntity)te).isActive();
            this.hasStatus = true;
            this.owner = ((AbstractMachineEntity)te).getOwner();
        }
        if (tileEntity instanceof IPowerStorage) {
            te = (IPowerStorage)tileEntity;
            this.maxrf = te.getMaxEnergyStoredL();
            this.rf = te.getEnergyStoredL();
            te.getMaxInput();
            this.hasRF = this.maxrf > 0L;
            this.isPowered = this.hasRF;
            this.hasRFIO = this.hasRF;
            this.maxRFIn = te.getMaxInput();
            this.maxRFOut = te.getMaxOutput();
            this.avgRF = te.getAverageIOPerTick();
        } else if (tileEntity instanceof IInternalPoweredTile) {
            te = (IInternalPoweredTile)tileEntity;
            if (te.displayPower()) {
                this.maxrf = te.getMaxEnergyStored(null);
                this.rf = te.getEnergyStored(null);
                this.isPowered = this.rf > 0L;
                this.hasRF = this.maxrf > 0L;
            }
        } else if (tileEntity instanceof AbstractCapabilityPoweredMachineEntity) {
            EnergyTank energy = ((AbstractCapabilityPoweredMachineEntity)tileEntity).getEnergy();
            this.maxrf = energy.getMaxEnergyStored();
            this.rf = energy.getEnergyStored();
            this.isPowered = this.rf > 0L;
            boolean bl = this.hasRF = this.maxrf > 0L;
        }
        if (tileEntity instanceof IProgressTile) {
            IProgressTile progressTile = (IProgressTile)tileEntity;
            this.progress = progressTile.getProgress();
            this.hasProgress = true;
            if (tileEntity instanceof AbstractPoweredTaskEntity) {
                AbstractPoweredTaskEntity te2 = (AbstractPoweredTaskEntity)tileEntity;
                if (te2.getCurrentTask() instanceof ContinuousTask) {
                    this.hasProgress = false;
                }
            } else if (tileEntity instanceof IConduitBundle) {
                this.hasProgress = false;
            }
        }
        if (tileEntity instanceof IRedstoneModeControlable) {
            te = (IRedstoneModeControlable)tileEntity;
            RedstoneControlMode redstoneControlMode = te.getRedstoneControlMode();
            this.redstoneControlStatus = te.getRedstoneControlStatus();
            RedstoneControlMode.IconHolder iconHolder = RedstoneControlMode.IconHolder.getFromMode(redstoneControlMode);
            this.redstoneIcon = iconHolder.getIcon();
            this.redstoneTooltip = iconHolder.getTooltip();
            this.hasRedstone = true;
        }
        if (tileEntity instanceof IIoConfigurable) {
            te = (IIoConfigurable)tileEntity;
            this.sideName = hitData.getSideHit().name().toLowerCase(Locale.US);
            this.ioMode = te.getIoMode(hitData.getSideHit());
            this.hasIOMode = true;
        }
        if (tileEntity instanceof IRanged) {
            te = (IRanged)tileEntity;
            this.bounds = te.getBounds();
            boolean bl = this.hasRange = this.bounds != null;
        }
        if (tileEntity instanceof AbstractMobObelisk) {
            te = (AbstractMobObelisk)tileEntity;
            this.mobs = ((AbstractMobObelisk)te).getMobsInFilter();
            this.mobAction = ((AbstractMobObelisk)te).getSpawnObeliskAction().getActionString();
            this.hasMobs = true;
        }
        if (tileEntity instanceof TilePoweredSpawner && ((TilePoweredSpawner)tileEntity).hasEntity()) {
            this.mobs = Collections.singletonList(((TilePoweredSpawner)tileEntity).getEntity());
            this.mobAction = AbstractMobObelisk.SpawnObeliskAction.SPAWN.getActionString();
            this.hasMobs = true;
        }
        if (tileEntity instanceof ITankAccess.IExtendedTankAccess) {
            this.tankData = ((ITankAccess.IExtendedTankAccess)tileEntity).getTankDisplayData();
        }
        if (tileEntity instanceof IHaveExperience && (experienceContainer = ((IHaveExperience)tileEntity).getContainer()) != null) {
            this.hasXP = true;
            this.experienceLevel = experienceContainer.getExperienceLevel();
            this.xpBarScaled = experienceContainer.getXpBarScaled(100);
        }
        if (tileEntity instanceof IPaintable.IPaintableTileEntity) {
            this.paint1 = PainterUtil2.getPaintAsStack(((IPaintable.IPaintableTileEntity)tileEntity).getPaintSource());
            if (tileEntity instanceof TileEntityPaintedBlock.TileEntityTwicePaintedBlock) {
                this.paint2 = PainterUtil2.getPaintAsStack(((TileEntityPaintedBlock.TileEntityTwicePaintedBlock)tileEntity).getPaintSource2());
            }
            boolean bl = this.isPainted = this.paint1 != null || this.paint2 != null;
        }
        if (tileEntity instanceof TileInventoryChest) {
            this.fillCur = 0L;
            this.fillMax = 0L;
            for (InventorySlot slot : ((AbstractCapabilityMachineEntity)tileEntity).getInventory().getView(EnderInventory.Type.INOUT)) {
                if (Prep.isValid(slot.getStackInSlot(0))) {
                    this.fillMax += (long)Math.min(slot.getMaxStackSize(), slot.getStackInSlot(0).func_77976_d());
                    this.fillCur += (long)slot.getStackInSlot((int)0).field_77994_a;
                    continue;
                }
                this.fillMax += (long)slot.getMaxStackSize();
            }
            this.hasItemFillLevel = true;
        }
        this.calculateProgress();
    }

    private void calculateProgress() {
        if (this.hasProgress) {
            this.progressResult = this.progress > 0.0f ? (this.hasRF && !this.isPowered ? ProgressResult.PROGRESS_NO_POWER : ProgressResult.PROGRESS) : (this.hasStatus && this.isActive ? ProgressResult.PROGRESS_ACTIVE : ProgressResult.PROGRESS_IDLE);
        } else if (this.hasStatus) {
            this.progressResult = this.isActive ? ProgressResult.NO_PROGRESS_ACTIVE : ProgressResult.NO_PROGRESS_IDLE;
        }
    }

    static enum ProgressResult {
        NONE,
        PROGRESS,
        PROGRESS_ACTIVE,
        PROGRESS_NO_POWER,
        PROGRESS_IDLE,
        NO_PROGRESS_ACTIVE,
        NO_PROGRESS_IDLE;

    }
}

