/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine;

import crazypants.enderio.capability.EnderInventory;
import crazypants.enderio.capability.InventorySlot;
import crazypants.enderio.capability.ItemTools;
import crazypants.enderio.machine.AbstractMachineEntity;
import crazypants.util.Prep;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

@Storable
public abstract class AbstractCapabilityMachineEntity
extends AbstractMachineEntity {
    @Store
    private final EnderInventory inventory = new EnderInventory();
    private final EnderInventory inventoryDelegate;
    private final EnderInventory.View upgradeSlots;
    private final EnderInventory.View inputSlots;
    private final EnderInventory.View outputSlots;

    protected AbstractCapabilityMachineEntity() {
        this(null);
    }

    protected AbstractCapabilityMachineEntity(EnderInventory subclassInventory) {
        this.inventoryDelegate = subclassInventory != null ? subclassInventory : this.inventory;
        this.upgradeSlots = this.inventoryDelegate.getView(EnderInventory.Type.UPGRADE);
        this.inputSlots = this.inventoryDelegate.getView(EnderInventory.Type.INPUT);
        this.outputSlots = this.inventoryDelegate.getView(EnderInventory.Type.OUTPUT);
        this.inventoryDelegate.setOwner((TileEntity)this);
    }

    public EnderInventory getInventory() {
        return this.inventoryDelegate;
    }

    public boolean isValidUpgrade(@Nonnull ItemStack itemstack) {
        for (InventorySlot slot : this.upgradeSlots) {
            if (!slot.isItemValidForSlot(itemstack)) continue;
            return true;
        }
        return false;
    }

    public boolean isValidInput(@Nonnull ItemStack itemstack) {
        for (InventorySlot slot : this.inputSlots) {
            if (!slot.isItemValidForSlot(itemstack)) continue;
            return true;
        }
        return false;
    }

    public boolean isValidOutput(@Nonnull ItemStack itemstack) {
        for (InventorySlot slot : this.outputSlots) {
            if (!slot.isItemValidForSlot(itemstack)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean doPush(@Nullable EnumFacing dir) {
        if (dir == null || this.outputSlots.getSlots() <= 0 || !this.shouldDoWorkThisTick(20)) {
            return false;
        }
        ItemTools.MoveResult res = ItemTools.move(this.getPushLimit(), (IBlockAccess)this.field_145850_b, this.func_174877_v(), dir, this.func_174877_v().func_177972_a(dir), dir.func_176734_d());
        return res == ItemTools.MoveResult.MOVED;
    }

    @Override
    protected boolean doPull(@Nullable EnumFacing dir) {
        if (dir == null || this.inputSlots.getSlots() <= 0 || !this.shouldDoWorkThisTick(20) || !this.hasSpaceToPull()) {
            return false;
        }
        ItemTools.MoveResult res = ItemTools.move(this.getPullLimit(), (IBlockAccess)this.field_145850_b, this.func_174877_v().func_177972_a(dir), dir.func_176734_d(), this.func_174877_v(), dir);
        return res == ItemTools.MoveResult.MOVED;
    }

    protected boolean hasSpaceToPull() {
        for (InventorySlot slot : this.inputSlots) {
            ItemStack stack = slot.getStackInSlot(0);
            if (!Prep.isInvalid(stack) && stack.field_77994_a >= Math.min(stack.func_77976_d(), slot.getMaxStackSize())) continue;
            return true;
        }
        return false;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facingIn) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facingIn);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facingIn) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)new Side(facingIn);
        }
        return (T)super.getCapability(capability, facingIn);
    }

    private class Side
    implements IItemHandler {
        private final EnumFacing side;

        protected Side(EnumFacing side) {
            this.side = side;
        }

        @Nonnull
        private IItemHandler getView() {
            if (this.side == null) {
                return AbstractCapabilityMachineEntity.this.getInventory().getView(EnderInventory.Type.INTERNAL);
            }
            switch (AbstractCapabilityMachineEntity.this.getIoMode(this.side)) {
                case NONE: 
                case PUSH_PULL: {
                    return AbstractCapabilityMachineEntity.this.getInventory().getView(EnderInventory.Type.INOUT);
                }
                case PULL: {
                    return AbstractCapabilityMachineEntity.this.getInventory().getView(EnderInventory.Type.INPUT);
                }
                case PUSH: {
                    return AbstractCapabilityMachineEntity.this.getInventory().getView(EnderInventory.Type.OUTPUT);
                }
            }
            return EnderInventory.OFF;
        }

        public int getSlots() {
            return this.getView().getSlots();
        }

        public ItemStack getStackInSlot(int slot) {
            return this.getView().getStackInSlot(slot);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (Prep.isInvalid(stack)) {
                return Prep.getEmpty();
            }
            return this.getView().insertItem(slot, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.getView().extractItem(slot, amount, simulate);
        }
    }
}

